
#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Reflection;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

using VBECSDateTime = gov.va.med.vbecs.BOL.VBECSDateTime;

using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

using BLOODUNITTEST = gov.va.med.vbecs.Common.VbecsTables.BloodUnitTest;
using ORDEREDTEST = gov.va.med.vbecs.Common.VbecsTables.OrderedTest;
using PATIENTTRANSFUSION = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusion;
using PATIENTTRANSFUSIONCOMMENT = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusionComment;
using PATIENTTRANSFUSIONREACTION = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusionReaction;
using PATIENTTRANSFUSIONREACTIONSYMPTOM = gov.va.med.vbecs.Common.VbecsTables.PatientTransfusionReactionSymptom;
using PATIENTSPECIMEN = gov.va.med.vbecs.Common.VbecsTables.PatientSpecimen;
using SPECIMENTEST = gov.va.med.vbecs.Common.VbecsTables.SpecimenTest;
using TRANSFUSIONREACTION = gov.va.med.vbecs.Common.VbecsTables.TransfusionReaction;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmTransfusionReactionWorkup
	/// </summary>
	public class FrmTransfusionReactionWorkup : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Form controls
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader2;
        private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.GroupBox grpImage;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSpecimenOK;
		private System.Windows.Forms.TabControl tabTRW;
		private System.Windows.Forms.TabPage pageSpecimenChecks;
		private System.Windows.Forms.GroupBox grpPostTransfusionSpecimen;
		private System.Windows.Forms.GroupBox grpPostTransfusionAvailable;
		private System.Windows.Forms.PictureBox picPostScanner;
		private System.Windows.Forms.Label lblPostSpecimenUID;
		private System.Windows.Forms.TextBox txtPostSpecimenUID;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPostHemolysis;
		private System.Windows.Forms.Label lblPostHemolysis;
		private System.Windows.Forms.GroupBox grpPostClericalCheck;
		private System.Windows.Forms.RadioButton rdoPostClericalCheckFail;
		private System.Windows.Forms.RadioButton rdoPostClericalCheckOK;
		private System.Windows.Forms.GroupBox grpPostTransfusionNotAvailable;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPostComment;
		private System.Windows.Forms.TextBox txtPostDetails;
		private System.Windows.Forms.Label lblPostComment;
		private System.Windows.Forms.Label lblPostDetails;
		private System.Windows.Forms.GroupBox grpPreTransfusionSpecimen;
		private System.Windows.Forms.GroupBox grpPreTransfusionAvailable;
		private System.Windows.Forms.PictureBox picPreScanner;
		private System.Windows.Forms.Label lblPreSpecimenUID;
		private System.Windows.Forms.TextBox txtPreSpecimenUID;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPreHemolysis;
		private System.Windows.Forms.Label lblPreHemolysis;
		private System.Windows.Forms.GroupBox grpPreClericalCheck;
		private System.Windows.Forms.RadioButton rdoPreClericalCheckFail;
		private System.Windows.Forms.RadioButton rdoPreClericalCheckOK;
		private System.Windows.Forms.GroupBox grpPreTransfusionNotAvailable;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPreComment;
		private System.Windows.Forms.TextBox txtPreDetails;
		private System.Windows.Forms.Label lblPreComment;
		private System.Windows.Forms.Label lblPreDetails;
		private System.Windows.Forms.TabPage pageSymptoms;
		private System.Windows.Forms.Label lblSymptomDetails;
		private System.Windows.Forms.TextBox txtSymptomDetails;
		private System.Windows.Forms.TabPage pageImplicatedUnits;
		private System.Windows.Forms.Button btnClearUnit;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAddUnit;
		private gov.va.med.vbecs.GUI.controls.ProductCodeTextbox txtProduct;
		private gov.va.med.vbecs.GUI.controls.UnitIDTextbox txtUnitID;
		private System.Windows.Forms.PictureBox picUnitIDScanner;
		private System.Windows.Forms.PictureBox picProductScanner;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.Label lblProduct;
		private System.Windows.Forms.GroupBox grpBagNotReturned;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnUnitsOK;
		private System.Windows.Forms.GroupBox grpImplicatedUnits;
		private System.Windows.Forms.ListView lvImplicatedUnits;
		private System.Windows.Forms.TabPage pageSerolgicTests;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnTestsOK;
		private System.Windows.Forms.DateTimePicker dtpDateNoted;
		private System.Windows.Forms.Label lblDateNoted;
		private System.Windows.Forms.GroupBox grpTRWDates;
		private System.Windows.Forms.DateTimePicker dtpDateInvestigated;
		private System.Windows.Forms.Label lblDateInvestigated;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnSymptomsOK;
		private System.Windows.Forms.GroupBox grpSymptoms;
		private System.Windows.Forms.GroupBox grpIdentifyUnits;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbUnitHemolysis;
		private System.Windows.Forms.Label lblUnitHemolysis;
		private System.Windows.Forms.RadioButton rdoBagCheckFail;
		private System.Windows.Forms.RadioButton rdoBagCheckOK;
		private System.Windows.Forms.RadioButton rdoPreTransfusionAvailable;
		private System.Windows.Forms.RadioButton rdoPreTransfusionNotAvailable;
		private System.Windows.Forms.RadioButton rdoPostTransfusionNotAvailable;
		private System.Windows.Forms.GroupBox grpImplicatedUnit;
		private System.Windows.Forms.TextBox txtBagNotReturnedComment;
		private System.Windows.Forms.GroupBox grpBloodBagChecks;
		private System.Windows.Forms.GroupBox grpImplicatedUnitsIdentified;
		private System.Windows.Forms.RadioButton rdoImplicatedUnitsIdentified;
		private System.Windows.Forms.RadioButton rdoNoImplicatedUnitsIdentified;
		private System.Windows.Forms.GroupBox grpBloodBagReturned;
		private System.Windows.Forms.RadioButton rdoBloodBagReturned;
		private System.Windows.Forms.RadioButton rdoBloodBagNotReturned;
		private System.Windows.Forms.GroupBox grpBloodBagClericalChecks;
		private System.Windows.Forms.GroupBox grpSymptomsIdentified;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.Panel pnlPreSpecimenComments;
		private System.Windows.Forms.Label lblPreSpecimenComments;
		private System.Windows.Forms.TextBox txtPreSpecimenComments;
		private System.Windows.Forms.Panel pnlPostSpecimenComments;
		private System.Windows.Forms.Label lblPostSpecimenComments;
		private System.Windows.Forms.TextBox txtPostSpecimenComments;
		private System.Windows.Forms.GroupBox grpBagComment;
		private System.Windows.Forms.TextBox txtBagComment;
		private System.Windows.Forms.CheckedListBox clbSymptoms;
		private System.Windows.Forms.GroupBox grpAutomatedInstrument;
		private System.Windows.Forms.TextBox txtInstrumentName;
		private System.Windows.Forms.Label lblInstrumentName;
		private System.Windows.Forms.Label lblRack;
		private System.Windows.Forms.Label lblTestedBy;
		private System.Windows.Forms.Label lblDateTested;
		private System.Windows.Forms.CheckBox cbABORh;
		private System.Windows.Forms.GroupBox grpABORh;
		private System.Windows.Forms.Panel pnlABORh;
		private System.Windows.Forms.Label lblRhInterp;
		private System.Windows.Forms.Label lblABOInterp;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.Label lblPreABORh;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPreABOInterp;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPreRhInterp;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPostRhInterp;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPostABOInterp;
		private System.Windows.Forms.Label lblPostABORh;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbUnitRhInterp1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbUnitABOInterp1;
		private System.Windows.Forms.Label lblUnitABORh1;
		private System.Windows.Forms.GroupBox grpABS;
		private System.Windows.Forms.Panel pnlABS;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPostABSInterp;
		private System.Windows.Forms.Label lblPostABS;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPreABSInterp;
		private System.Windows.Forms.Label lblPreABS;
		private System.Windows.Forms.Label lblABS;
		private System.Windows.Forms.Label lblABSInterp;
		private System.Windows.Forms.CheckBox cbABS;
		private System.Windows.Forms.CheckBox cbDAT;
		private System.Windows.Forms.GroupBox grpDAT;
		private System.Windows.Forms.Panel pnlDAT;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPostDATInterp;
		private System.Windows.Forms.Label lblPostDAT;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPreDATInterp;
		private System.Windows.Forms.Label lblPreDAT;
		private System.Windows.Forms.Label lblDAT;
		private System.Windows.Forms.Label lblDATInterp;
		private System.Windows.Forms.CheckBox cbXM;
		private System.Windows.Forms.GroupBox grpXM;
		private System.Windows.Forms.Panel pnlXM;
		private System.Windows.Forms.Label lblUnitXM1;
		private System.Windows.Forms.Label lblXM;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbUnitPostXMInterp1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbUnitPreXMInterp1;
		private System.Windows.Forms.RadioButton rdoPostTransfusionAvailable;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnInvalidateTRW;
		private System.Windows.Forms.RadioButton rdoSymptomsIdentified;
		private System.Windows.Forms.RadioButton rdoNoSymptomsIdentified;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.Panel pnlABO;
		private System.Windows.Forms.Panel pnlRh;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.Panel pnlSpecimenChecks;
		private System.Windows.Forms.Panel pnlImplicatedUnits;
		private System.Windows.Forms.Panel pnlSymptoms;
		private System.Windows.Forms.Panel pnlSerologicTests;
		private System.Windows.Forms.DateTimePicker dtpDateTested;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbRack;
		private System.Windows.Forms.Panel pnlPreXM;
		private System.Windows.Forms.Panel pnlPostXM;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPreSpecimenComments;
		private System.Windows.Forms.Label lblPreSpecimenDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPostSpecimenComments;
		private System.Windows.Forms.Label lblPostSpecimenDetails;
		private System.Windows.Forms.Label lblBagComment;
		private System.Windows.Forms.Label lblBagDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbBagComment;
		private System.Windows.Forms.Label lblBagNotReturnedDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbBagNotReturnedComment;
		private System.Windows.Forms.Label lblBagNotReturnedComment;
		private System.Windows.Forms.Label lblPostXMInterp;
		private System.Windows.Forms.Label lblPreXMInterp;
		private System.Windows.Forms.Panel pnlXMLabels;
		private System.Windows.Forms.Panel pnlXMMiddle;
		private System.Windows.Forms.Panel pnlXMRight;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnFinalizePrint;
		private System.Windows.Forms.CheckBox cbInstrumentQCd;
		private System.Windows.Forms.CheckBox cbAutomatedInstrument;
		private System.Windows.Forms.Label lblTestComment;
		private System.Windows.Forms.Label lblTestDetails;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestComment;
		private System.Windows.Forms.TextBox txtTestDetails;
		private System.Windows.Forms.Label lblCompleteMessage4;
		private System.Windows.Forms.Label lblCompleteMessage3;
		private System.Windows.Forms.Label lblCompleteMessage2;
		private System.Windows.Forms.Label lblCompleteMessage1;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;
		#endregion 

		#region Constructors/Dispose

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="orderedTest"></param>
		public FrmTransfusionReactionWorkup(BOL.OrderedTest orderedTest)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC021RecordTransfusionReactionWorkup;

			// This call is required by the Windows Form Designer.
			InitializeComponent();

			using (new WaitCursor())
			{
				this._orderedTest = orderedTest;
				this._orderedTestSpecimenGuid = orderedTest.Specimen.SpecimenGuid;
				//
				LoadInitialObjects();			//Locks are checked for and set here...
                if (this.LockController.LockingConflict) return;    //this is set if the lock fails, so need to get out

				SetComponentProperties();

				PopulateSpecimenChecksTab();

				PopulateImplicatedUnitsTab();

				PopulateSymptomsTab();
			
				PopulateSerologicTestsTab();

				this._codabarProductCode = Common.RegularExpressions.CodabarProductCode();
				this._codabarUnitID = Common.RegularExpressions.PooledCodabarEyeReadableUnitId();		//CHANGE 07/25/2005
				this._isbtProductCode = Common.RegularExpressions.ISBT128ProductCode();
				this._isbtUnitID = Common.RegularExpressions.ISBT128UnitID();

				this.IsDirty = false;
				//
				this.btnInvalidateTRW.EnabledButton = ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete);
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmTransfusionReactionWorkup));
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnSpecimenOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.tabTRW = new System.Windows.Forms.TabControl();
            this.pageSpecimenChecks = new System.Windows.Forms.TabPage();
            this.pnlSpecimenChecks = new System.Windows.Forms.Panel();
            this.lblCompleteMessage1 = new System.Windows.Forms.Label();
            this.grpPostTransfusionSpecimen = new System.Windows.Forms.GroupBox();
            this.rdoPostTransfusionAvailable = new System.Windows.Forms.RadioButton();
            this.rdoPostTransfusionNotAvailable = new System.Windows.Forms.RadioButton();
            this.grpPreTransfusionSpecimen = new System.Windows.Forms.GroupBox();
            this.rdoPreTransfusionAvailable = new System.Windows.Forms.RadioButton();
            this.rdoPreTransfusionNotAvailable = new System.Windows.Forms.RadioButton();
            this.grpPostTransfusionAvailable = new System.Windows.Forms.GroupBox();
            this.picPostScanner = new System.Windows.Forms.PictureBox();
            this.lblPostSpecimenUID = new System.Windows.Forms.Label();
            this.txtPostSpecimenUID = new System.Windows.Forms.TextBox();
            this.cmbPostHemolysis = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPostHemolysis = new System.Windows.Forms.Label();
            this.grpPostClericalCheck = new System.Windows.Forms.GroupBox();
            this.rdoPostClericalCheckFail = new System.Windows.Forms.RadioButton();
            this.rdoPostClericalCheckOK = new System.Windows.Forms.RadioButton();
            this.pnlPostSpecimenComments = new System.Windows.Forms.Panel();
            this.lblPostSpecimenDetails = new System.Windows.Forms.Label();
            this.cmbPostSpecimenComments = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPostSpecimenComments = new System.Windows.Forms.Label();
            this.txtPostSpecimenComments = new System.Windows.Forms.TextBox();
            this.grpPostTransfusionNotAvailable = new System.Windows.Forms.GroupBox();
            this.cmbPostComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.txtPostDetails = new System.Windows.Forms.TextBox();
            this.lblPostComment = new System.Windows.Forms.Label();
            this.lblPostDetails = new System.Windows.Forms.Label();
            this.grpPreTransfusionAvailable = new System.Windows.Forms.GroupBox();
            this.pnlPreSpecimenComments = new System.Windows.Forms.Panel();
            this.cmbPreSpecimenComments = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPreSpecimenComments = new System.Windows.Forms.Label();
            this.txtPreSpecimenComments = new System.Windows.Forms.TextBox();
            this.lblPreSpecimenDetails = new System.Windows.Forms.Label();
            this.picPreScanner = new System.Windows.Forms.PictureBox();
            this.lblPreSpecimenUID = new System.Windows.Forms.Label();
            this.txtPreSpecimenUID = new System.Windows.Forms.TextBox();
            this.cmbPreHemolysis = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPreHemolysis = new System.Windows.Forms.Label();
            this.grpPreClericalCheck = new System.Windows.Forms.GroupBox();
            this.rdoPreClericalCheckFail = new System.Windows.Forms.RadioButton();
            this.rdoPreClericalCheckOK = new System.Windows.Forms.RadioButton();
            this.grpPreTransfusionNotAvailable = new System.Windows.Forms.GroupBox();
            this.cmbPreComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.txtPreDetails = new System.Windows.Forms.TextBox();
            this.lblPreComment = new System.Windows.Forms.Label();
            this.lblPreDetails = new System.Windows.Forms.Label();
            this.pageSymptoms = new System.Windows.Forms.TabPage();
            this.pnlSymptoms = new System.Windows.Forms.Panel();
            this.lblCompleteMessage3 = new System.Windows.Forms.Label();
            this.btnSymptomsOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpSymptoms = new System.Windows.Forms.GroupBox();
            this.clbSymptoms = new System.Windows.Forms.CheckedListBox();
            this.lblSymptomDetails = new System.Windows.Forms.Label();
            this.txtSymptomDetails = new System.Windows.Forms.TextBox();
            this.grpSymptomsIdentified = new System.Windows.Forms.GroupBox();
            this.rdoSymptomsIdentified = new System.Windows.Forms.RadioButton();
            this.rdoNoSymptomsIdentified = new System.Windows.Forms.RadioButton();
            this.pageImplicatedUnits = new System.Windows.Forms.TabPage();
            this.pnlImplicatedUnits = new System.Windows.Forms.Panel();
            this.lblCompleteMessage2 = new System.Windows.Forms.Label();
            this.grpImplicatedUnitsIdentified = new System.Windows.Forms.GroupBox();
            this.rdoImplicatedUnitsIdentified = new System.Windows.Forms.RadioButton();
            this.rdoNoImplicatedUnitsIdentified = new System.Windows.Forms.RadioButton();
            this.grpIdentifyUnits = new System.Windows.Forms.GroupBox();
            this.grpBloodBagReturned = new System.Windows.Forms.GroupBox();
            this.rdoBloodBagReturned = new System.Windows.Forms.RadioButton();
            this.rdoBloodBagNotReturned = new System.Windows.Forms.RadioButton();
            this.grpImplicatedUnit = new System.Windows.Forms.GroupBox();
            this.picUnitIDScanner = new System.Windows.Forms.PictureBox();
            this.txtProduct = new gov.va.med.vbecs.GUI.controls.ProductCodeTextbox(this.components);
            this.txtUnitID = new gov.va.med.vbecs.GUI.controls.UnitIDTextbox(this.components);
            this.lblProduct = new System.Windows.Forms.Label();
            this.picProductScanner = new System.Windows.Forms.PictureBox();
            this.lblUnitID = new System.Windows.Forms.Label();
            this.btnClearUnit = new System.Windows.Forms.Button();
            this.btnAddUnit = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpBloodBagChecks = new System.Windows.Forms.GroupBox();
            this.grpBloodBagClericalChecks = new System.Windows.Forms.GroupBox();
            this.rdoBagCheckFail = new System.Windows.Forms.RadioButton();
            this.rdoBagCheckOK = new System.Windows.Forms.RadioButton();
            this.cmbUnitHemolysis = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblUnitHemolysis = new System.Windows.Forms.Label();
            this.grpBagComment = new System.Windows.Forms.GroupBox();
            this.cmbBagComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.txtBagComment = new System.Windows.Forms.TextBox();
            this.lblBagComment = new System.Windows.Forms.Label();
            this.lblBagDetails = new System.Windows.Forms.Label();
            this.grpBagNotReturned = new System.Windows.Forms.GroupBox();
            this.cmbBagNotReturnedComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblBagNotReturnedComment = new System.Windows.Forms.Label();
            this.txtBagNotReturnedComment = new System.Windows.Forms.TextBox();
            this.lblBagNotReturnedDetails = new System.Windows.Forms.Label();
            this.btnUnitsOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.grpImplicatedUnits = new System.Windows.Forms.GroupBox();
            this.lvImplicatedUnits = new System.Windows.Forms.ListView();
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader7 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageSerolgicTests = new System.Windows.Forms.TabPage();
            this.pnlSerologicTests = new System.Windows.Forms.Panel();
            this.lblCompleteMessage4 = new System.Windows.Forms.Label();
            this.txtTestDetails = new System.Windows.Forms.TextBox();
            this.cmbTestComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblTestDetails = new System.Windows.Forms.Label();
            this.lblTestComment = new System.Windows.Forms.Label();
            this.cbAutomatedInstrument = new System.Windows.Forms.CheckBox();
            this.cmbRack = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbTestedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.dtpDateTested = new System.Windows.Forms.DateTimePicker();
            this.cbDAT = new System.Windows.Forms.CheckBox();
            this.lblRack = new System.Windows.Forms.Label();
            this.lblTestedBy = new System.Windows.Forms.Label();
            this.cbXM = new System.Windows.Forms.CheckBox();
            this.grpXM = new System.Windows.Forms.GroupBox();
            this.pnlXM = new System.Windows.Forms.Panel();
            this.pnlXMRight = new System.Windows.Forms.Panel();
            this.pnlPostXM = new System.Windows.Forms.Panel();
            this.cmbUnitPostXMInterp1 = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPostXMInterp = new System.Windows.Forms.Label();
            this.pnlXMMiddle = new System.Windows.Forms.Panel();
            this.pnlPreXM = new System.Windows.Forms.Panel();
            this.cmbUnitPreXMInterp1 = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPreXMInterp = new System.Windows.Forms.Label();
            this.pnlXMLabels = new System.Windows.Forms.Panel();
            this.lblXM = new System.Windows.Forms.Label();
            this.lblUnitXM1 = new System.Windows.Forms.Label();
            this.btnTestsOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.cbABORh = new System.Windows.Forms.CheckBox();
            this.cbABS = new System.Windows.Forms.CheckBox();
            this.lblDateTested = new System.Windows.Forms.Label();
            this.grpABORh = new System.Windows.Forms.GroupBox();
            this.pnlABORh = new System.Windows.Forms.Panel();
            this.pnlABO = new System.Windows.Forms.Panel();
            this.cmbPreABOInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbUnitABOInterp1 = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbPostABOInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblUnitABORh1 = new System.Windows.Forms.Label();
            this.lblPostABORh = new System.Windows.Forms.Label();
            this.lblPreABORh = new System.Windows.Forms.Label();
            this.lblABORh = new System.Windows.Forms.Label();
            this.lblABOInterp = new System.Windows.Forms.Label();
            this.lblRhInterp = new System.Windows.Forms.Label();
            this.pnlRh = new System.Windows.Forms.Panel();
            this.cmbUnitRhInterp1 = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbPostRhInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbPreRhInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.grpAutomatedInstrument = new System.Windows.Forms.GroupBox();
            this.cbInstrumentQCd = new System.Windows.Forms.CheckBox();
            this.txtInstrumentName = new System.Windows.Forms.TextBox();
            this.lblInstrumentName = new System.Windows.Forms.Label();
            this.grpABS = new System.Windows.Forms.GroupBox();
            this.pnlABS = new System.Windows.Forms.Panel();
            this.cmbPostABSInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPostABS = new System.Windows.Forms.Label();
            this.cmbPreABSInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPreABS = new System.Windows.Forms.Label();
            this.lblABS = new System.Windows.Forms.Label();
            this.lblABSInterp = new System.Windows.Forms.Label();
            this.grpDAT = new System.Windows.Forms.GroupBox();
            this.pnlDAT = new System.Windows.Forms.Panel();
            this.cmbPostDATInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPostDAT = new System.Windows.Forms.Label();
            this.cmbPreDATInterp = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.lblPreDAT = new System.Windows.Forms.Label();
            this.lblDAT = new System.Windows.Forms.Label();
            this.lblDATInterp = new System.Windows.Forms.Label();
            this.dtpDateNoted = new System.Windows.Forms.DateTimePicker();
            this.lblDateNoted = new System.Windows.Forms.Label();
            this.grpTRWDates = new System.Windows.Forms.GroupBox();
            this.dtpDateInvestigated = new System.Windows.Forms.DateTimePicker();
            this.lblDateInvestigated = new System.Windows.Forms.Label();
            this.btnInvalidateTRW = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.btnFinalizePrint = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.tabTRW.SuspendLayout();
            this.pageSpecimenChecks.SuspendLayout();
            this.pnlSpecimenChecks.SuspendLayout();
            this.grpPostTransfusionSpecimen.SuspendLayout();
            this.grpPreTransfusionSpecimen.SuspendLayout();
            this.grpPostTransfusionAvailable.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picPostScanner)).BeginInit();
            this.grpPostClericalCheck.SuspendLayout();
            this.pnlPostSpecimenComments.SuspendLayout();
            this.grpPostTransfusionNotAvailable.SuspendLayout();
            this.grpPreTransfusionAvailable.SuspendLayout();
            this.pnlPreSpecimenComments.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picPreScanner)).BeginInit();
            this.grpPreClericalCheck.SuspendLayout();
            this.grpPreTransfusionNotAvailable.SuspendLayout();
            this.pageSymptoms.SuspendLayout();
            this.pnlSymptoms.SuspendLayout();
            this.grpSymptoms.SuspendLayout();
            this.grpSymptomsIdentified.SuspendLayout();
            this.pageImplicatedUnits.SuspendLayout();
            this.pnlImplicatedUnits.SuspendLayout();
            this.grpImplicatedUnitsIdentified.SuspendLayout();
            this.grpIdentifyUnits.SuspendLayout();
            this.grpBloodBagReturned.SuspendLayout();
            this.grpImplicatedUnit.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picUnitIDScanner)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.picProductScanner)).BeginInit();
            this.grpBloodBagChecks.SuspendLayout();
            this.grpBloodBagClericalChecks.SuspendLayout();
            this.grpBagComment.SuspendLayout();
            this.grpBagNotReturned.SuspendLayout();
            this.grpImplicatedUnits.SuspendLayout();
            this.pageSerolgicTests.SuspendLayout();
            this.pnlSerologicTests.SuspendLayout();
            this.grpXM.SuspendLayout();
            this.pnlXM.SuspendLayout();
            this.pnlXMRight.SuspendLayout();
            this.pnlPostXM.SuspendLayout();
            this.pnlXMMiddle.SuspendLayout();
            this.pnlPreXM.SuspendLayout();
            this.pnlXMLabels.SuspendLayout();
            this.grpABORh.SuspendLayout();
            this.pnlABORh.SuspendLayout();
            this.pnlABO.SuspendLayout();
            this.pnlRh.SuspendLayout();
            this.grpAutomatedInstrument.SuspendLayout();
            this.grpABS.SuspendLayout();
            this.pnlABS.SuspendLayout();
            this.grpDAT.SuspendLayout();
            this.pnlDAT.SuspendLayout();
            this.grpTRWDates.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(716, 30);
            this.vbecsLogo1.TabIndex = 6;
            this.vbecsLogo1.Title = "Transfusion Reaction Workup";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 516);
            this.lblRequiredField.TabIndex = 8;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 72);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 424);
            this.grpImage.TabIndex = 7;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 32);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(636, 498);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 4;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnSpecimenOK
            // 
            this.btnSpecimenOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSpecimenOK.EnabledButton = false;
            this.btnSpecimenOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSpecimenOK.Image = ((System.Drawing.Image)(resources.GetObject("btnSpecimenOK.Image")));
            this.btnSpecimenOK.Location = new System.Drawing.Point(576, 328);
            this.btnSpecimenOK.Name = "btnSpecimenOK";
            this.btnSpecimenOK.Size = new System.Drawing.Size(75, 23);
            this.btnSpecimenOK.TabIndex = 4;
            this.btnSpecimenOK.Click += new System.EventHandler(this.SaveSpecimenChecks);
            this.btnSpecimenOK.MouseHover += new System.EventHandler(this.btnSpecimenOK_MouseHover);
            // 
            // tabTRW
            // 
            this.tabTRW.AccessibleDescription = "Transfusion Reaction Workup";
            this.tabTRW.AccessibleName = "Transfusion Reaction Workup";
            this.tabTRW.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabTRW.Controls.Add(this.pageSpecimenChecks);
            this.tabTRW.Controls.Add(this.pageSymptoms);
            this.tabTRW.Controls.Add(this.pageImplicatedUnits);
            this.tabTRW.Controls.Add(this.pageSerolgicTests);
            this.tabTRW.Location = new System.Drawing.Point(48, 116);
            this.tabTRW.Name = "tabTRW";
            this.tabTRW.SelectedIndex = 0;
            this.tabTRW.Size = new System.Drawing.Size(664, 380);
            this.tabTRW.SizeMode = System.Windows.Forms.TabSizeMode.FillToRight;
            this.tabTRW.TabIndex = 1;
            this.tabTRW.SelectedIndexChanged += new System.EventHandler(this.tabTRW_SelectedIndexChanged);
            // 
            // pageSpecimenChecks
            // 
            this.pageSpecimenChecks.Controls.Add(this.pnlSpecimenChecks);
            this.pageSpecimenChecks.Location = new System.Drawing.Point(4, 23);
            this.pageSpecimenChecks.Name = "pageSpecimenChecks";
            this.pageSpecimenChecks.Size = new System.Drawing.Size(656, 353);
            this.pageSpecimenChecks.TabIndex = 0;
            this.pageSpecimenChecks.Text = "Specimen Checks";
            // 
            // pnlSpecimenChecks
            // 
            this.pnlSpecimenChecks.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlSpecimenChecks.Controls.Add(this.lblCompleteMessage1);
            this.pnlSpecimenChecks.Controls.Add(this.grpPostTransfusionSpecimen);
            this.pnlSpecimenChecks.Controls.Add(this.btnSpecimenOK);
            this.pnlSpecimenChecks.Controls.Add(this.grpPreTransfusionSpecimen);
            this.pnlSpecimenChecks.Controls.Add(this.grpPostTransfusionAvailable);
            this.pnlSpecimenChecks.Controls.Add(this.grpPostTransfusionNotAvailable);
            this.pnlSpecimenChecks.Controls.Add(this.grpPreTransfusionAvailable);
            this.pnlSpecimenChecks.Controls.Add(this.grpPreTransfusionNotAvailable);
            this.pnlSpecimenChecks.Location = new System.Drawing.Point(0, 0);
            this.pnlSpecimenChecks.Name = "pnlSpecimenChecks";
            this.pnlSpecimenChecks.Size = new System.Drawing.Size(656, 352);
            this.pnlSpecimenChecks.TabIndex = 0;
            // 
            // lblCompleteMessage1
            // 
            this.lblCompleteMessage1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblCompleteMessage1.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.lblCompleteMessage1.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCompleteMessage1.Location = new System.Drawing.Point(4, 328);
            this.lblCompleteMessage1.Name = "lblCompleteMessage1";
            this.lblCompleteMessage1.Size = new System.Drawing.Size(516, 20);
            this.lblCompleteMessage1.TabIndex = 71;
            this.lblCompleteMessage1.Text = "Final report to follow in hard copy with medical director evaluation of the trans" +
    "fusion reaction workup";
            this.lblCompleteMessage1.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.lblCompleteMessage1.Visible = false;
            // 
            // grpPostTransfusionSpecimen
            // 
            this.grpPostTransfusionSpecimen.AccessibleDescription = "Post Transfusion Specimen Available";
            this.grpPostTransfusionSpecimen.AccessibleName = "Post Transfusion Specimen Available";
            this.grpPostTransfusionSpecimen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPostTransfusionSpecimen.Controls.Add(this.rdoPostTransfusionAvailable);
            this.grpPostTransfusionSpecimen.Controls.Add(this.rdoPostTransfusionNotAvailable);
            this.grpPostTransfusionSpecimen.Location = new System.Drawing.Point(328, 4);
            this.grpPostTransfusionSpecimen.Name = "grpPostTransfusionSpecimen";
            this.grpPostTransfusionSpecimen.Size = new System.Drawing.Size(324, 56);
            this.grpPostTransfusionSpecimen.TabIndex = 3;
            this.grpPostTransfusionSpecimen.TabStop = false;
            this.grpPostTransfusionSpecimen.Text = "Post-Transfusion Specimen Availability*";
            // 
            // rdoPostTransfusionAvailable
            // 
            this.rdoPostTransfusionAvailable.AccessibleDescription = "Post Transfusion Specimen Available";
            this.rdoPostTransfusionAvailable.AccessibleName = "Post Transfusion Specimen Available";
            this.rdoPostTransfusionAvailable.Location = new System.Drawing.Point(12, 16);
            this.rdoPostTransfusionAvailable.Name = "rdoPostTransfusionAvailable";
            this.rdoPostTransfusionAvailable.Size = new System.Drawing.Size(232, 16);
            this.rdoPostTransfusionAvailable.TabIndex = 0;
            this.rdoPostTransfusionAvailable.TabStop = true;
            this.rdoPostTransfusionAvailable.Text = "Po&st-Transfusion Specimen Available";
            this.rdoPostTransfusionAvailable.CheckedChanged += new System.EventHandler(this.PostTransfusionAvailableChecked);
            // 
            // rdoPostTransfusionNotAvailable
            // 
            this.rdoPostTransfusionNotAvailable.AccessibleDescription = "Post Transfusion Specimen Not Available";
            this.rdoPostTransfusionNotAvailable.AccessibleName = "Post Transfusion Specimen Not Available";
            this.rdoPostTransfusionNotAvailable.Location = new System.Drawing.Point(12, 36);
            this.rdoPostTransfusionNotAvailable.Name = "rdoPostTransfusionNotAvailable";
            this.rdoPostTransfusionNotAvailable.Size = new System.Drawing.Size(232, 16);
            this.rdoPostTransfusionNotAvailable.TabIndex = 1;
            this.rdoPostTransfusionNotAvailable.Text = "Pos&t-Transfusion Specimen Not Available";
            this.rdoPostTransfusionNotAvailable.CheckedChanged += new System.EventHandler(this.PostTransfusionAvailableChecked);
            // 
            // grpPreTransfusionSpecimen
            // 
            this.grpPreTransfusionSpecimen.AccessibleDescription = "Pre Transfusion Specimen Available";
            this.grpPreTransfusionSpecimen.AccessibleName = "Pre Transfusion Specimen Available";
            this.grpPreTransfusionSpecimen.Controls.Add(this.rdoPreTransfusionAvailable);
            this.grpPreTransfusionSpecimen.Controls.Add(this.rdoPreTransfusionNotAvailable);
            this.grpPreTransfusionSpecimen.Location = new System.Drawing.Point(4, 4);
            this.grpPreTransfusionSpecimen.Name = "grpPreTransfusionSpecimen";
            this.grpPreTransfusionSpecimen.Size = new System.Drawing.Size(316, 56);
            this.grpPreTransfusionSpecimen.TabIndex = 0;
            this.grpPreTransfusionSpecimen.TabStop = false;
            this.grpPreTransfusionSpecimen.Text = "Pre-Transfusion Specimen Availability*";
            // 
            // rdoPreTransfusionAvailable
            // 
            this.rdoPreTransfusionAvailable.AccessibleDescription = "Pre Transfusion Specimen Available ";
            this.rdoPreTransfusionAvailable.AccessibleName = "Pre Transfusion Specimen Available ";
            this.rdoPreTransfusionAvailable.Location = new System.Drawing.Point(8, 16);
            this.rdoPreTransfusionAvailable.Name = "rdoPreTransfusionAvailable";
            this.rdoPreTransfusionAvailable.Size = new System.Drawing.Size(232, 16);
            this.rdoPreTransfusionAvailable.TabIndex = 0;
            this.rdoPreTransfusionAvailable.TabStop = true;
            this.rdoPreTransfusionAvailable.Text = "&Pre-Transfusion Specimen Available";
            this.rdoPreTransfusionAvailable.CheckedChanged += new System.EventHandler(this.PreTransfusionAvailableChecked);
            // 
            // rdoPreTransfusionNotAvailable
            // 
            this.rdoPreTransfusionNotAvailable.AccessibleDescription = "Pre Transfusion Specimen Not Available";
            this.rdoPreTransfusionNotAvailable.AccessibleName = "Pre Transfusion Specimen Not Available";
            this.rdoPreTransfusionNotAvailable.Location = new System.Drawing.Point(8, 36);
            this.rdoPreTransfusionNotAvailable.Name = "rdoPreTransfusionNotAvailable";
            this.rdoPreTransfusionNotAvailable.Size = new System.Drawing.Size(228, 16);
            this.rdoPreTransfusionNotAvailable.TabIndex = 1;
            this.rdoPreTransfusionNotAvailable.Text = "P&re-Transfusion Specimen Not Available";
            this.rdoPreTransfusionNotAvailable.CheckedChanged += new System.EventHandler(this.PreTransfusionAvailableChecked);
            // 
            // grpPostTransfusionAvailable
            // 
            this.grpPostTransfusionAvailable.AccessibleDescription = "Post Transfusion Available";
            this.grpPostTransfusionAvailable.AccessibleName = "Post Transfusion Available";
            this.grpPostTransfusionAvailable.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPostTransfusionAvailable.Controls.Add(this.picPostScanner);
            this.grpPostTransfusionAvailable.Controls.Add(this.lblPostSpecimenUID);
            this.grpPostTransfusionAvailable.Controls.Add(this.txtPostSpecimenUID);
            this.grpPostTransfusionAvailable.Controls.Add(this.cmbPostHemolysis);
            this.grpPostTransfusionAvailable.Controls.Add(this.lblPostHemolysis);
            this.grpPostTransfusionAvailable.Controls.Add(this.grpPostClericalCheck);
            this.grpPostTransfusionAvailable.Controls.Add(this.pnlPostSpecimenComments);
            this.grpPostTransfusionAvailable.Location = new System.Drawing.Point(328, 64);
            this.grpPostTransfusionAvailable.Name = "grpPostTransfusionAvailable";
            this.grpPostTransfusionAvailable.Size = new System.Drawing.Size(324, 260);
            this.grpPostTransfusionAvailable.TabIndex = 5;
            this.grpPostTransfusionAvailable.TabStop = false;
            this.grpPostTransfusionAvailable.Text = "Post-Transfusion Specimen Checks";
            this.grpPostTransfusionAvailable.Visible = false;
            // 
            // picPostScanner
            // 
            this.picPostScanner.Image = ((System.Drawing.Image)(resources.GetObject("picPostScanner.Image")));
            this.picPostScanner.Location = new System.Drawing.Point(4, 22);
            this.picPostScanner.Name = "picPostScanner";
            this.picPostScanner.Size = new System.Drawing.Size(20, 20);
            this.picPostScanner.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picPostScanner.TabIndex = 25;
            this.picPostScanner.TabStop = false;
            // 
            // lblPostSpecimenUID
            // 
            this.lblPostSpecimenUID.Location = new System.Drawing.Point(24, 20);
            this.lblPostSpecimenUID.Name = "lblPostSpecimenUID";
            this.lblPostSpecimenUID.Size = new System.Drawing.Size(88, 20);
            this.lblPostSpecimenUID.TabIndex = 0;
            this.lblPostSpecimenUID.Text = "Specimen UID*";
            this.lblPostSpecimenUID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtPostSpecimenUID
            // 
            this.txtPostSpecimenUID.AccessibleDescription = "Specimen U I D";
            this.txtPostSpecimenUID.AccessibleName = "Specimen U I D";
            this.txtPostSpecimenUID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPostSpecimenUID.Location = new System.Drawing.Point(132, 20);
            this.txtPostSpecimenUID.Name = "txtPostSpecimenUID";
            this.txtPostSpecimenUID.Size = new System.Drawing.Size(168, 20);
            this.txtPostSpecimenUID.TabIndex = 1;
            this.txtPostSpecimenUID.Leave += new System.EventHandler(this.PostSpecimenUidChanged);
            // 
            // cmbPostHemolysis
            // 
            this.cmbPostHemolysis.AccessibleDescription = "Hemolysis Inspection";
            this.cmbPostHemolysis.AccessibleName = "Hemolysis Inspection";
            this.cmbPostHemolysis.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPostHemolysis.Interval = 500;
            this.cmbPostHemolysis.Location = new System.Drawing.Point(132, 44);
            this.cmbPostHemolysis.MaxLength = 7;
            this.cmbPostHemolysis.Name = "cmbPostHemolysis";
            this.cmbPostHemolysis.Size = new System.Drawing.Size(168, 22);
            this.cmbPostHemolysis.TabIndex = 3;
            this.cmbPostHemolysis.SelectedIndexChanged += new System.EventHandler(this.PostSpecimenHemolysisChanged);
            // 
            // lblPostHemolysis
            // 
            this.lblPostHemolysis.Location = new System.Drawing.Point(24, 44);
            this.lblPostHemolysis.Name = "lblPostHemolysis";
            this.lblPostHemolysis.Size = new System.Drawing.Size(116, 20);
            this.lblPostHemolysis.TabIndex = 2;
            this.lblPostHemolysis.Text = "Hemolysis Inspection*";
            this.lblPostHemolysis.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpPostClericalCheck
            // 
            this.grpPostClericalCheck.AccessibleDescription = "Clerical Check";
            this.grpPostClericalCheck.AccessibleName = "Clerical Check";
            this.grpPostClericalCheck.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPostClericalCheck.Controls.Add(this.rdoPostClericalCheckFail);
            this.grpPostClericalCheck.Controls.Add(this.rdoPostClericalCheckOK);
            this.grpPostClericalCheck.Location = new System.Drawing.Point(8, 68);
            this.grpPostClericalCheck.Name = "grpPostClericalCheck";
            this.grpPostClericalCheck.Size = new System.Drawing.Size(308, 60);
            this.grpPostClericalCheck.TabIndex = 4;
            this.grpPostClericalCheck.TabStop = false;
            this.grpPostClericalCheck.Text = "Clerical Check*";
            // 
            // rdoPostClericalCheckFail
            // 
            this.rdoPostClericalCheckFail.AccessibleDescription = "Clerical Check Failed";
            this.rdoPostClericalCheckFail.AccessibleName = "Clerical Check Failed";
            this.rdoPostClericalCheckFail.Location = new System.Drawing.Point(8, 36);
            this.rdoPostClericalCheckFail.Name = "rdoPostClericalCheckFail";
            this.rdoPostClericalCheckFail.Size = new System.Drawing.Size(148, 20);
            this.rdoPostClericalCheckFail.TabIndex = 1;
            this.rdoPostClericalCheckFail.Text = "Clerical Check &Failed";
            this.rdoPostClericalCheckFail.CheckedChanged += new System.EventHandler(this.PostSpecimenClericalChecked);
            // 
            // rdoPostClericalCheckOK
            // 
            this.rdoPostClericalCheckOK.AccessibleDescription = "Clerical Check O K ";
            this.rdoPostClericalCheckOK.AccessibleName = "Clerical Check O K ";
            this.rdoPostClericalCheckOK.Location = new System.Drawing.Point(8, 16);
            this.rdoPostClericalCheckOK.Name = "rdoPostClericalCheckOK";
            this.rdoPostClericalCheckOK.Size = new System.Drawing.Size(148, 20);
            this.rdoPostClericalCheckOK.TabIndex = 0;
            this.rdoPostClericalCheckOK.TabStop = true;
            this.rdoPostClericalCheckOK.Text = "Cle&rical Check OK";
            this.rdoPostClericalCheckOK.CheckedChanged += new System.EventHandler(this.PostSpecimenClericalChecked);
            // 
            // pnlPostSpecimenComments
            // 
            this.pnlPostSpecimenComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPostSpecimenComments.Controls.Add(this.lblPostSpecimenDetails);
            this.pnlPostSpecimenComments.Controls.Add(this.cmbPostSpecimenComments);
            this.pnlPostSpecimenComments.Controls.Add(this.lblPostSpecimenComments);
            this.pnlPostSpecimenComments.Controls.Add(this.txtPostSpecimenComments);
            this.pnlPostSpecimenComments.Location = new System.Drawing.Point(8, 132);
            this.pnlPostSpecimenComments.Name = "pnlPostSpecimenComments";
            this.pnlPostSpecimenComments.Size = new System.Drawing.Size(308, 120);
            this.pnlPostSpecimenComments.TabIndex = 36;
            // 
            // lblPostSpecimenDetails
            // 
            this.lblPostSpecimenDetails.Location = new System.Drawing.Point(0, 24);
            this.lblPostSpecimenDetails.Name = "lblPostSpecimenDetails";
            this.lblPostSpecimenDetails.Size = new System.Drawing.Size(56, 20);
            this.lblPostSpecimenDetails.TabIndex = 2;
            this.lblPostSpecimenDetails.Text = "Details";
            this.lblPostSpecimenDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cmbPostSpecimenComments
            // 
            this.cmbPostSpecimenComments.AccessibleDescription = "Comments";
            this.cmbPostSpecimenComments.AccessibleName = "Comments";
            this.cmbPostSpecimenComments.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPostSpecimenComments.Interval = 500;
            this.cmbPostSpecimenComments.Location = new System.Drawing.Point(60, 0);
            this.cmbPostSpecimenComments.MaxLength = 80;
            this.cmbPostSpecimenComments.Name = "cmbPostSpecimenComments";
            this.cmbPostSpecimenComments.Size = new System.Drawing.Size(248, 22);
            this.cmbPostSpecimenComments.TabIndex = 1;
            this.cmbPostSpecimenComments.SelectedIndexChanged += new System.EventHandler(this.PostSpecimenCommentChanged);
            // 
            // lblPostSpecimenComments
            // 
            this.lblPostSpecimenComments.Location = new System.Drawing.Point(0, 0);
            this.lblPostSpecimenComments.Name = "lblPostSpecimenComments";
            this.lblPostSpecimenComments.Size = new System.Drawing.Size(60, 20);
            this.lblPostSpecimenComments.TabIndex = 0;
            this.lblPostSpecimenComments.Text = "Comment";
            this.lblPostSpecimenComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtPostSpecimenComments
            // 
            this.txtPostSpecimenComments.AccessibleDescription = "Details";
            this.txtPostSpecimenComments.AccessibleName = "Details";
            this.txtPostSpecimenComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPostSpecimenComments.Location = new System.Drawing.Point(60, 24);
            this.txtPostSpecimenComments.MaxLength = 255;
            this.txtPostSpecimenComments.Multiline = true;
            this.txtPostSpecimenComments.Name = "txtPostSpecimenComments";
            this.txtPostSpecimenComments.Size = new System.Drawing.Size(248, 96);
            this.txtPostSpecimenComments.TabIndex = 3;
            this.txtPostSpecimenComments.TextChanged += new System.EventHandler(this.PostSpecimenCommentChanged);
            // 
            // grpPostTransfusionNotAvailable
            // 
            this.grpPostTransfusionNotAvailable.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPostTransfusionNotAvailable.Controls.Add(this.cmbPostComment);
            this.grpPostTransfusionNotAvailable.Controls.Add(this.txtPostDetails);
            this.grpPostTransfusionNotAvailable.Controls.Add(this.lblPostComment);
            this.grpPostTransfusionNotAvailable.Controls.Add(this.lblPostDetails);
            this.grpPostTransfusionNotAvailable.Location = new System.Drawing.Point(328, 64);
            this.grpPostTransfusionNotAvailable.Name = "grpPostTransfusionNotAvailable";
            this.grpPostTransfusionNotAvailable.Size = new System.Drawing.Size(324, 260);
            this.grpPostTransfusionNotAvailable.TabIndex = 4;
            this.grpPostTransfusionNotAvailable.TabStop = false;
            this.grpPostTransfusionNotAvailable.Text = "Post-Transfusion Not Available Comment";
            this.grpPostTransfusionNotAvailable.Visible = false;
            // 
            // cmbPostComment
            // 
            this.cmbPostComment.AccessibleDescription = "Comment";
            this.cmbPostComment.AccessibleName = "Comment";
            this.cmbPostComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPostComment.Interval = 500;
            this.cmbPostComment.Location = new System.Drawing.Point(60, 20);
            this.cmbPostComment.MaxLength = 80;
            this.cmbPostComment.Name = "cmbPostComment";
            this.cmbPostComment.Size = new System.Drawing.Size(256, 22);
            this.cmbPostComment.TabIndex = 1;
            this.cmbPostComment.SelectedIndexChanged += new System.EventHandler(this.PostCommentChanged);
            // 
            // txtPostDetails
            // 
            this.txtPostDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPostDetails.Location = new System.Drawing.Point(60, 44);
            this.txtPostDetails.MaxLength = 255;
            this.txtPostDetails.Multiline = true;
            this.txtPostDetails.Name = "txtPostDetails";
            this.txtPostDetails.Size = new System.Drawing.Size(256, 208);
            this.txtPostDetails.TabIndex = 3;
            this.txtPostDetails.TextChanged += new System.EventHandler(this.PostCommentChanged);
            // 
            // lblPostComment
            // 
            this.lblPostComment.Location = new System.Drawing.Point(8, 20);
            this.lblPostComment.Name = "lblPostComment";
            this.lblPostComment.Size = new System.Drawing.Size(60, 20);
            this.lblPostComment.TabIndex = 0;
            this.lblPostComment.Text = "Comment*";
            this.lblPostComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblPostDetails
            // 
            this.lblPostDetails.Location = new System.Drawing.Point(8, 44);
            this.lblPostDetails.Name = "lblPostDetails";
            this.lblPostDetails.Size = new System.Drawing.Size(56, 20);
            this.lblPostDetails.TabIndex = 2;
            this.lblPostDetails.Text = "Details";
            this.lblPostDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpPreTransfusionAvailable
            // 
            this.grpPreTransfusionAvailable.AccessibleDescription = "Pre Transfusion Specimen Checks";
            this.grpPreTransfusionAvailable.AccessibleName = "Pre Transfusion Specimen Checks";
            this.grpPreTransfusionAvailable.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpPreTransfusionAvailable.Controls.Add(this.pnlPreSpecimenComments);
            this.grpPreTransfusionAvailable.Controls.Add(this.picPreScanner);
            this.grpPreTransfusionAvailable.Controls.Add(this.lblPreSpecimenUID);
            this.grpPreTransfusionAvailable.Controls.Add(this.txtPreSpecimenUID);
            this.grpPreTransfusionAvailable.Controls.Add(this.cmbPreHemolysis);
            this.grpPreTransfusionAvailable.Controls.Add(this.lblPreHemolysis);
            this.grpPreTransfusionAvailable.Controls.Add(this.grpPreClericalCheck);
            this.grpPreTransfusionAvailable.Location = new System.Drawing.Point(4, 64);
            this.grpPreTransfusionAvailable.Name = "grpPreTransfusionAvailable";
            this.grpPreTransfusionAvailable.Size = new System.Drawing.Size(316, 260);
            this.grpPreTransfusionAvailable.TabIndex = 2;
            this.grpPreTransfusionAvailable.TabStop = false;
            this.grpPreTransfusionAvailable.Text = "Pre-Transfusion Specimen Checks";
            this.grpPreTransfusionAvailable.Visible = false;
            // 
            // pnlPreSpecimenComments
            // 
            this.pnlPreSpecimenComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPreSpecimenComments.Controls.Add(this.cmbPreSpecimenComments);
            this.pnlPreSpecimenComments.Controls.Add(this.lblPreSpecimenComments);
            this.pnlPreSpecimenComments.Controls.Add(this.txtPreSpecimenComments);
            this.pnlPreSpecimenComments.Controls.Add(this.lblPreSpecimenDetails);
            this.pnlPreSpecimenComments.Location = new System.Drawing.Point(8, 132);
            this.pnlPreSpecimenComments.Name = "pnlPreSpecimenComments";
            this.pnlPreSpecimenComments.Size = new System.Drawing.Size(300, 120);
            this.pnlPreSpecimenComments.TabIndex = 35;
            // 
            // cmbPreSpecimenComments
            // 
            this.cmbPreSpecimenComments.AccessibleDescription = "Comments";
            this.cmbPreSpecimenComments.AccessibleName = "Comments";
            this.cmbPreSpecimenComments.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPreSpecimenComments.Interval = 500;
            this.cmbPreSpecimenComments.Location = new System.Drawing.Point(60, 0);
            this.cmbPreSpecimenComments.MaxLength = 80;
            this.cmbPreSpecimenComments.Name = "cmbPreSpecimenComments";
            this.cmbPreSpecimenComments.Size = new System.Drawing.Size(240, 22);
            this.cmbPreSpecimenComments.TabIndex = 1;
            this.cmbPreSpecimenComments.SelectedIndexChanged += new System.EventHandler(this.PreSpecimenCommentChanged);
            // 
            // lblPreSpecimenComments
            // 
            this.lblPreSpecimenComments.Location = new System.Drawing.Point(0, 0);
            this.lblPreSpecimenComments.Name = "lblPreSpecimenComments";
            this.lblPreSpecimenComments.Size = new System.Drawing.Size(60, 20);
            this.lblPreSpecimenComments.TabIndex = 0;
            this.lblPreSpecimenComments.Text = "Comment";
            this.lblPreSpecimenComments.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtPreSpecimenComments
            // 
            this.txtPreSpecimenComments.AccessibleDescription = "Details";
            this.txtPreSpecimenComments.AccessibleName = "Details";
            this.txtPreSpecimenComments.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPreSpecimenComments.Location = new System.Drawing.Point(60, 24);
            this.txtPreSpecimenComments.MaxLength = 255;
            this.txtPreSpecimenComments.Multiline = true;
            this.txtPreSpecimenComments.Name = "txtPreSpecimenComments";
            this.txtPreSpecimenComments.Size = new System.Drawing.Size(240, 96);
            this.txtPreSpecimenComments.TabIndex = 3;
            this.txtPreSpecimenComments.TextChanged += new System.EventHandler(this.PreSpecimenCommentChanged);
            // 
            // lblPreSpecimenDetails
            // 
            this.lblPreSpecimenDetails.Location = new System.Drawing.Point(0, 24);
            this.lblPreSpecimenDetails.Name = "lblPreSpecimenDetails";
            this.lblPreSpecimenDetails.Size = new System.Drawing.Size(56, 20);
            this.lblPreSpecimenDetails.TabIndex = 2;
            this.lblPreSpecimenDetails.Text = "Details";
            this.lblPreSpecimenDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // picPreScanner
            // 
            this.picPreScanner.Image = ((System.Drawing.Image)(resources.GetObject("picPreScanner.Image")));
            this.picPreScanner.Location = new System.Drawing.Point(4, 22);
            this.picPreScanner.Name = "picPreScanner";
            this.picPreScanner.Size = new System.Drawing.Size(20, 20);
            this.picPreScanner.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picPreScanner.TabIndex = 25;
            this.picPreScanner.TabStop = false;
            // 
            // lblPreSpecimenUID
            // 
            this.lblPreSpecimenUID.Location = new System.Drawing.Point(24, 20);
            this.lblPreSpecimenUID.Name = "lblPreSpecimenUID";
            this.lblPreSpecimenUID.Size = new System.Drawing.Size(88, 20);
            this.lblPreSpecimenUID.TabIndex = 0;
            this.lblPreSpecimenUID.Text = "Specimen UID*";
            this.lblPreSpecimenUID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtPreSpecimenUID
            // 
            this.txtPreSpecimenUID.AccessibleDescription = "Specimen U I D";
            this.txtPreSpecimenUID.AccessibleName = "Specimen U I D";
            this.txtPreSpecimenUID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPreSpecimenUID.Location = new System.Drawing.Point(132, 20);
            this.txtPreSpecimenUID.Name = "txtPreSpecimenUID";
            this.txtPreSpecimenUID.Size = new System.Drawing.Size(160, 20);
            this.txtPreSpecimenUID.TabIndex = 1;
            this.txtPreSpecimenUID.Leave += new System.EventHandler(this.PreSpecimenUidChanged);
            // 
            // cmbPreHemolysis
            // 
            this.cmbPreHemolysis.AccessibleDescription = "Pre Hemolysis";
            this.cmbPreHemolysis.AccessibleName = "Pre Hemolysis";
            this.cmbPreHemolysis.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPreHemolysis.Interval = 500;
            this.cmbPreHemolysis.Location = new System.Drawing.Point(132, 44);
            this.cmbPreHemolysis.MaxLength = 7;
            this.cmbPreHemolysis.Name = "cmbPreHemolysis";
            this.cmbPreHemolysis.Size = new System.Drawing.Size(160, 22);
            this.cmbPreHemolysis.TabIndex = 3;
            this.cmbPreHemolysis.SelectedIndexChanged += new System.EventHandler(this.PreSpecimenHemolysisChanged);
            // 
            // lblPreHemolysis
            // 
            this.lblPreHemolysis.Location = new System.Drawing.Point(24, 44);
            this.lblPreHemolysis.Name = "lblPreHemolysis";
            this.lblPreHemolysis.Size = new System.Drawing.Size(116, 20);
            this.lblPreHemolysis.TabIndex = 2;
            this.lblPreHemolysis.Text = "Hemolysis Inspection*";
            this.lblPreHemolysis.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpPreClericalCheck
            // 
            this.grpPreClericalCheck.AccessibleDescription = "Clerical Check";
            this.grpPreClericalCheck.AccessibleName = "Clerical Check";
            this.grpPreClericalCheck.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpPreClericalCheck.Controls.Add(this.rdoPreClericalCheckFail);
            this.grpPreClericalCheck.Controls.Add(this.rdoPreClericalCheckOK);
            this.grpPreClericalCheck.Location = new System.Drawing.Point(8, 68);
            this.grpPreClericalCheck.Name = "grpPreClericalCheck";
            this.grpPreClericalCheck.Size = new System.Drawing.Size(300, 60);
            this.grpPreClericalCheck.TabIndex = 4;
            this.grpPreClericalCheck.TabStop = false;
            this.grpPreClericalCheck.Text = "Clerical Check*";
            // 
            // rdoPreClericalCheckFail
            // 
            this.rdoPreClericalCheckFail.AccessibleDescription = "Clerical Check Failed";
            this.rdoPreClericalCheckFail.AccessibleName = "Clerical Check Failed";
            this.rdoPreClericalCheckFail.Location = new System.Drawing.Point(8, 36);
            this.rdoPreClericalCheckFail.Name = "rdoPreClericalCheckFail";
            this.rdoPreClericalCheckFail.Size = new System.Drawing.Size(148, 20);
            this.rdoPreClericalCheckFail.TabIndex = 1;
            this.rdoPreClericalCheckFail.Text = "Cl&erical Check Failed";
            this.rdoPreClericalCheckFail.CheckedChanged += new System.EventHandler(this.PreSpecimenClericalChecked);
            // 
            // rdoPreClericalCheckOK
            // 
            this.rdoPreClericalCheckOK.AccessibleDescription = "Pre Clerical Check O K";
            this.rdoPreClericalCheckOK.AccessibleName = "Pre Clerical Check O K";
            this.rdoPreClericalCheckOK.Location = new System.Drawing.Point(8, 16);
            this.rdoPreClericalCheckOK.Name = "rdoPreClericalCheckOK";
            this.rdoPreClericalCheckOK.Size = new System.Drawing.Size(148, 20);
            this.rdoPreClericalCheckOK.TabIndex = 0;
            this.rdoPreClericalCheckOK.TabStop = true;
            this.rdoPreClericalCheckOK.Text = "C&lerical Check OK";
            this.rdoPreClericalCheckOK.CheckedChanged += new System.EventHandler(this.PreSpecimenClericalChecked);
            // 
            // grpPreTransfusionNotAvailable
            // 
            this.grpPreTransfusionNotAvailable.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpPreTransfusionNotAvailable.Controls.Add(this.cmbPreComment);
            this.grpPreTransfusionNotAvailable.Controls.Add(this.txtPreDetails);
            this.grpPreTransfusionNotAvailable.Controls.Add(this.lblPreComment);
            this.grpPreTransfusionNotAvailable.Controls.Add(this.lblPreDetails);
            this.grpPreTransfusionNotAvailable.Location = new System.Drawing.Point(4, 64);
            this.grpPreTransfusionNotAvailable.Name = "grpPreTransfusionNotAvailable";
            this.grpPreTransfusionNotAvailable.Size = new System.Drawing.Size(316, 260);
            this.grpPreTransfusionNotAvailable.TabIndex = 1;
            this.grpPreTransfusionNotAvailable.TabStop = false;
            this.grpPreTransfusionNotAvailable.Text = "Pre-Transfusion Not Available Comment";
            this.grpPreTransfusionNotAvailable.Visible = false;
            // 
            // cmbPreComment
            // 
            this.cmbPreComment.AccessibleDescription = "Comment";
            this.cmbPreComment.AccessibleName = "Comment";
            this.cmbPreComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPreComment.Interval = 500;
            this.cmbPreComment.Location = new System.Drawing.Point(60, 20);
            this.cmbPreComment.MaxLength = 80;
            this.cmbPreComment.Name = "cmbPreComment";
            this.cmbPreComment.Size = new System.Drawing.Size(248, 22);
            this.cmbPreComment.TabIndex = 1;
            this.cmbPreComment.SelectedIndexChanged += new System.EventHandler(this.PreCommentChanged);
            // 
            // txtPreDetails
            // 
            this.txtPreDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtPreDetails.Location = new System.Drawing.Point(60, 44);
            this.txtPreDetails.MaxLength = 255;
            this.txtPreDetails.Multiline = true;
            this.txtPreDetails.Name = "txtPreDetails";
            this.txtPreDetails.Size = new System.Drawing.Size(248, 208);
            this.txtPreDetails.TabIndex = 3;
            this.txtPreDetails.TextChanged += new System.EventHandler(this.PreCommentChanged);
            // 
            // lblPreComment
            // 
            this.lblPreComment.Location = new System.Drawing.Point(8, 20);
            this.lblPreComment.Name = "lblPreComment";
            this.lblPreComment.Size = new System.Drawing.Size(60, 20);
            this.lblPreComment.TabIndex = 0;
            this.lblPreComment.Text = "Comment*";
            this.lblPreComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblPreDetails
            // 
            this.lblPreDetails.Location = new System.Drawing.Point(8, 44);
            this.lblPreDetails.Name = "lblPreDetails";
            this.lblPreDetails.Size = new System.Drawing.Size(56, 20);
            this.lblPreDetails.TabIndex = 2;
            this.lblPreDetails.Text = "Details";
            this.lblPreDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pageSymptoms
            // 
            this.pageSymptoms.Controls.Add(this.pnlSymptoms);
            this.pageSymptoms.Location = new System.Drawing.Point(4, 23);
            this.pageSymptoms.Name = "pageSymptoms";
            this.pageSymptoms.Size = new System.Drawing.Size(656, 353);
            this.pageSymptoms.TabIndex = 3;
            this.pageSymptoms.Text = "Symptoms";
            // 
            // pnlSymptoms
            // 
            this.pnlSymptoms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlSymptoms.Controls.Add(this.lblCompleteMessage3);
            this.pnlSymptoms.Controls.Add(this.btnSymptomsOK);
            this.pnlSymptoms.Controls.Add(this.grpSymptoms);
            this.pnlSymptoms.Controls.Add(this.grpSymptomsIdentified);
            this.pnlSymptoms.Location = new System.Drawing.Point(0, 0);
            this.pnlSymptoms.Name = "pnlSymptoms";
            this.pnlSymptoms.Size = new System.Drawing.Size(656, 352);
            this.pnlSymptoms.TabIndex = 70;
            // 
            // lblCompleteMessage3
            // 
            this.lblCompleteMessage3.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblCompleteMessage3.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.lblCompleteMessage3.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCompleteMessage3.Location = new System.Drawing.Point(4, 328);
            this.lblCompleteMessage3.Name = "lblCompleteMessage3";
            this.lblCompleteMessage3.Size = new System.Drawing.Size(516, 20);
            this.lblCompleteMessage3.TabIndex = 70;
            this.lblCompleteMessage3.Text = "Final report to follow in hard copy with medical director evaluation of the trans" +
    "fusion reaction workup";
            this.lblCompleteMessage3.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.lblCompleteMessage3.Visible = false;
            // 
            // btnSymptomsOK
            // 
            this.btnSymptomsOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnSymptomsOK.EnabledButton = false;
            this.btnSymptomsOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnSymptomsOK.Image = ((System.Drawing.Image)(resources.GetObject("btnSymptomsOK.Image")));
            this.btnSymptomsOK.Location = new System.Drawing.Point(580, 328);
            this.btnSymptomsOK.Name = "btnSymptomsOK";
            this.btnSymptomsOK.Size = new System.Drawing.Size(75, 23);
            this.btnSymptomsOK.TabIndex = 65;
            this.btnSymptomsOK.Click += new System.EventHandler(this.SaveSymptoms);
            this.btnSymptomsOK.MouseHover += new System.EventHandler(this.btnSymptomsOK_MouseHover);
            // 
            // grpSymptoms
            // 
            this.grpSymptoms.AccessibleDescription = "Patient Symptoms";
            this.grpSymptoms.AccessibleName = "Patient Symptoms";
            this.grpSymptoms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSymptoms.Controls.Add(this.clbSymptoms);
            this.grpSymptoms.Controls.Add(this.lblSymptomDetails);
            this.grpSymptoms.Controls.Add(this.txtSymptomDetails);
            this.grpSymptoms.Location = new System.Drawing.Point(4, 64);
            this.grpSymptoms.Name = "grpSymptoms";
            this.grpSymptoms.Size = new System.Drawing.Size(652, 260);
            this.grpSymptoms.TabIndex = 68;
            this.grpSymptoms.TabStop = false;
            this.grpSymptoms.Text = "Patient Symptoms*";
            this.grpSymptoms.Visible = false;
            // 
            // clbSymptoms
            // 
            this.clbSymptoms.AccessibleDescription = "Patient Symptoms";
            this.clbSymptoms.AccessibleName = "Patient Symptoms";
            this.clbSymptoms.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.clbSymptoms.CheckOnClick = true;
            this.clbSymptoms.ColumnWidth = 300;
            this.clbSymptoms.Items.AddRange(new object[] {
            "Rash",
            "Chills",
            "Fever (>1C or 2F increase)",
            "Shaking Chills (rigors)",
            "Pain At Infusion SIte",
            "Pain In Chest",
            "Pain In Abdomen",
            "Pain In Flanks",
            "Wheezing",
            "Dyspnea",
            "Tachypnea",
            "Hypoxemia",
            "Urticaria",
            "Pruritis (itching)",
            "Flushing",
            "Localized Edema (angiodema)"});
            this.clbSymptoms.Location = new System.Drawing.Point(8, 16);
            this.clbSymptoms.MultiColumn = true;
            this.clbSymptoms.Name = "clbSymptoms";
            this.clbSymptoms.Size = new System.Drawing.Size(636, 214);
            this.clbSymptoms.TabIndex = 30;
            this.clbSymptoms.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.PatientSymptomsChanging);
            // 
            // lblSymptomDetails
            // 
            this.lblSymptomDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblSymptomDetails.Location = new System.Drawing.Point(24, 234);
            this.lblSymptomDetails.Name = "lblSymptomDetails";
            this.lblSymptomDetails.Size = new System.Drawing.Size(76, 20);
            this.lblSymptomDetails.TabIndex = 29;
            this.lblSymptomDetails.Text = "Other Details";
            this.lblSymptomDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtSymptomDetails
            // 
            this.txtSymptomDetails.AccessibleDescription = "Other Details";
            this.txtSymptomDetails.AccessibleName = "Other Details";
            this.txtSymptomDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtSymptomDetails.Location = new System.Drawing.Point(104, 234);
            this.txtSymptomDetails.MaxLength = 255;
            this.txtSymptomDetails.Name = "txtSymptomDetails";
            this.txtSymptomDetails.Size = new System.Drawing.Size(540, 20);
            this.txtSymptomDetails.TabIndex = 28;
            this.txtSymptomDetails.TextChanged += new System.EventHandler(this.SymptomDetailsChanged);
            // 
            // grpSymptomsIdentified
            // 
            this.grpSymptomsIdentified.AccessibleDescription = "Symptoms Identified";
            this.grpSymptomsIdentified.AccessibleName = "Symptoms Identified";
            this.grpSymptomsIdentified.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSymptomsIdentified.Controls.Add(this.rdoSymptomsIdentified);
            this.grpSymptomsIdentified.Controls.Add(this.rdoNoSymptomsIdentified);
            this.grpSymptomsIdentified.Location = new System.Drawing.Point(4, 4);
            this.grpSymptomsIdentified.Name = "grpSymptomsIdentified";
            this.grpSymptomsIdentified.Size = new System.Drawing.Size(652, 56);
            this.grpSymptomsIdentified.TabIndex = 69;
            this.grpSymptomsIdentified.TabStop = false;
            this.grpSymptomsIdentified.Text = "Symptoms Identified?*";
            // 
            // rdoSymptomsIdentified
            // 
            this.rdoSymptomsIdentified.AccessibleDescription = "Patient Symptoms Identified";
            this.rdoSymptomsIdentified.AccessibleName = "Patient Symptoms Identified";
            this.rdoSymptomsIdentified.Location = new System.Drawing.Point(8, 16);
            this.rdoSymptomsIdentified.Name = "rdoSymptomsIdentified";
            this.rdoSymptomsIdentified.Size = new System.Drawing.Size(232, 16);
            this.rdoSymptomsIdentified.TabIndex = 42;
            this.rdoSymptomsIdentified.TabStop = true;
            this.rdoSymptomsIdentified.Text = "&Patient Symptoms Identified";
            this.rdoSymptomsIdentified.CheckedChanged += new System.EventHandler(this.SymptomsChecked);
            // 
            // rdoNoSymptomsIdentified
            // 
            this.rdoNoSymptomsIdentified.AccessibleDescription = "No Patient Symptoms Identified";
            this.rdoNoSymptomsIdentified.AccessibleName = "No Patient Symptoms Identified";
            this.rdoNoSymptomsIdentified.Location = new System.Drawing.Point(8, 36);
            this.rdoNoSymptomsIdentified.Name = "rdoNoSymptomsIdentified";
            this.rdoNoSymptomsIdentified.Size = new System.Drawing.Size(228, 16);
            this.rdoNoSymptomsIdentified.TabIndex = 43;
            this.rdoNoSymptomsIdentified.Text = "&No Patient Symptoms Identified";
            this.rdoNoSymptomsIdentified.CheckedChanged += new System.EventHandler(this.SymptomsChecked);
            // 
            // pageImplicatedUnits
            // 
            this.pageImplicatedUnits.Controls.Add(this.pnlImplicatedUnits);
            this.pageImplicatedUnits.Location = new System.Drawing.Point(4, 23);
            this.pageImplicatedUnits.Name = "pageImplicatedUnits";
            this.pageImplicatedUnits.Size = new System.Drawing.Size(656, 353);
            this.pageImplicatedUnits.TabIndex = 4;
            this.pageImplicatedUnits.Text = "Implicated Units";
            // 
            // pnlImplicatedUnits
            // 
            this.pnlImplicatedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlImplicatedUnits.Controls.Add(this.lblCompleteMessage2);
            this.pnlImplicatedUnits.Controls.Add(this.grpImplicatedUnitsIdentified);
            this.pnlImplicatedUnits.Controls.Add(this.grpIdentifyUnits);
            this.pnlImplicatedUnits.Controls.Add(this.btnUnitsOK);
            this.pnlImplicatedUnits.Controls.Add(this.grpImplicatedUnits);
            this.pnlImplicatedUnits.Location = new System.Drawing.Point(0, 0);
            this.pnlImplicatedUnits.Name = "pnlImplicatedUnits";
            this.pnlImplicatedUnits.Size = new System.Drawing.Size(656, 352);
            this.pnlImplicatedUnits.TabIndex = 0;
            // 
            // lblCompleteMessage2
            // 
            this.lblCompleteMessage2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblCompleteMessage2.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.lblCompleteMessage2.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCompleteMessage2.Location = new System.Drawing.Point(4, 328);
            this.lblCompleteMessage2.Name = "lblCompleteMessage2";
            this.lblCompleteMessage2.Size = new System.Drawing.Size(516, 20);
            this.lblCompleteMessage2.TabIndex = 71;
            this.lblCompleteMessage2.Text = "Final report to follow in hard copy with medical director evaluation of the trans" +
    "fusion reaction workup";
            this.lblCompleteMessage2.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.lblCompleteMessage2.Visible = false;
            // 
            // grpImplicatedUnitsIdentified
            // 
            this.grpImplicatedUnitsIdentified.AccessibleDescription = "Implicated Units";
            this.grpImplicatedUnitsIdentified.AccessibleName = "Implicated Units";
            this.grpImplicatedUnitsIdentified.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpImplicatedUnitsIdentified.Controls.Add(this.rdoImplicatedUnitsIdentified);
            this.grpImplicatedUnitsIdentified.Controls.Add(this.rdoNoImplicatedUnitsIdentified);
            this.grpImplicatedUnitsIdentified.Location = new System.Drawing.Point(4, 4);
            this.grpImplicatedUnitsIdentified.Name = "grpImplicatedUnitsIdentified";
            this.grpImplicatedUnitsIdentified.Size = new System.Drawing.Size(648, 56);
            this.grpImplicatedUnitsIdentified.TabIndex = 0;
            this.grpImplicatedUnitsIdentified.TabStop = false;
            this.grpImplicatedUnitsIdentified.Text = "Implicated Units?*";
            // 
            // rdoImplicatedUnitsIdentified
            // 
            this.rdoImplicatedUnitsIdentified.AccessibleDescription = "Implicated Units Identified";
            this.rdoImplicatedUnitsIdentified.AccessibleName = "Implicated Units Identified";
            this.rdoImplicatedUnitsIdentified.Location = new System.Drawing.Point(8, 16);
            this.rdoImplicatedUnitsIdentified.Name = "rdoImplicatedUnitsIdentified";
            this.rdoImplicatedUnitsIdentified.Size = new System.Drawing.Size(208, 16);
            this.rdoImplicatedUnitsIdentified.TabIndex = 0;
            this.rdoImplicatedUnitsIdentified.TabStop = true;
            this.rdoImplicatedUnitsIdentified.Text = "&Implicated Unit(s) Identified";
            this.rdoImplicatedUnitsIdentified.CheckedChanged += new System.EventHandler(this.ImplicatedUnitsChecked);
            // 
            // rdoNoImplicatedUnitsIdentified
            // 
            this.rdoNoImplicatedUnitsIdentified.AccessibleDescription = "No Implicated Units Identified";
            this.rdoNoImplicatedUnitsIdentified.AccessibleName = "No Implicated Units Identified";
            this.rdoNoImplicatedUnitsIdentified.Location = new System.Drawing.Point(8, 36);
            this.rdoNoImplicatedUnitsIdentified.Name = "rdoNoImplicatedUnitsIdentified";
            this.rdoNoImplicatedUnitsIdentified.Size = new System.Drawing.Size(228, 16);
            this.rdoNoImplicatedUnitsIdentified.TabIndex = 1;
            this.rdoNoImplicatedUnitsIdentified.Text = "&No Implicated Units Identified";
            this.rdoNoImplicatedUnitsIdentified.CheckedChanged += new System.EventHandler(this.ImplicatedUnitsChecked);
            // 
            // grpIdentifyUnits
            // 
            this.grpIdentifyUnits.AccessibleDescription = "Implicated Unit Checks";
            this.grpIdentifyUnits.AccessibleName = "Implicated Unit Checks";
            this.grpIdentifyUnits.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpIdentifyUnits.Controls.Add(this.grpBloodBagReturned);
            this.grpIdentifyUnits.Controls.Add(this.grpImplicatedUnit);
            this.grpIdentifyUnits.Controls.Add(this.btnClearUnit);
            this.grpIdentifyUnits.Controls.Add(this.btnAddUnit);
            this.grpIdentifyUnits.Controls.Add(this.grpBloodBagChecks);
            this.grpIdentifyUnits.Controls.Add(this.grpBagNotReturned);
            this.grpIdentifyUnits.Location = new System.Drawing.Point(4, 64);
            this.grpIdentifyUnits.Name = "grpIdentifyUnits";
            this.grpIdentifyUnits.Size = new System.Drawing.Size(648, 172);
            this.grpIdentifyUnits.TabIndex = 1;
            this.grpIdentifyUnits.TabStop = false;
            this.grpIdentifyUnits.Text = "Implicated Unit Checks";
            this.grpIdentifyUnits.Visible = false;
            // 
            // grpBloodBagReturned
            // 
            this.grpBloodBagReturned.AccessibleDescription = "Blood Bag";
            this.grpBloodBagReturned.AccessibleName = "Blood Bag";
            this.grpBloodBagReturned.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpBloodBagReturned.Controls.Add(this.rdoBloodBagReturned);
            this.grpBloodBagReturned.Controls.Add(this.rdoBloodBagNotReturned);
            this.grpBloodBagReturned.Enabled = false;
            this.grpBloodBagReturned.Location = new System.Drawing.Point(8, 76);
            this.grpBloodBagReturned.Name = "grpBloodBagReturned";
            this.grpBloodBagReturned.Size = new System.Drawing.Size(212, 64);
            this.grpBloodBagReturned.TabIndex = 1;
            this.grpBloodBagReturned.TabStop = false;
            this.grpBloodBagReturned.Text = "Blood Bag?*";
            this.grpBloodBagReturned.Enter += new System.EventHandler(this.grpBloodBagReturned_Enter);
            // 
            // rdoBloodBagReturned
            // 
            this.rdoBloodBagReturned.AccessibleDescription = "Blood Bag Returned";
            this.rdoBloodBagReturned.AccessibleName = "Blood Bag Returned";
            this.rdoBloodBagReturned.Location = new System.Drawing.Point(8, 16);
            this.rdoBloodBagReturned.Name = "rdoBloodBagReturned";
            this.rdoBloodBagReturned.Size = new System.Drawing.Size(192, 16);
            this.rdoBloodBagReturned.TabIndex = 0;
            this.rdoBloodBagReturned.TabStop = true;
            this.rdoBloodBagReturned.Text = "&Blood Bag Returned";
            this.rdoBloodBagReturned.CheckedChanged += new System.EventHandler(this.BloodBagReturnedChecked);
            // 
            // rdoBloodBagNotReturned
            // 
            this.rdoBloodBagNotReturned.AccessibleDescription = "Blood Bag Not Returned";
            this.rdoBloodBagNotReturned.AccessibleName = "Blood Bag Not Returned";
            this.rdoBloodBagNotReturned.Location = new System.Drawing.Point(8, 36);
            this.rdoBloodBagNotReturned.Name = "rdoBloodBagNotReturned";
            this.rdoBloodBagNotReturned.Size = new System.Drawing.Size(192, 16);
            this.rdoBloodBagNotReturned.TabIndex = 1;
            this.rdoBloodBagNotReturned.Text = "Blood Bag Not &Returned";
            this.rdoBloodBagNotReturned.CheckedChanged += new System.EventHandler(this.BloodBagReturnedChecked);
            // 
            // grpImplicatedUnit
            // 
            this.grpImplicatedUnit.Controls.Add(this.picUnitIDScanner);
            this.grpImplicatedUnit.Controls.Add(this.txtProduct);
            this.grpImplicatedUnit.Controls.Add(this.txtUnitID);
            this.grpImplicatedUnit.Controls.Add(this.lblProduct);
            this.grpImplicatedUnit.Controls.Add(this.picProductScanner);
            this.grpImplicatedUnit.Controls.Add(this.lblUnitID);
            this.grpImplicatedUnit.Location = new System.Drawing.Point(8, 12);
            this.grpImplicatedUnit.Name = "grpImplicatedUnit";
            this.grpImplicatedUnit.Size = new System.Drawing.Size(212, 64);
            this.grpImplicatedUnit.TabIndex = 0;
            this.grpImplicatedUnit.TabStop = false;
            // 
            // picUnitIDScanner
            // 
            this.picUnitIDScanner.Image = ((System.Drawing.Image)(resources.GetObject("picUnitIDScanner.Image")));
            this.picUnitIDScanner.Location = new System.Drawing.Point(8, 12);
            this.picUnitIDScanner.Name = "picUnitIDScanner";
            this.picUnitIDScanner.Size = new System.Drawing.Size(20, 20);
            this.picUnitIDScanner.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picUnitIDScanner.TabIndex = 34;
            this.picUnitIDScanner.TabStop = false;
            // 
            // txtProduct
            // 
            this.txtProduct.AccessibleDescription = "Product";
            this.txtProduct.AccessibleName = "Product";
            this.txtProduct.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtProduct.Barcode = false;
            this.txtProduct.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtProduct.Location = new System.Drawing.Point(76, 36);
            this.txtProduct.MaxLength = 10;
            this.txtProduct.Name = "txtProduct";
            this.txtProduct.RecursionGuard = false;
            this.txtProduct.Size = new System.Drawing.Size(116, 20);
            this.txtProduct.TabIndex = 3;
            this.txtProduct.KeyDown += new System.Windows.Forms.KeyEventHandler(this.txtProduct_KeyDown);
            this.txtProduct.Leave += new System.EventHandler(this.txtProduct_Leave);
            // 
            // txtUnitID
            // 
            this.txtUnitID.AccessibleDescription = "Unit I D ";
            this.txtUnitID.AccessibleName = "Unit I D ";
            this.txtUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtUnitID.Barcode = false;
            this.txtUnitID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
            this.txtUnitID.Location = new System.Drawing.Point(76, 12);
            this.txtUnitID.MaxLength = 15;
            this.txtUnitID.Name = "txtUnitID";
            this.txtUnitID.Size = new System.Drawing.Size(116, 20);
            this.txtUnitID.TabIndex = 1;
            this.txtUnitID.KeyDown += new System.Windows.Forms.KeyEventHandler(this.txtUnitID_KeyDown);
            this.txtUnitID.Leave += new System.EventHandler(this.txtUnitID_Leave);
            // 
            // lblProduct
            // 
            this.lblProduct.Location = new System.Drawing.Point(28, 36);
            this.lblProduct.Name = "lblProduct";
            this.lblProduct.Size = new System.Drawing.Size(56, 20);
            this.lblProduct.TabIndex = 2;
            this.lblProduct.Text = "Product*";
            this.lblProduct.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // picProductScanner
            // 
            this.picProductScanner.Image = ((System.Drawing.Image)(resources.GetObject("picProductScanner.Image")));
            this.picProductScanner.Location = new System.Drawing.Point(8, 36);
            this.picProductScanner.Name = "picProductScanner";
            this.picProductScanner.Size = new System.Drawing.Size(20, 20);
            this.picProductScanner.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
            this.picProductScanner.TabIndex = 32;
            this.picProductScanner.TabStop = false;
            // 
            // lblUnitID
            // 
            this.lblUnitID.Location = new System.Drawing.Point(28, 12);
            this.lblUnitID.Name = "lblUnitID";
            this.lblUnitID.Size = new System.Drawing.Size(56, 20);
            this.lblUnitID.TabIndex = 0;
            this.lblUnitID.Text = "Unit ID*";
            this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnClearUnit
            // 
            this.btnClearUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnClearUnit.Location = new System.Drawing.Point(564, 144);
            this.btnClearUnit.Name = "btnClearUnit";
            this.btnClearUnit.Size = new System.Drawing.Size(75, 23);
            this.btnClearUnit.TabIndex = 5;
            this.btnClearUnit.Text = "C&lear";
            this.btnClearUnit.Click += new System.EventHandler(this.btnClearUnit_Click);
            // 
            // btnAddUnit
            // 
            this.btnAddUnit.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddUnit.EnabledButton = false;
            this.btnAddUnit.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnAddUnit.Image = ((System.Drawing.Image)(resources.GetObject("btnAddUnit.Image")));
            this.btnAddUnit.Location = new System.Drawing.Point(484, 144);
            this.btnAddUnit.Name = "btnAddUnit";
            this.btnAddUnit.Size = new System.Drawing.Size(75, 23);
            this.btnAddUnit.TabIndex = 4;
            this.btnAddUnit.Click += new System.EventHandler(this.btnAddUnit_Click);
            this.btnAddUnit.MouseHover += new System.EventHandler(this.btnAddUnit_MouseHover);
            // 
            // grpBloodBagChecks
            // 
            this.grpBloodBagChecks.AccessibleDescription = "Blood Bag Checks";
            this.grpBloodBagChecks.AccessibleName = "Blood Bag Checks";
            this.grpBloodBagChecks.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpBloodBagChecks.Controls.Add(this.grpBloodBagClericalChecks);
            this.grpBloodBagChecks.Controls.Add(this.cmbUnitHemolysis);
            this.grpBloodBagChecks.Controls.Add(this.lblUnitHemolysis);
            this.grpBloodBagChecks.Controls.Add(this.grpBagComment);
            this.grpBloodBagChecks.Enabled = false;
            this.grpBloodBagChecks.Location = new System.Drawing.Point(224, 12);
            this.grpBloodBagChecks.Name = "grpBloodBagChecks";
            this.grpBloodBagChecks.Size = new System.Drawing.Size(416, 128);
            this.grpBloodBagChecks.TabIndex = 3;
            this.grpBloodBagChecks.TabStop = false;
            this.grpBloodBagChecks.Text = "Blood Bag Checks";
            // 
            // grpBloodBagClericalChecks
            // 
            this.grpBloodBagClericalChecks.AccessibleDescription = "Clerical Check";
            this.grpBloodBagClericalChecks.AccessibleName = "Clerical Check";
            this.grpBloodBagClericalChecks.Controls.Add(this.rdoBagCheckFail);
            this.grpBloodBagClericalChecks.Controls.Add(this.rdoBagCheckOK);
            this.grpBloodBagClericalChecks.Location = new System.Drawing.Point(8, 64);
            this.grpBloodBagClericalChecks.Name = "grpBloodBagClericalChecks";
            this.grpBloodBagClericalChecks.Size = new System.Drawing.Size(144, 56);
            this.grpBloodBagClericalChecks.TabIndex = 2;
            this.grpBloodBagClericalChecks.TabStop = false;
            this.grpBloodBagClericalChecks.Text = "Clerical Check*";
            // 
            // rdoBagCheckFail
            // 
            this.rdoBagCheckFail.AccessibleDescription = "Clerical Check Failed";
            this.rdoBagCheckFail.AccessibleName = "Clerical Check Failed";
            this.rdoBagCheckFail.Location = new System.Drawing.Point(8, 36);
            this.rdoBagCheckFail.Name = "rdoBagCheckFail";
            this.rdoBagCheckFail.Size = new System.Drawing.Size(132, 16);
            this.rdoBagCheckFail.TabIndex = 1;
            this.rdoBagCheckFail.Text = "Clerical Check &Failed";
            this.rdoBagCheckFail.CheckedChanged += new System.EventHandler(this.ClericalCheckChanged);
            // 
            // rdoBagCheckOK
            // 
            this.rdoBagCheckOK.AccessibleDescription = "Clerical Check O K";
            this.rdoBagCheckOK.AccessibleName = "Clerical Check O K";
            this.rdoBagCheckOK.Location = new System.Drawing.Point(8, 16);
            this.rdoBagCheckOK.Name = "rdoBagCheckOK";
            this.rdoBagCheckOK.Size = new System.Drawing.Size(120, 16);
            this.rdoBagCheckOK.TabIndex = 0;
            this.rdoBagCheckOK.TabStop = true;
            this.rdoBagCheckOK.Text = "Cl&erical Check OK";
            this.rdoBagCheckOK.CheckedChanged += new System.EventHandler(this.ClericalCheckChanged);
            // 
            // cmbUnitHemolysis
            // 
            this.cmbUnitHemolysis.AccessibleDescription = "Hemolysis Inspection";
            this.cmbUnitHemolysis.AccessibleName = "Hemolysis Inspection";
            this.cmbUnitHemolysis.Interval = 500;
            this.cmbUnitHemolysis.Location = new System.Drawing.Point(8, 36);
            this.cmbUnitHemolysis.MaxLength = 7;
            this.cmbUnitHemolysis.Name = "cmbUnitHemolysis";
            this.cmbUnitHemolysis.Size = new System.Drawing.Size(144, 22);
            this.cmbUnitHemolysis.TabIndex = 1;
            this.cmbUnitHemolysis.SelectedIndexChanged += new System.EventHandler(this.cmbUnitHemolysis_SelectedIndexChanged);
            // 
            // lblUnitHemolysis
            // 
            this.lblUnitHemolysis.Location = new System.Drawing.Point(8, 20);
            this.lblUnitHemolysis.Name = "lblUnitHemolysis";
            this.lblUnitHemolysis.Size = new System.Drawing.Size(116, 20);
            this.lblUnitHemolysis.TabIndex = 0;
            this.lblUnitHemolysis.Text = "Hemolysis Inspection*";
            this.lblUnitHemolysis.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpBagComment
            // 
            this.grpBagComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpBagComment.Controls.Add(this.cmbBagComment);
            this.grpBagComment.Controls.Add(this.txtBagComment);
            this.grpBagComment.Controls.Add(this.lblBagComment);
            this.grpBagComment.Controls.Add(this.lblBagDetails);
            this.grpBagComment.Location = new System.Drawing.Point(156, 8);
            this.grpBagComment.Name = "grpBagComment";
            this.grpBagComment.Size = new System.Drawing.Size(252, 112);
            this.grpBagComment.TabIndex = 3;
            this.grpBagComment.TabStop = false;
            // 
            // cmbBagComment
            // 
            this.cmbBagComment.AccessibleDescription = "Comment";
            this.cmbBagComment.AccessibleName = "Comment";
            this.cmbBagComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbBagComment.Interval = 500;
            this.cmbBagComment.Location = new System.Drawing.Point(60, 12);
            this.cmbBagComment.MaxLength = 80;
            this.cmbBagComment.Name = "cmbBagComment";
            this.cmbBagComment.Size = new System.Drawing.Size(184, 22);
            this.cmbBagComment.TabIndex = 1;
            this.cmbBagComment.SelectedIndexChanged += new System.EventHandler(this.BagClericalCheckCommentChanged);
            // 
            // txtBagComment
            // 
            this.txtBagComment.AccessibleDescription = "Details";
            this.txtBagComment.AccessibleName = "Details";
            this.txtBagComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtBagComment.Location = new System.Drawing.Point(60, 36);
            this.txtBagComment.MaxLength = 255;
            this.txtBagComment.Multiline = true;
            this.txtBagComment.Name = "txtBagComment";
            this.txtBagComment.Size = new System.Drawing.Size(184, 68);
            this.txtBagComment.TabIndex = 3;
            this.txtBagComment.TextChanged += new System.EventHandler(this.BagClericalCheckCommentChanged);
            // 
            // lblBagComment
            // 
            this.lblBagComment.Location = new System.Drawing.Point(8, 12);
            this.lblBagComment.Name = "lblBagComment";
            this.lblBagComment.Size = new System.Drawing.Size(60, 20);
            this.lblBagComment.TabIndex = 0;
            this.lblBagComment.Text = "Comment";
            this.lblBagComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblBagDetails
            // 
            this.lblBagDetails.Location = new System.Drawing.Point(8, 36);
            this.lblBagDetails.Name = "lblBagDetails";
            this.lblBagDetails.Size = new System.Drawing.Size(56, 20);
            this.lblBagDetails.TabIndex = 2;
            this.lblBagDetails.Text = "Details";
            this.lblBagDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpBagNotReturned
            // 
            this.grpBagNotReturned.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpBagNotReturned.Controls.Add(this.cmbBagNotReturnedComment);
            this.grpBagNotReturned.Controls.Add(this.lblBagNotReturnedComment);
            this.grpBagNotReturned.Controls.Add(this.txtBagNotReturnedComment);
            this.grpBagNotReturned.Controls.Add(this.lblBagNotReturnedDetails);
            this.grpBagNotReturned.Location = new System.Drawing.Point(224, 12);
            this.grpBagNotReturned.Name = "grpBagNotReturned";
            this.grpBagNotReturned.Size = new System.Drawing.Size(416, 128);
            this.grpBagNotReturned.TabIndex = 2;
            this.grpBagNotReturned.TabStop = false;
            this.grpBagNotReturned.Text = "Blood Bag Not Returned Comment";
            this.grpBagNotReturned.Visible = false;
            // 
            // cmbBagNotReturnedComment
            // 
            this.cmbBagNotReturnedComment.AccessibleDescription = "Comment";
            this.cmbBagNotReturnedComment.AccessibleName = "Comment";
            this.cmbBagNotReturnedComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbBagNotReturnedComment.Interval = 500;
            this.cmbBagNotReturnedComment.Location = new System.Drawing.Point(68, 16);
            this.cmbBagNotReturnedComment.MaxLength = 80;
            this.cmbBagNotReturnedComment.Name = "cmbBagNotReturnedComment";
            this.cmbBagNotReturnedComment.Size = new System.Drawing.Size(340, 22);
            this.cmbBagNotReturnedComment.TabIndex = 1;
            this.cmbBagNotReturnedComment.SelectedIndexChanged += new System.EventHandler(this.BagNotReturnedCommentChanged);
            // 
            // lblBagNotReturnedComment
            // 
            this.lblBagNotReturnedComment.Location = new System.Drawing.Point(8, 16);
            this.lblBagNotReturnedComment.Name = "lblBagNotReturnedComment";
            this.lblBagNotReturnedComment.Size = new System.Drawing.Size(60, 20);
            this.lblBagNotReturnedComment.TabIndex = 0;
            this.lblBagNotReturnedComment.Text = "Comment*";
            this.lblBagNotReturnedComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // txtBagNotReturnedComment
            // 
            this.txtBagNotReturnedComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtBagNotReturnedComment.Location = new System.Drawing.Point(68, 40);
            this.txtBagNotReturnedComment.MaxLength = 255;
            this.txtBagNotReturnedComment.Multiline = true;
            this.txtBagNotReturnedComment.Name = "txtBagNotReturnedComment";
            this.txtBagNotReturnedComment.Size = new System.Drawing.Size(340, 80);
            this.txtBagNotReturnedComment.TabIndex = 3;
            this.txtBagNotReturnedComment.TextChanged += new System.EventHandler(this.BagNotReturnedCommentChanged);
            // 
            // lblBagNotReturnedDetails
            // 
            this.lblBagNotReturnedDetails.Location = new System.Drawing.Point(8, 40);
            this.lblBagNotReturnedDetails.Name = "lblBagNotReturnedDetails";
            this.lblBagNotReturnedDetails.Size = new System.Drawing.Size(48, 16);
            this.lblBagNotReturnedDetails.TabIndex = 2;
            this.lblBagNotReturnedDetails.Text = "Details";
            this.lblBagNotReturnedDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnUnitsOK
            // 
            this.btnUnitsOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnUnitsOK.EnabledButton = false;
            this.btnUnitsOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnUnitsOK.Image = ((System.Drawing.Image)(resources.GetObject("btnUnitsOK.Image")));
            this.btnUnitsOK.Location = new System.Drawing.Point(576, 328);
            this.btnUnitsOK.Name = "btnUnitsOK";
            this.btnUnitsOK.Size = new System.Drawing.Size(75, 23);
            this.btnUnitsOK.TabIndex = 3;
            this.btnUnitsOK.Click += new System.EventHandler(this.SaveImplicatedUnits);
            this.btnUnitsOK.MouseHover += new System.EventHandler(this.btnUnitsOK_MouseHover);
            // 
            // grpImplicatedUnits
            // 
            this.grpImplicatedUnits.AccessibleDescription = "Implicated Units";
            this.grpImplicatedUnits.AccessibleName = "Implicated Units";
            this.grpImplicatedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpImplicatedUnits.Controls.Add(this.lvImplicatedUnits);
            this.grpImplicatedUnits.Location = new System.Drawing.Point(4, 240);
            this.grpImplicatedUnits.Name = "grpImplicatedUnits";
            this.grpImplicatedUnits.Size = new System.Drawing.Size(648, 84);
            this.grpImplicatedUnits.TabIndex = 2;
            this.grpImplicatedUnits.TabStop = false;
            this.grpImplicatedUnits.Text = "Implicated Unit(s)";
            this.grpImplicatedUnits.Visible = false;
            // 
            // lvImplicatedUnits
            // 
            this.lvImplicatedUnits.AccessibleDescription = "Implicated Units";
            this.lvImplicatedUnits.AccessibleName = "Implicated Units";
            this.lvImplicatedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvImplicatedUnits.CheckBoxes = true;
            this.lvImplicatedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader4,
            this.columnHeader5,
            this.columnHeader6,
            this.columnHeader2,
            this.columnHeader7,
            this.columnHeader1});
            this.lvImplicatedUnits.FullRowSelect = true;
            this.lvImplicatedUnits.HideSelection = false;
            this.lvImplicatedUnits.Location = new System.Drawing.Point(8, 16);
            this.lvImplicatedUnits.MultiSelect = false;
            this.lvImplicatedUnits.Name = "lvImplicatedUnits";
            this.lvImplicatedUnits.Size = new System.Drawing.Size(632, 60);
            this.lvImplicatedUnits.TabIndex = 0;
            this.lvImplicatedUnits.UseCompatibleStateImageBehavior = false;
            this.lvImplicatedUnits.View = System.Windows.Forms.View.Details;
            this.lvImplicatedUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvImplicatedUnits_ColumnClick);
            this.lvImplicatedUnits.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvImplicatedUnits_ItemCheck);
            this.lvImplicatedUnits.SelectedIndexChanged += new System.EventHandler(this.lvImplicatedUnits_SelectedIndexChanged);
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "";
            this.columnHeader4.Width = 25;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Unit ID";
            this.columnHeader5.Width = 120;
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "Product";
            this.columnHeader6.Width = 120;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "ABO/Rh";
            this.columnHeader2.Width = 120;
            // 
            // columnHeader7
            // 
            this.columnHeader7.Text = "Expires";
            this.columnHeader7.Width = 120;
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Hemolysis";
            this.columnHeader1.Width = 80;
            // 
            // pageSerolgicTests
            // 
            this.pageSerolgicTests.Controls.Add(this.pnlSerologicTests);
            this.pageSerolgicTests.Location = new System.Drawing.Point(4, 23);
            this.pageSerolgicTests.Name = "pageSerolgicTests";
            this.pageSerolgicTests.Size = new System.Drawing.Size(656, 353);
            this.pageSerolgicTests.TabIndex = 1;
            this.pageSerolgicTests.Text = "Serologic Tests";
            // 
            // pnlSerologicTests
            // 
            this.pnlSerologicTests.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlSerologicTests.Controls.Add(this.lblCompleteMessage4);
            this.pnlSerologicTests.Controls.Add(this.txtTestDetails);
            this.pnlSerologicTests.Controls.Add(this.cmbTestComment);
            this.pnlSerologicTests.Controls.Add(this.lblTestDetails);
            this.pnlSerologicTests.Controls.Add(this.lblTestComment);
            this.pnlSerologicTests.Controls.Add(this.cbAutomatedInstrument);
            this.pnlSerologicTests.Controls.Add(this.cmbRack);
            this.pnlSerologicTests.Controls.Add(this.cmbTestedBy);
            this.pnlSerologicTests.Controls.Add(this.dtpDateTested);
            this.pnlSerologicTests.Controls.Add(this.cbDAT);
            this.pnlSerologicTests.Controls.Add(this.lblRack);
            this.pnlSerologicTests.Controls.Add(this.lblTestedBy);
            this.pnlSerologicTests.Controls.Add(this.cbXM);
            this.pnlSerologicTests.Controls.Add(this.grpXM);
            this.pnlSerologicTests.Controls.Add(this.btnTestsOK);
            this.pnlSerologicTests.Controls.Add(this.cbABORh);
            this.pnlSerologicTests.Controls.Add(this.cbABS);
            this.pnlSerologicTests.Controls.Add(this.lblDateTested);
            this.pnlSerologicTests.Controls.Add(this.grpABORh);
            this.pnlSerologicTests.Controls.Add(this.grpAutomatedInstrument);
            this.pnlSerologicTests.Controls.Add(this.grpABS);
            this.pnlSerologicTests.Controls.Add(this.grpDAT);
            this.pnlSerologicTests.Location = new System.Drawing.Point(0, 0);
            this.pnlSerologicTests.Name = "pnlSerologicTests";
            this.pnlSerologicTests.Size = new System.Drawing.Size(656, 352);
            this.pnlSerologicTests.TabIndex = 0;
            // 
            // lblCompleteMessage4
            // 
            this.lblCompleteMessage4.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.lblCompleteMessage4.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this.lblCompleteMessage4.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblCompleteMessage4.Location = new System.Drawing.Point(4, 328);
            this.lblCompleteMessage4.Name = "lblCompleteMessage4";
            this.lblCompleteMessage4.Size = new System.Drawing.Size(516, 20);
            this.lblCompleteMessage4.TabIndex = 20;
            this.lblCompleteMessage4.Text = "Final report to follow in hard copy with medical director evaluation of the trans" +
    "fusion reaction workup";
            this.lblCompleteMessage4.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            this.lblCompleteMessage4.Visible = false;
            // 
            // txtTestDetails
            // 
            this.txtTestDetails.AccessibleDescription = "Details";
            this.txtTestDetails.AccessibleName = "Details";
            this.txtTestDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtTestDetails.Enabled = false;
            this.txtTestDetails.Location = new System.Drawing.Point(480, 32);
            this.txtTestDetails.MaxLength = 255;
            this.txtTestDetails.Multiline = true;
            this.txtTestDetails.Name = "txtTestDetails";
            this.txtTestDetails.Size = new System.Drawing.Size(164, 42);
            this.txtTestDetails.TabIndex = 11;
            this.txtTestDetails.TextChanged += new System.EventHandler(this.txtTestDetails_TextChanged);
            // 
            // cmbTestComment
            // 
            this.cmbTestComment.AccessibleDescription = "Comment";
            this.cmbTestComment.AccessibleName = "Comment";
            this.cmbTestComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbTestComment.Enabled = false;
            this.cmbTestComment.Interval = 500;
            this.cmbTestComment.Location = new System.Drawing.Point(480, 8);
            this.cmbTestComment.MaxLength = 80;
            this.cmbTestComment.Name = "cmbTestComment";
            this.cmbTestComment.Size = new System.Drawing.Size(164, 22);
            this.cmbTestComment.TabIndex = 9;
            this.cmbTestComment.SelectedIndexChanged += new System.EventHandler(this.cmbTestComment_SelectedIndexChanged);
            // 
            // lblTestDetails
            // 
            this.lblTestDetails.Location = new System.Drawing.Point(428, 32);
            this.lblTestDetails.Name = "lblTestDetails";
            this.lblTestDetails.Size = new System.Drawing.Size(52, 20);
            this.lblTestDetails.TabIndex = 10;
            this.lblTestDetails.Text = "Details";
            this.lblTestDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTestComment
            // 
            this.lblTestComment.Location = new System.Drawing.Point(428, 8);
            this.lblTestComment.Name = "lblTestComment";
            this.lblTestComment.Size = new System.Drawing.Size(56, 20);
            this.lblTestComment.TabIndex = 8;
            this.lblTestComment.Text = "Comment";
            this.lblTestComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cbAutomatedInstrument
            // 
            this.cbAutomatedInstrument.AccessibleDescription = "Using Automated Instrument";
            this.cbAutomatedInstrument.AccessibleName = "Using Automated Instrument";
            this.cbAutomatedInstrument.Enabled = false;
            this.cbAutomatedInstrument.Location = new System.Drawing.Point(232, 4);
            this.cbAutomatedInstrument.Name = "cbAutomatedInstrument";
            this.cbAutomatedInstrument.Size = new System.Drawing.Size(176, 20);
            this.cbAutomatedInstrument.TabIndex = 6;
            this.cbAutomatedInstrument.Text = "&Using Automated Instrument";
            this.cbAutomatedInstrument.CheckedChanged += new System.EventHandler(this.cbAutomatedInstrument_CheckedChanged);
            // 
            // cmbRack
            // 
            this.cmbRack.AccessibleDescription = "Rack";
            this.cmbRack.AccessibleName = "Rack";
            this.cmbRack.Enabled = false;
            this.cmbRack.Interval = 500;
            this.cmbRack.Location = new System.Drawing.Point(88, 52);
            this.cmbRack.MaxLength = 2;
            this.cmbRack.Name = "cmbRack";
            this.cmbRack.Size = new System.Drawing.Size(132, 22);
            this.cmbRack.TabIndex = 5;
            this.cmbRack.SelectedIndexChanged += new System.EventHandler(this.cmbRack_SelectedIndexChanged);
            this.cmbRack.Leave += new System.EventHandler(this.cmbRack_Leave);
            // 
            // cmbTestedBy
            // 
            this.cmbTestedBy.AccessibleDescription = "Tested By";
            this.cmbTestedBy.AccessibleName = "Tested By";
            this.cmbTestedBy.Enabled = false;
            this.cmbTestedBy.Interval = 500;
            this.cmbTestedBy.Location = new System.Drawing.Point(88, 28);
            this.cmbTestedBy.MaxLength = 50;
            this.cmbTestedBy.Name = "cmbTestedBy";
            this.cmbTestedBy.Size = new System.Drawing.Size(132, 22);
            this.cmbTestedBy.TabIndex = 3;
            this.cmbTestedBy.SelectedIndexChanged += new System.EventHandler(this.cmbTestedBy_SelectedIndexChanged);
            // 
            // dtpDateTested
            // 
            this.dtpDateTested.AccessibleDescription = "Date Tested";
            this.dtpDateTested.AccessibleName = "Date Tested";
            this.dtpDateTested.CustomFormat = "MM/dd/yyyy HH:mm";
            this.dtpDateTested.Enabled = false;
            this.dtpDateTested.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpDateTested.Location = new System.Drawing.Point(88, 4);
            this.dtpDateTested.Name = "dtpDateTested";
            this.dtpDateTested.Size = new System.Drawing.Size(132, 20);
            this.dtpDateTested.TabIndex = 1;
            this.dtpDateTested.ValueChanged += new System.EventHandler(this.DateTestedValueChanged);
            // 
            // cbDAT
            // 
            this.cbDAT.AccessibleDescription = "D A T";
            this.cbDAT.AccessibleName = "D A T";
            this.cbDAT.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.cbDAT.Location = new System.Drawing.Point(340, 232);
            this.cbDAT.Name = "cbDAT";
            this.cbDAT.Size = new System.Drawing.Size(64, 16);
            this.cbDAT.TabIndex = 18;
            this.cbDAT.Text = "&DAT";
            this.cbDAT.CheckedChanged += new System.EventHandler(this.DATChecked);
            // 
            // lblRack
            // 
            this.lblRack.Location = new System.Drawing.Point(8, 52);
            this.lblRack.Name = "lblRack";
            this.lblRack.Size = new System.Drawing.Size(76, 20);
            this.lblRack.TabIndex = 4;
            this.lblRack.Text = "Rack*";
            this.lblRack.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblTestedBy
            // 
            this.lblTestedBy.Location = new System.Drawing.Point(8, 28);
            this.lblTestedBy.Name = "lblTestedBy";
            this.lblTestedBy.Size = new System.Drawing.Size(80, 20);
            this.lblTestedBy.TabIndex = 2;
            this.lblTestedBy.Text = "Tested By*";
            this.lblTestedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cbXM
            // 
            this.cbXM.AccessibleDescription = "CrossMatch";
            this.cbXM.AccessibleName = "CrossMatch";
            this.cbXM.Location = new System.Drawing.Point(340, 80);
            this.cbXM.Name = "cbXM";
            this.cbXM.Size = new System.Drawing.Size(68, 16);
            this.cbXM.TabIndex = 16;
            this.cbXM.Text = "&XM";
            this.cbXM.CheckedChanged += new System.EventHandler(this.XMChecked);
            // 
            // grpXM
            // 
            this.grpXM.AccessibleDescription = "crossmatch";
            this.grpXM.AccessibleName = "crossmatch";
            this.grpXM.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpXM.Controls.Add(this.pnlXM);
            this.grpXM.Enabled = false;
            this.grpXM.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpXM.Location = new System.Drawing.Point(332, 80);
            this.grpXM.Name = "grpXM";
            this.grpXM.Size = new System.Drawing.Size(320, 148);
            this.grpXM.TabIndex = 17;
            this.grpXM.TabStop = false;
            // 
            // pnlXM
            // 
            this.pnlXM.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlXM.AutoScroll = true;
            this.pnlXM.BackColor = System.Drawing.SystemColors.Window;
            this.pnlXM.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pnlXM.Controls.Add(this.pnlXMRight);
            this.pnlXM.Controls.Add(this.pnlXMMiddle);
            this.pnlXM.Controls.Add(this.pnlXMLabels);
            this.pnlXM.Location = new System.Drawing.Point(8, 16);
            this.pnlXM.Name = "pnlXM";
            this.pnlXM.Size = new System.Drawing.Size(304, 124);
            this.pnlXM.TabIndex = 0;
            this.pnlXM.SizeChanged += new System.EventHandler(this.XMPanelResized);
            // 
            // pnlXMRight
            // 
            this.pnlXMRight.Controls.Add(this.pnlPostXM);
            this.pnlXMRight.Controls.Add(this.lblPostXMInterp);
            this.pnlXMRight.Dock = System.Windows.Forms.DockStyle.Fill;
            this.pnlXMRight.Location = new System.Drawing.Point(200, 0);
            this.pnlXMRight.Name = "pnlXMRight";
            this.pnlXMRight.Size = new System.Drawing.Size(100, 120);
            this.pnlXMRight.TabIndex = 31;
            // 
            // pnlPostXM
            // 
            this.pnlPostXM.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPostXM.Controls.Add(this.cmbUnitPostXMInterp1);
            this.pnlPostXM.Location = new System.Drawing.Point(0, 20);
            this.pnlPostXM.Name = "pnlPostXM";
            this.pnlPostXM.Size = new System.Drawing.Size(100, 100);
            this.pnlPostXM.TabIndex = 0;
            // 
            // cmbUnitPostXMInterp1
            // 
            this.cmbUnitPostXMInterp1.AccessibleDescription = "Unit I D Post Interpretation";
            this.cmbUnitPostXMInterp1.AccessibleName = "Unit I D Post Interpretation";
            this.cmbUnitPostXMInterp1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbUnitPostXMInterp1.Interval = 500;
            this.cmbUnitPostXMInterp1.Location = new System.Drawing.Point(0, 0);
            this.cmbUnitPostXMInterp1.MaxLength = 12;
            this.cmbUnitPostXMInterp1.Name = "cmbUnitPostXMInterp1";
            this.cmbUnitPostXMInterp1.Size = new System.Drawing.Size(100, 22);
            this.cmbUnitPostXMInterp1.TabIndex = 0;
            this.cmbUnitPostXMInterp1.SelectedIndexChanged += new System.EventHandler(this.XMInterpChanged);
            // 
            // lblPostXMInterp
            // 
            this.lblPostXMInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblPostXMInterp.BackColor = System.Drawing.SystemColors.Control;
            this.lblPostXMInterp.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblPostXMInterp.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblPostXMInterp.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblPostXMInterp.Location = new System.Drawing.Point(0, 0);
            this.lblPostXMInterp.Name = "lblPostXMInterp";
            this.lblPostXMInterp.Size = new System.Drawing.Size(100, 20);
            this.lblPostXMInterp.TabIndex = 1;
            this.lblPostXMInterp.Text = "Post Interp.";
            this.lblPostXMInterp.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // pnlXMMiddle
            // 
            this.pnlXMMiddle.Controls.Add(this.pnlPreXM);
            this.pnlXMMiddle.Controls.Add(this.lblPreXMInterp);
            this.pnlXMMiddle.Dock = System.Windows.Forms.DockStyle.Left;
            this.pnlXMMiddle.Location = new System.Drawing.Point(100, 0);
            this.pnlXMMiddle.Name = "pnlXMMiddle";
            this.pnlXMMiddle.Size = new System.Drawing.Size(100, 120);
            this.pnlXMMiddle.TabIndex = 30;
            // 
            // pnlPreXM
            // 
            this.pnlPreXM.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlPreXM.Controls.Add(this.cmbUnitPreXMInterp1);
            this.pnlPreXM.Location = new System.Drawing.Point(0, 20);
            this.pnlPreXM.Name = "pnlPreXM";
            this.pnlPreXM.Size = new System.Drawing.Size(100, 100);
            this.pnlPreXM.TabIndex = 0;
            // 
            // cmbUnitPreXMInterp1
            // 
            this.cmbUnitPreXMInterp1.AccessibleDescription = "Unit I D Pre Interpretation";
            this.cmbUnitPreXMInterp1.AccessibleName = "Unit I D Pre Interpretation";
            this.cmbUnitPreXMInterp1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbUnitPreXMInterp1.Interval = 500;
            this.cmbUnitPreXMInterp1.Location = new System.Drawing.Point(0, 0);
            this.cmbUnitPreXMInterp1.MaxLength = 12;
            this.cmbUnitPreXMInterp1.Name = "cmbUnitPreXMInterp1";
            this.cmbUnitPreXMInterp1.Size = new System.Drawing.Size(99, 22);
            this.cmbUnitPreXMInterp1.TabIndex = 0;
            this.cmbUnitPreXMInterp1.SelectedIndexChanged += new System.EventHandler(this.XMInterpChanged);
            // 
            // lblPreXMInterp
            // 
            this.lblPreXMInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblPreXMInterp.BackColor = System.Drawing.SystemColors.Control;
            this.lblPreXMInterp.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblPreXMInterp.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblPreXMInterp.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblPreXMInterp.Location = new System.Drawing.Point(0, 0);
            this.lblPreXMInterp.Name = "lblPreXMInterp";
            this.lblPreXMInterp.Size = new System.Drawing.Size(100, 20);
            this.lblPreXMInterp.TabIndex = 1;
            this.lblPreXMInterp.Text = "Pre Interp.";
            this.lblPreXMInterp.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // pnlXMLabels
            // 
            this.pnlXMLabels.Controls.Add(this.lblXM);
            this.pnlXMLabels.Controls.Add(this.lblUnitXM1);
            this.pnlXMLabels.Dock = System.Windows.Forms.DockStyle.Left;
            this.pnlXMLabels.Location = new System.Drawing.Point(0, 0);
            this.pnlXMLabels.Name = "pnlXMLabels";
            this.pnlXMLabels.Size = new System.Drawing.Size(100, 120);
            this.pnlXMLabels.TabIndex = 0;
            // 
            // lblXM
            // 
            this.lblXM.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblXM.BackColor = System.Drawing.SystemColors.Control;
            this.lblXM.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblXM.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblXM.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblXM.Location = new System.Drawing.Point(0, 0);
            this.lblXM.Name = "lblXM";
            this.lblXM.Size = new System.Drawing.Size(100, 20);
            this.lblXM.TabIndex = 0;
            this.lblXM.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblUnitXM1
            // 
            this.lblUnitXM1.Location = new System.Drawing.Point(4, 20);
            this.lblUnitXM1.Name = "lblUnitXM1";
            this.lblUnitXM1.Size = new System.Drawing.Size(108, 20);
            this.lblUnitXM1.TabIndex = 1;
            this.lblUnitXM1.Text = "Unit ID";
            this.lblUnitXM1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnTestsOK
            // 
            this.btnTestsOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnTestsOK.EnabledButton = false;
            this.btnTestsOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnTestsOK.Image = ((System.Drawing.Image)(resources.GetObject("btnTestsOK.Image")));
            this.btnTestsOK.Location = new System.Drawing.Point(576, 328);
            this.btnTestsOK.Name = "btnTestsOK";
            this.btnTestsOK.Size = new System.Drawing.Size(75, 23);
            this.btnTestsOK.TabIndex = 21;
            this.btnTestsOK.Click += new System.EventHandler(this.SaveSerologicTests);
            this.btnTestsOK.MouseHover += new System.EventHandler(this.btnTestsOK_MouseHover);
            // 
            // cbABORh
            // 
            this.cbABORh.AccessibleDescription = "A B O R H";
            this.cbABORh.AccessibleName = "A B O R H";
            this.cbABORh.Location = new System.Drawing.Point(12, 80);
            this.cbABORh.Name = "cbABORh";
            this.cbABORh.Size = new System.Drawing.Size(72, 16);
            this.cbABORh.TabIndex = 12;
            this.cbABORh.Text = "&ABO/Rh";
            this.cbABORh.CheckedChanged += new System.EventHandler(this.ABORhChecked);
            // 
            // cbABS
            // 
            this.cbABS.AccessibleDescription = "A B S";
            this.cbABS.AccessibleName = "A B S";
            this.cbABS.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.cbABS.Location = new System.Drawing.Point(12, 232);
            this.cbABS.Name = "cbABS";
            this.cbABS.Size = new System.Drawing.Size(72, 16);
            this.cbABS.TabIndex = 14;
            this.cbABS.Text = "A&BS";
            this.cbABS.CheckedChanged += new System.EventHandler(this.ABSChecked);
            // 
            // lblDateTested
            // 
            this.lblDateTested.Location = new System.Drawing.Point(8, 4);
            this.lblDateTested.Name = "lblDateTested";
            this.lblDateTested.Size = new System.Drawing.Size(80, 20);
            this.lblDateTested.TabIndex = 0;
            this.lblDateTested.Text = "Date Tested*";
            this.lblDateTested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpABORh
            // 
            this.grpABORh.AccessibleDescription = "A B O R H";
            this.grpABORh.AccessibleName = "A B O R H";
            this.grpABORh.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpABORh.Controls.Add(this.pnlABORh);
            this.grpABORh.Enabled = false;
            this.grpABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpABORh.Location = new System.Drawing.Point(4, 80);
            this.grpABORh.Name = "grpABORh";
            this.grpABORh.Size = new System.Drawing.Size(320, 148);
            this.grpABORh.TabIndex = 13;
            this.grpABORh.TabStop = false;
            // 
            // pnlABORh
            // 
            this.pnlABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlABORh.AutoScroll = true;
            this.pnlABORh.BackColor = System.Drawing.SystemColors.Window;
            this.pnlABORh.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pnlABORh.Controls.Add(this.pnlABO);
            this.pnlABORh.Controls.Add(this.lblUnitABORh1);
            this.pnlABORh.Controls.Add(this.lblPostABORh);
            this.pnlABORh.Controls.Add(this.lblPreABORh);
            this.pnlABORh.Controls.Add(this.lblABORh);
            this.pnlABORh.Controls.Add(this.lblABOInterp);
            this.pnlABORh.Controls.Add(this.lblRhInterp);
            this.pnlABORh.Controls.Add(this.pnlRh);
            this.pnlABORh.Location = new System.Drawing.Point(8, 16);
            this.pnlABORh.Name = "pnlABORh";
            this.pnlABORh.Size = new System.Drawing.Size(304, 124);
            this.pnlABORh.TabIndex = 0;
            // 
            // pnlABO
            // 
            this.pnlABO.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.pnlABO.Controls.Add(this.cmbPreABOInterp);
            this.pnlABO.Controls.Add(this.cmbUnitABOInterp1);
            this.pnlABO.Controls.Add(this.cmbPostABOInterp);
            this.pnlABO.Location = new System.Drawing.Point(100, 20);
            this.pnlABO.Name = "pnlABO";
            this.pnlABO.Size = new System.Drawing.Size(100, 100);
            this.pnlABO.TabIndex = 6;
            // 
            // cmbPreABOInterp
            // 
            this.cmbPreABOInterp.AccessibleDescription = "Pre Transfusion A B O Interpretation";
            this.cmbPreABOInterp.AccessibleName = "Pre Transfusion A B O Interpretation";
            this.cmbPreABOInterp.Interval = 500;
            this.cmbPreABOInterp.Location = new System.Drawing.Point(0, 0);
            this.cmbPreABOInterp.MaxLength = 12;
            this.cmbPreABOInterp.Name = "cmbPreABOInterp";
            this.cmbPreABOInterp.Size = new System.Drawing.Size(99, 22);
            this.cmbPreABOInterp.TabIndex = 0;
            this.cmbPreABOInterp.SelectedIndexChanged += new System.EventHandler(this.PreSpecimenAboInterpChanged);
            // 
            // cmbUnitABOInterp1
            // 
            this.cmbUnitABOInterp1.AccessibleDescription = "Unit I D A B O Interpretation";
            this.cmbUnitABOInterp1.AccessibleName = "Unit I D A B O Interpretation";
            this.cmbUnitABOInterp1.Interval = 500;
            this.cmbUnitABOInterp1.Location = new System.Drawing.Point(0, 48);
            this.cmbUnitABOInterp1.MaxLength = 12;
            this.cmbUnitABOInterp1.Name = "cmbUnitABOInterp1";
            this.cmbUnitABOInterp1.Size = new System.Drawing.Size(99, 22);
            this.cmbUnitABOInterp1.TabIndex = 2;
            // 
            // cmbPostABOInterp
            // 
            this.cmbPostABOInterp.AccessibleDescription = "Post Transfusion A B O Interpretation";
            this.cmbPostABOInterp.AccessibleName = "Post Transfusion A B O Interpretation";
            this.cmbPostABOInterp.Interval = 500;
            this.cmbPostABOInterp.Location = new System.Drawing.Point(0, 24);
            this.cmbPostABOInterp.MaxLength = 12;
            this.cmbPostABOInterp.Name = "cmbPostABOInterp";
            this.cmbPostABOInterp.Size = new System.Drawing.Size(99, 22);
            this.cmbPostABOInterp.TabIndex = 1;
            this.cmbPostABOInterp.SelectedIndexChanged += new System.EventHandler(this.PostSpecimenAboInterpChanged);
            // 
            // lblUnitABORh1
            // 
            this.lblUnitABORh1.Location = new System.Drawing.Point(4, 68);
            this.lblUnitABORh1.Name = "lblUnitABORh1";
            this.lblUnitABORh1.Size = new System.Drawing.Size(112, 20);
            this.lblUnitABORh1.TabIndex = 5;
            this.lblUnitABORh1.Text = "Unit ID";
            this.lblUnitABORh1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblPostABORh
            // 
            this.lblPostABORh.Location = new System.Drawing.Point(4, 44);
            this.lblPostABORh.Name = "lblPostABORh";
            this.lblPostABORh.Size = new System.Drawing.Size(112, 20);
            this.lblPostABORh.TabIndex = 4;
            this.lblPostABORh.Text = "Post-Transfusion";
            this.lblPostABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblPreABORh
            // 
            this.lblPreABORh.Location = new System.Drawing.Point(4, 20);
            this.lblPreABORh.Name = "lblPreABORh";
            this.lblPreABORh.Size = new System.Drawing.Size(112, 20);
            this.lblPreABORh.TabIndex = 3;
            this.lblPreABORh.Text = "Pre-Transfusion";
            this.lblPreABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblABORh
            // 
            this.lblABORh.BackColor = System.Drawing.SystemColors.Control;
            this.lblABORh.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblABORh.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblABORh.Location = new System.Drawing.Point(0, 0);
            this.lblABORh.Name = "lblABORh";
            this.lblABORh.Size = new System.Drawing.Size(100, 20);
            this.lblABORh.TabIndex = 0;
            this.lblABORh.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblABOInterp
            // 
            this.lblABOInterp.BackColor = System.Drawing.SystemColors.Control;
            this.lblABOInterp.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblABOInterp.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblABOInterp.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblABOInterp.Location = new System.Drawing.Point(100, 0);
            this.lblABOInterp.Name = "lblABOInterp";
            this.lblABOInterp.Size = new System.Drawing.Size(100, 20);
            this.lblABOInterp.TabIndex = 1;
            this.lblABOInterp.Text = "ABO Interp.";
            this.lblABOInterp.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblRhInterp
            // 
            this.lblRhInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblRhInterp.BackColor = System.Drawing.SystemColors.Control;
            this.lblRhInterp.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblRhInterp.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblRhInterp.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblRhInterp.Location = new System.Drawing.Point(200, 0);
            this.lblRhInterp.Name = "lblRhInterp";
            this.lblRhInterp.Size = new System.Drawing.Size(100, 20);
            this.lblRhInterp.TabIndex = 2;
            this.lblRhInterp.Text = "Rh Interp.";
            this.lblRhInterp.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // pnlRh
            // 
            this.pnlRh.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlRh.Controls.Add(this.cmbUnitRhInterp1);
            this.pnlRh.Controls.Add(this.cmbPostRhInterp);
            this.pnlRh.Controls.Add(this.cmbPreRhInterp);
            this.pnlRh.Location = new System.Drawing.Point(200, 20);
            this.pnlRh.Name = "pnlRh";
            this.pnlRh.Size = new System.Drawing.Size(100, 100);
            this.pnlRh.TabIndex = 7;
            // 
            // cmbUnitRhInterp1
            // 
            this.cmbUnitRhInterp1.AccessibleDescription = "Unit I D R H Interpretation";
            this.cmbUnitRhInterp1.AccessibleName = "Unit I D R H Interpretation";
            this.cmbUnitRhInterp1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbUnitRhInterp1.Interval = 500;
            this.cmbUnitRhInterp1.Location = new System.Drawing.Point(0, 48);
            this.cmbUnitRhInterp1.MaxLength = 12;
            this.cmbUnitRhInterp1.Name = "cmbUnitRhInterp1";
            this.cmbUnitRhInterp1.Size = new System.Drawing.Size(100, 22);
            this.cmbUnitRhInterp1.TabIndex = 2;
            // 
            // cmbPostRhInterp
            // 
            this.cmbPostRhInterp.AccessibleDescription = "Post Transfusion R H Interpretation";
            this.cmbPostRhInterp.AccessibleName = "Post Transfusion R H Interpretation";
            this.cmbPostRhInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPostRhInterp.Interval = 500;
            this.cmbPostRhInterp.Location = new System.Drawing.Point(0, 24);
            this.cmbPostRhInterp.MaxLength = 12;
            this.cmbPostRhInterp.Name = "cmbPostRhInterp";
            this.cmbPostRhInterp.Size = new System.Drawing.Size(100, 22);
            this.cmbPostRhInterp.TabIndex = 1;
            this.cmbPostRhInterp.SelectedIndexChanged += new System.EventHandler(this.PostSpecimenRhInterpChanged);
            // 
            // cmbPreRhInterp
            // 
            this.cmbPreRhInterp.AccessibleDescription = "Pre Transfusion R H Interpretation";
            this.cmbPreRhInterp.AccessibleName = "Pre Transfusion R H Interpretation";
            this.cmbPreRhInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPreRhInterp.Interval = 500;
            this.cmbPreRhInterp.Location = new System.Drawing.Point(0, 0);
            this.cmbPreRhInterp.MaxLength = 12;
            this.cmbPreRhInterp.Name = "cmbPreRhInterp";
            this.cmbPreRhInterp.Size = new System.Drawing.Size(100, 22);
            this.cmbPreRhInterp.TabIndex = 0;
            this.cmbPreRhInterp.SelectedIndexChanged += new System.EventHandler(this.PreSpecimenRhInterpChanged);
            // 
            // grpAutomatedInstrument
            // 
            this.grpAutomatedInstrument.AccessibleDescription = "Using Automated Instrument";
            this.grpAutomatedInstrument.AccessibleName = "Using Automated Instrument";
            this.grpAutomatedInstrument.Controls.Add(this.cbInstrumentQCd);
            this.grpAutomatedInstrument.Controls.Add(this.txtInstrumentName);
            this.grpAutomatedInstrument.Controls.Add(this.lblInstrumentName);
            this.grpAutomatedInstrument.Enabled = false;
            this.grpAutomatedInstrument.Location = new System.Drawing.Point(224, 6);
            this.grpAutomatedInstrument.Name = "grpAutomatedInstrument";
            this.grpAutomatedInstrument.Size = new System.Drawing.Size(200, 68);
            this.grpAutomatedInstrument.TabIndex = 7;
            this.grpAutomatedInstrument.TabStop = false;
            this.grpAutomatedInstrument.Text = "Automated Instrument";
            // 
            // cbInstrumentQCd
            // 
            this.cbInstrumentQCd.AccessibleDescription = "Instrument QCd";
            this.cbInstrumentQCd.AccessibleName = "Instrument QCd";
            this.cbInstrumentQCd.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbInstrumentQCd.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
            this.cbInstrumentQCd.Location = new System.Drawing.Point(8, 44);
            this.cbInstrumentQCd.Name = "cbInstrumentQCd";
            this.cbInstrumentQCd.Size = new System.Drawing.Size(184, 20);
            this.cbInstrumentQCd.TabIndex = 2;
            this.cbInstrumentQCd.Text = "Instrument &QC\'d?";
            this.cbInstrumentQCd.CheckedChanged += new System.EventHandler(this.cbInstrumentQCd_CheckedChanged);
            // 
            // txtInstrumentName
            // 
            this.txtInstrumentName.AccessibleDescription = "Name";
            this.txtInstrumentName.AccessibleName = "Name";
            this.txtInstrumentName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.txtInstrumentName.Location = new System.Drawing.Point(44, 20);
            this.txtInstrumentName.Name = "txtInstrumentName";
            this.txtInstrumentName.Size = new System.Drawing.Size(148, 20);
            this.txtInstrumentName.TabIndex = 1;
            this.txtInstrumentName.TextChanged += new System.EventHandler(this.txtInstrumentName_TextChanged);
            // 
            // lblInstrumentName
            // 
            this.lblInstrumentName.Location = new System.Drawing.Point(8, 20);
            this.lblInstrumentName.Name = "lblInstrumentName";
            this.lblInstrumentName.Size = new System.Drawing.Size(40, 20);
            this.lblInstrumentName.TabIndex = 0;
            this.lblInstrumentName.Text = "Name*";
            this.lblInstrumentName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpABS
            // 
            this.grpABS.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.grpABS.Controls.Add(this.pnlABS);
            this.grpABS.Enabled = false;
            this.grpABS.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpABS.Location = new System.Drawing.Point(4, 232);
            this.grpABS.Name = "grpABS";
            this.grpABS.Size = new System.Drawing.Size(320, 92);
            this.grpABS.TabIndex = 15;
            this.grpABS.TabStop = false;
            // 
            // pnlABS
            // 
            this.pnlABS.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlABS.BackColor = System.Drawing.SystemColors.Window;
            this.pnlABS.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pnlABS.Controls.Add(this.cmbPostABSInterp);
            this.pnlABS.Controls.Add(this.lblPostABS);
            this.pnlABS.Controls.Add(this.cmbPreABSInterp);
            this.pnlABS.Controls.Add(this.lblPreABS);
            this.pnlABS.Controls.Add(this.lblABS);
            this.pnlABS.Controls.Add(this.lblABSInterp);
            this.pnlABS.Location = new System.Drawing.Point(8, 16);
            this.pnlABS.Name = "pnlABS";
            this.pnlABS.Size = new System.Drawing.Size(304, 68);
            this.pnlABS.TabIndex = 0;
            // 
            // cmbPostABSInterp
            // 
            this.cmbPostABSInterp.AccessibleDescription = "Post Transfusion A B S Interpretation";
            this.cmbPostABSInterp.AccessibleName = "Post Transfusion A B S Interpretation";
            this.cmbPostABSInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPostABSInterp.Interval = 500;
            this.cmbPostABSInterp.Location = new System.Drawing.Point(100, 44);
            this.cmbPostABSInterp.MaxLength = 12;
            this.cmbPostABSInterp.Name = "cmbPostABSInterp";
            this.cmbPostABSInterp.Size = new System.Drawing.Size(200, 22);
            this.cmbPostABSInterp.TabIndex = 5;
            this.cmbPostABSInterp.SelectedIndexChanged += new System.EventHandler(this.PostAbsInterpChanged);
            // 
            // lblPostABS
            // 
            this.lblPostABS.Location = new System.Drawing.Point(4, 44);
            this.lblPostABS.Name = "lblPostABS";
            this.lblPostABS.Size = new System.Drawing.Size(112, 20);
            this.lblPostABS.TabIndex = 3;
            this.lblPostABS.Text = "Post-Transfusion";
            this.lblPostABS.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cmbPreABSInterp
            // 
            this.cmbPreABSInterp.AccessibleDescription = "Pre Transfusion A B S Interpretation";
            this.cmbPreABSInterp.AccessibleName = "Pre Transfusion A B S Interpretation";
            this.cmbPreABSInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPreABSInterp.Interval = 500;
            this.cmbPreABSInterp.Location = new System.Drawing.Point(100, 20);
            this.cmbPreABSInterp.MaxLength = 12;
            this.cmbPreABSInterp.Name = "cmbPreABSInterp";
            this.cmbPreABSInterp.Size = new System.Drawing.Size(200, 22);
            this.cmbPreABSInterp.TabIndex = 4;
            this.cmbPreABSInterp.SelectedIndexChanged += new System.EventHandler(this.PreAbsInterpChanged);
            // 
            // lblPreABS
            // 
            this.lblPreABS.Location = new System.Drawing.Point(4, 20);
            this.lblPreABS.Name = "lblPreABS";
            this.lblPreABS.Size = new System.Drawing.Size(112, 20);
            this.lblPreABS.TabIndex = 2;
            this.lblPreABS.Text = "Pre-Transfusion";
            this.lblPreABS.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblABS
            // 
            this.lblABS.BackColor = System.Drawing.SystemColors.Control;
            this.lblABS.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblABS.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblABS.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblABS.Location = new System.Drawing.Point(0, 0);
            this.lblABS.Name = "lblABS";
            this.lblABS.Size = new System.Drawing.Size(100, 20);
            this.lblABS.TabIndex = 0;
            this.lblABS.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblABSInterp
            // 
            this.lblABSInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblABSInterp.BackColor = System.Drawing.SystemColors.Control;
            this.lblABSInterp.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblABSInterp.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblABSInterp.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblABSInterp.Location = new System.Drawing.Point(100, 0);
            this.lblABSInterp.Name = "lblABSInterp";
            this.lblABSInterp.Size = new System.Drawing.Size(200, 20);
            this.lblABSInterp.TabIndex = 1;
            this.lblABSInterp.Text = "Interp.";
            this.lblABSInterp.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // grpDAT
            // 
            this.grpDAT.AccessibleDescription = "D A T";
            this.grpDAT.AccessibleName = "D A T";
            this.grpDAT.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpDAT.Controls.Add(this.pnlDAT);
            this.grpDAT.Enabled = false;
            this.grpDAT.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.grpDAT.Location = new System.Drawing.Point(332, 232);
            this.grpDAT.Name = "grpDAT";
            this.grpDAT.Size = new System.Drawing.Size(320, 92);
            this.grpDAT.TabIndex = 19;
            this.grpDAT.TabStop = false;
            // 
            // pnlDAT
            // 
            this.pnlDAT.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlDAT.BackColor = System.Drawing.SystemColors.Window;
            this.pnlDAT.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.pnlDAT.Controls.Add(this.cmbPostDATInterp);
            this.pnlDAT.Controls.Add(this.lblPostDAT);
            this.pnlDAT.Controls.Add(this.cmbPreDATInterp);
            this.pnlDAT.Controls.Add(this.lblPreDAT);
            this.pnlDAT.Controls.Add(this.lblDAT);
            this.pnlDAT.Controls.Add(this.lblDATInterp);
            this.pnlDAT.Location = new System.Drawing.Point(8, 16);
            this.pnlDAT.Name = "pnlDAT";
            this.pnlDAT.Size = new System.Drawing.Size(304, 68);
            this.pnlDAT.TabIndex = 0;
            // 
            // cmbPostDATInterp
            // 
            this.cmbPostDATInterp.AccessibleDescription = "Post Transfusion D A T Interpretation";
            this.cmbPostDATInterp.AccessibleName = "Post Transfusion D A T Interpretation";
            this.cmbPostDATInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPostDATInterp.Interval = 500;
            this.cmbPostDATInterp.Location = new System.Drawing.Point(100, 44);
            this.cmbPostDATInterp.MaxLength = 12;
            this.cmbPostDATInterp.Name = "cmbPostDATInterp";
            this.cmbPostDATInterp.Size = new System.Drawing.Size(200, 22);
            this.cmbPostDATInterp.TabIndex = 5;
            this.cmbPostDATInterp.SelectedIndexChanged += new System.EventHandler(this.PostDatInterpChanged);
            // 
            // lblPostDAT
            // 
            this.lblPostDAT.Location = new System.Drawing.Point(4, 44);
            this.lblPostDAT.Name = "lblPostDAT";
            this.lblPostDAT.Size = new System.Drawing.Size(112, 20);
            this.lblPostDAT.TabIndex = 2;
            this.lblPostDAT.Text = "Post-Transfusion";
            this.lblPostDAT.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // cmbPreDATInterp
            // 
            this.cmbPreDATInterp.AccessibleDescription = "Pre Transfusion D A T Interpretation";
            this.cmbPreDATInterp.AccessibleName = "Pre Transfusion D A T Interpretation";
            this.cmbPreDATInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbPreDATInterp.Interval = 500;
            this.cmbPreDATInterp.Location = new System.Drawing.Point(100, 20);
            this.cmbPreDATInterp.MaxLength = 12;
            this.cmbPreDATInterp.Name = "cmbPreDATInterp";
            this.cmbPreDATInterp.Size = new System.Drawing.Size(200, 22);
            this.cmbPreDATInterp.TabIndex = 4;
            this.cmbPreDATInterp.SelectedIndexChanged += new System.EventHandler(this.PreDatInterpChanged);
            // 
            // lblPreDAT
            // 
            this.lblPreDAT.Location = new System.Drawing.Point(4, 20);
            this.lblPreDAT.Name = "lblPreDAT";
            this.lblPreDAT.Size = new System.Drawing.Size(112, 20);
            this.lblPreDAT.TabIndex = 1;
            this.lblPreDAT.Text = "Pre-Transfusion";
            this.lblPreDAT.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // lblDAT
            // 
            this.lblDAT.BackColor = System.Drawing.SystemColors.Control;
            this.lblDAT.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblDAT.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblDAT.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblDAT.Location = new System.Drawing.Point(0, 0);
            this.lblDAT.Name = "lblDAT";
            this.lblDAT.Size = new System.Drawing.Size(100, 20);
            this.lblDAT.TabIndex = 0;
            this.lblDAT.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // lblDATInterp
            // 
            this.lblDATInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lblDATInterp.BackColor = System.Drawing.SystemColors.Control;
            this.lblDATInterp.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblDATInterp.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.lblDATInterp.ForeColor = System.Drawing.SystemColors.ControlText;
            this.lblDATInterp.Location = new System.Drawing.Point(100, 0);
            this.lblDATInterp.Name = "lblDATInterp";
            this.lblDATInterp.Size = new System.Drawing.Size(200, 20);
            this.lblDATInterp.TabIndex = 3;
            this.lblDATInterp.Text = "Interp.";
            this.lblDATInterp.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
            // 
            // dtpDateNoted
            // 
            this.dtpDateNoted.AccessibleDescription = "Date Transfusion Reaction Noted";
            this.dtpDateNoted.AccessibleName = "Date Transfusion Reaction Noted";
            this.dtpDateNoted.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpDateNoted.Location = new System.Drawing.Point(172, 12);
            this.dtpDateNoted.Name = "dtpDateNoted";
            this.dtpDateNoted.Size = new System.Drawing.Size(136, 20);
            this.dtpDateNoted.TabIndex = 1;
            this.dtpDateNoted.ValueChanged += new System.EventHandler(this.DateNotedChanged);
            // 
            // lblDateNoted
            // 
            this.lblDateNoted.Location = new System.Drawing.Point(8, 12);
            this.lblDateNoted.Name = "lblDateNoted";
            this.lblDateNoted.Size = new System.Drawing.Size(176, 20);
            this.lblDateNoted.TabIndex = 0;
            this.lblDateNoted.Text = "Date Transfusion Reaction Noted";
            this.lblDateNoted.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpTRWDates
            // 
            this.grpTRWDates.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpTRWDates.Controls.Add(this.dtpDateInvestigated);
            this.grpTRWDates.Controls.Add(this.lblDateInvestigated);
            this.grpTRWDates.Controls.Add(this.dtpDateNoted);
            this.grpTRWDates.Controls.Add(this.lblDateNoted);
            this.grpTRWDates.Location = new System.Drawing.Point(48, 72);
            this.grpTRWDates.Name = "grpTRWDates";
            this.grpTRWDates.Size = new System.Drawing.Size(664, 40);
            this.grpTRWDates.TabIndex = 0;
            this.grpTRWDates.TabStop = false;
            // 
            // dtpDateInvestigated
            // 
            this.dtpDateInvestigated.AccessibleDescription = "Date Transfusion Reaction Investigated";
            this.dtpDateInvestigated.AccessibleName = "Date Transfusion Reaction Investigated";
            this.dtpDateInvestigated.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.dtpDateInvestigated.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
            this.dtpDateInvestigated.Location = new System.Drawing.Point(524, 12);
            this.dtpDateInvestigated.Name = "dtpDateInvestigated";
            this.dtpDateInvestigated.Size = new System.Drawing.Size(136, 20);
            this.dtpDateInvestigated.TabIndex = 3;
            this.dtpDateInvestigated.ValueChanged += new System.EventHandler(this.DateInvestigatedChanged);
            // 
            // lblDateInvestigated
            // 
            this.lblDateInvestigated.Location = new System.Drawing.Point(328, 12);
            this.lblDateInvestigated.Name = "lblDateInvestigated";
            this.lblDateInvestigated.Size = new System.Drawing.Size(208, 20);
            this.lblDateInvestigated.TabIndex = 2;
            this.lblDateInvestigated.Text = "Date Transfusion Reaction Investigated";
            this.lblDateInvestigated.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // btnInvalidateTRW
            // 
            this.btnInvalidateTRW.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.btnInvalidateTRW.EnabledButton = false;
            this.btnInvalidateTRW.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnInvalidateTRW.Image = ((System.Drawing.Image)(resources.GetObject("btnInvalidateTRW.Image")));
            this.btnInvalidateTRW.Location = new System.Drawing.Point(292, 498);
            this.btnInvalidateTRW.Name = "btnInvalidateTRW";
            this.btnInvalidateTRW.Size = new System.Drawing.Size(152, 23);
            this.btnInvalidateTRW.TabIndex = 3;
            this.btnInvalidateTRW.Click += new System.EventHandler(this.InvalidateTRW);
            // 
            // btnFinalizePrint
            // 
            this.btnFinalizePrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
            this.btnFinalizePrint.EnabledButton = false;
            this.btnFinalizePrint.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnFinalizePrint.Image = ((System.Drawing.Image)(resources.GetObject("btnFinalizePrint.Image")));
            this.btnFinalizePrint.Location = new System.Drawing.Point(136, 498);
            this.btnFinalizePrint.Name = "btnFinalizePrint";
            this.btnFinalizePrint.Size = new System.Drawing.Size(152, 23);
            this.btnFinalizePrint.TabIndex = 2;
            this.btnFinalizePrint.Click += new System.EventHandler(this.btnFinalizePrint_Click);
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 32);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(710, 40);
            this.patientDisplayPanel1.TabIndex = 9;
            // 
            // FrmTransfusionReactionWorkup
            // 
            this.AcceptButton = this.btnSpecimenOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(716, 530);
            this.Controls.Add(this.patientDisplayPanel1);
            this.Controls.Add(this.btnFinalizePrint);
            this.Controls.Add(this.btnInvalidateTRW);
            this.Controls.Add(this.grpTRWDates);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.tabTRW);
            this.hlphelpChm.SetHelpKeyword(this, "Record_a_Transfusion_Reaction_Workup.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(724, 557);
            this.Name = "FrmTransfusionReactionWorkup";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Transfusion Reaction Workup";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmTransfusionReactionWorkup_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.tabTRW, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.grpTRWDates, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.btnInvalidateTRW, 0);
            this.Controls.SetChildIndex(this.btnFinalizePrint, 0);
            this.Controls.SetChildIndex(this.patientDisplayPanel1, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.tabTRW.ResumeLayout(false);
            this.pageSpecimenChecks.ResumeLayout(false);
            this.pnlSpecimenChecks.ResumeLayout(false);
            this.grpPostTransfusionSpecimen.ResumeLayout(false);
            this.grpPreTransfusionSpecimen.ResumeLayout(false);
            this.grpPostTransfusionAvailable.ResumeLayout(false);
            this.grpPostTransfusionAvailable.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picPostScanner)).EndInit();
            this.grpPostClericalCheck.ResumeLayout(false);
            this.pnlPostSpecimenComments.ResumeLayout(false);
            this.pnlPostSpecimenComments.PerformLayout();
            this.grpPostTransfusionNotAvailable.ResumeLayout(false);
            this.grpPostTransfusionNotAvailable.PerformLayout();
            this.grpPreTransfusionAvailable.ResumeLayout(false);
            this.grpPreTransfusionAvailable.PerformLayout();
            this.pnlPreSpecimenComments.ResumeLayout(false);
            this.pnlPreSpecimenComments.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picPreScanner)).EndInit();
            this.grpPreClericalCheck.ResumeLayout(false);
            this.grpPreTransfusionNotAvailable.ResumeLayout(false);
            this.grpPreTransfusionNotAvailable.PerformLayout();
            this.pageSymptoms.ResumeLayout(false);
            this.pnlSymptoms.ResumeLayout(false);
            this.grpSymptoms.ResumeLayout(false);
            this.grpSymptoms.PerformLayout();
            this.grpSymptomsIdentified.ResumeLayout(false);
            this.pageImplicatedUnits.ResumeLayout(false);
            this.pnlImplicatedUnits.ResumeLayout(false);
            this.grpImplicatedUnitsIdentified.ResumeLayout(false);
            this.grpIdentifyUnits.ResumeLayout(false);
            this.grpBloodBagReturned.ResumeLayout(false);
            this.grpImplicatedUnit.ResumeLayout(false);
            this.grpImplicatedUnit.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this.picUnitIDScanner)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.picProductScanner)).EndInit();
            this.grpBloodBagChecks.ResumeLayout(false);
            this.grpBloodBagClericalChecks.ResumeLayout(false);
            this.grpBagComment.ResumeLayout(false);
            this.grpBagComment.PerformLayout();
            this.grpBagNotReturned.ResumeLayout(false);
            this.grpBagNotReturned.PerformLayout();
            this.grpImplicatedUnits.ResumeLayout(false);
            this.pageSerolgicTests.ResumeLayout(false);
            this.pnlSerologicTests.ResumeLayout(false);
            this.pnlSerologicTests.PerformLayout();
            this.grpXM.ResumeLayout(false);
            this.pnlXM.ResumeLayout(false);
            this.pnlXMRight.ResumeLayout(false);
            this.pnlPostXM.ResumeLayout(false);
            this.pnlXMMiddle.ResumeLayout(false);
            this.pnlPreXM.ResumeLayout(false);
            this.pnlXMLabels.ResumeLayout(false);
            this.grpABORh.ResumeLayout(false);
            this.pnlABORh.ResumeLayout(false);
            this.pnlABO.ResumeLayout(false);
            this.pnlRh.ResumeLayout(false);
            this.grpAutomatedInstrument.ResumeLayout(false);
            this.grpAutomatedInstrument.PerformLayout();
            this.grpABS.ResumeLayout(false);
            this.pnlABS.ResumeLayout(false);
            this.grpDAT.ResumeLayout(false);
            this.pnlDAT.ResumeLayout(false);
            this.grpTRWDates.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		#region Variables
			
		private PatientTransfusionReaction _patientTransfusionReaction;
		private Specimen _postSpecimen;
		private Specimen _preSpecimen;
		private OrderedTest _orderedTest;
		private Guid _orderedTestSpecimenGuid;

		private ArrayList _hemolysisInspections;
		private DataTable _preSpecimenNotAvailableComments;
		private DataTable _postSpecimenNotAvailableComments;
		private DataTable _clericalCheckComments;
		private DataTable _bagNotReturnedComments;
		private DataTable _testingComments;
		private ArrayList _patientSymptoms;
		private int _otherSymptomIndex;
		private bool _isSymptomCommentRequired;
		private ArrayList _aboInterps;
		private ArrayList _rhInterps;
		private ArrayList _datInterps;
		private ArrayList _xmInterps;
		private ArrayList _absInterps;
		private ArrayList _patientTransfusions;
		private BOL.PatientTransfusion _patientTransfusion;
		private ArrayList _implicatedTransfusionRecords;
		private ArrayList _transfusionReactions;
		private BOL.TransfusionReaction _transfusionReaction;
		private BOL.PatientTransfusionComment _implicatedUnitBagNotReturnedComment;
		private BOL.PatientTransfusionComment _implicatedUnitClericalCheckComment;
		private ArrayList _patientTransfusionReactionComments;
		private ArrayList _implicatedUnitComments;
		private DataTable _rackNotTestedExceptions;
		//
		private BOL.SpecimenTest _preSpecimenAbsTest;
		private BOL.SpecimenTest _postSpecimenAbsTest;
		private BOL.SpecimenTest _preSpecimenDatTest;
		private BOL.SpecimenTest _postSpecimenDatTest;
		private BOL.SpecimenTest _preSpecimenAboTest;
		private BOL.SpecimenTest _postSpecimenAboTest;
		private BOL.SpecimenTest _preSpecimenRhTest;
		private BOL.SpecimenTest _postSpecimenRhTest;
		private ArrayList _unitAboTests;
		private ArrayList _unitRhTests;
		private ArrayList _preSpecimenXMTests;
		private ArrayList _postSpecimenXMTests;
		//
		private Regex _isbtUnitID;
		private Regex _isbtProductCode;
		private Regex _codabarUnitID;
		private Regex _codabarProductCode;
		//
		private DataTable _racks;
		private ArrayList _alWorkloadProcessIds;


		#endregion


		#region Methods

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC021.FrmTransfusionReactionWorkup());
			//
			this.btnSpecimenOK.Text = "&OK";
			this.btnSpecimenOK.EnabledButton = false;
			//
			this.btnInvalidateTRW.Text = "&Invalidate TRW";
			this.btnInvalidateTRW.EnabledButton = false;
			//
			this.btnFinalizePrint.Text = "&Finalize/Print TRW";
			this.btnFinalizePrint.EnabledButton = false;
			//
			this.btnAddUnit.Text = "&Add";
			this.btnAddUnit.EnabledButton = false;
			//
			this.btnUnitsOK.Text = "&OK";
			this.btnUnitsOK.EnabledButton = false;
			//
			this.btnSymptomsOK.Text = "&OK";
			this.btnSymptomsOK.EnabledButton = false;
			//
			this.btnTestsOK.Text = "&OK";
			this.btnTestsOK.EnabledButton = true;
			//
			//set custom date and time format
			this.dtpDateInvestigated.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpDateNoted.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			this.dtpDateTested.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			//
			//set current date value based on the division time zone
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpDateInvestigated.MaxDate = currentDate;
			this.dtpDateInvestigated.Value = currentDate;
			this.dtpDateNoted.MaxDate = currentDate;
			this.dtpDateNoted.Value = currentDate;
			this.dtpDateTested.MaxDate = currentDate;
			this.dtpDateTested.Value = currentDate;
			//
			using (new WaitCursor())
			{
				this.LoadHemolysisInspection();
				this.LoadSpecimenNotAvailableComments();
				this.LoadClericalCheckComments();
				this.LoadBagNotReturnedComments();
				this.LoadPatientSymptoms();
				this.LoadPatientDetails();
				this.LoadRacks();
				this.LoadUsers();
				this.LoadTestingComments();
				//this.LoadInterps();
			}
			//
			this.tabTRW.TabPages.Clear();
			//
			this.IsDirty = false;
			_alWorkloadProcessIds = new ArrayList();
			_alWorkloadProcessIds.Add(Common.WorkloadProcessID.TransfusionReactionInvestigation);
		}

		private void ReturnToInitialState()
		{
			this.ClearImplicatedUnit();
			this.tabTRW.TabPages.Clear();
			this.errError.SetVbecsError(this.txtPreSpecimenUID, ""); // **** 508 Compliance ***
			this.errError.SetVbecsError(this.txtPostSpecimenUID, ""); // **** 508 Compliance ***
			//
			LoadInitialObjects();
            if (this.LockController.LockingConflict) return;    //this is set if the lock fails, so need to get out
			//
			SetComponentProperties();
			PopulateSpecimenChecksTab();
			PopulateImplicatedUnitsTab();
			PopulateSymptomsTab();
			PopulateSerologicTestsTab();
		}

		private void LoadInitialObjects()
		{
			using (new WaitCursor())
			{
				this._orderedTest = new BOL.OrderedTest(this._orderedTest.OrderedTestGuid, this._orderedTest.PatientOrderGuid);
				this._patientTransfusionReaction = new BOL.PatientTransfusionReaction(this._orderedTest.OrderedTestGuid);
				//
				this._patientTransfusionReaction.SetInitialBrokenRules(this.Name, "TrwHemolysis");
				this._patientTransfusionReaction.Valid += new System.EventHandler(this.CheckSpecimensValid);
				this._patientTransfusionReaction.Invalid += new System.EventHandler(this.CheckSpecimensValid);
				this._patientTransfusionReaction.IsDirtyChanged += new System.EventHandler(this.CheckSpecimensValid);
				//
				if (this._patientTransfusionReaction.IsNew)
				{
					this._patientTransfusionReaction.PatientGuid = this._orderedTest.PatientGuid;
					this._patientTransfusionReaction.EntryDateTime = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
					this._patientTransfusionReaction.EntryTechId = Common.LogonUser.LogonUserName;
				}
				this._preSpecimen = new BOL.Specimen(this._patientTransfusionReaction.PreSpecimenGuid);
				this._postSpecimen = new BOL.Specimen(this._patientTransfusionReaction.PostSpecimenGuid);
				
				if (!this.SetLocks(this._orderedTest.OrderedTestGuid, this._patientTransfusionReaction.PatientTransfusionReactionGuid,
					this._patientTransfusionReaction.PreSpecimenGuid, this._patientTransfusionReaction.PostSpecimenGuid))
				{
					this.DialogResult = DialogResult.Abort;
					this.Close();
					return;
				}

				this._patientTransfusions = BOL.PatientTransfusion.GetPatientTransfusionRecords(this._patientTransfusionReaction.PatientGuid);
				this._implicatedTransfusionRecords = this._patientTransfusionReaction.GetImplicatedTransfusionRecords();
				this._transfusionReactions = this._patientTransfusionReaction.GetTransfusionReactionRecords();
				this._patientTransfusionReactionComments = BOL.PatientTransfusionComment.GetComments(Guid.Empty,this._patientTransfusionReaction.PatientTransfusionReactionGuid);
				//
				this.SetPreSpecimenBrokenRules();
				this.SetPostSpecimenBrokenRules();
			}
		}

		private bool IsCommentComplete(controls.ComboBoxLookup cmb, TextBox txt)
		{
			//
			if (cmb.SelectedIndex<0)
			{
				return false;
			}
			//
			if ((cmb.Text.ToUpper() == "OTHER") && (txt.Text.Trim().Length == 0))
			{
				return false;
			}
			//
			return true;
		}

		private void LoadHemolysisInspection()
		{
			this.cmbPreHemolysis.Items.Clear();
			this.cmbPostHemolysis.Items.Clear();
			this.cmbUnitHemolysis.Items.Clear();
			//
			_hemolysisInspections = BOL.PatientTransfusionReaction.GetHemolysisInspectionList();
			//
			foreach(ArrayList dr in _hemolysisInspections)
			{
				this.cmbPreHemolysis.Items.Add(dr[1].ToString());
				this.cmbPostHemolysis.Items.Add(dr[1].ToString());
				this.cmbUnitHemolysis.Items.Add(dr[1].ToString());
			}
		}

		private void LoadSpecimenNotAvailableComments()
		{
			this.cmbPreComment.Items.Clear();
			this.cmbPostComment.Items.Clear();
			//
			_preSpecimenNotAvailableComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"T1");
			_postSpecimenNotAvailableComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"T2");
			//
			foreach(DataRow dr in _preSpecimenNotAvailableComments.Rows)
			{
				this.cmbPreComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
			foreach(DataRow dr in _postSpecimenNotAvailableComments.Rows)
			{
				this.cmbPostComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}


		private void LoadClericalCheckComments()
		{
			this.cmbPreSpecimenComments.Items.Clear();
			this.cmbPostSpecimenComments.Items.Clear();
			this.cmbBagComment.Items.Clear();
			//
			_clericalCheckComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"TC");
			//
			foreach(DataRow dr in _clericalCheckComments.Rows)
			{
				this.cmbPreSpecimenComments.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
				this.cmbPostSpecimenComments.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
				this.cmbBagComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}

		private void LoadBagNotReturnedComments()
		{
			this.cmbBagNotReturnedComment.Items.Clear();
			//
			_bagNotReturnedComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"TB");
			//
			foreach(DataRow dr in _bagNotReturnedComments.Rows)
			{
				this.cmbBagNotReturnedComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}

		private void LoadTestingComments()
		{
			this.cmbTestComment.Items.Clear();
			//
			_testingComments = BOL.CannedComment.GetCannedComments(Common.LogonUser.LogonUserDivisionCode,"PT");
			//
			foreach(DataRow dr in _testingComments.Rows)
			{
				this.cmbTestComment.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString());
			}
		}

		private void LoadPatientSymptoms()
		{
			int nCount = 0;
			this.clbSymptoms.Items.Clear();
			//
			_patientSymptoms = BOL.PatientTransfusionReaction.GetPatientSymptomList();
			//
			nCount = this._patientSymptoms.Count;
			for(int i = 0; i < nCount; i++)
			{
				ArrayList symptom = (ArrayList)this._patientSymptoms[i];
				this.clbSymptoms.Items.Add(symptom[1].ToString());
				//
				if (symptom[1].ToString().Trim().ToUpper().StartsWith("OTHER"))
				{
					this._otherSymptomIndex = i;
				}
			}
		}

		private void LoadPatientDetails()
		{
			this.patientDisplayPanel1.Patient = this._orderedTest.Patient;
		}

		private void LoadInterps()
		{
			DataTable testResults = BOL.ReferenceData.GetTestResultList();
			//
			_absInterps = new ArrayList(3);
			//
			_datInterps = new ArrayList(3);
			//
			_aboInterps = new ArrayList(6);
			//
			_rhInterps = new ArrayList(4);
			//
			_xmInterps = new ArrayList(5);
			//
			foreach(DataRow dr in testResults.Rows)
			{
				BOL.TestResult testResult = new BOL.TestResult(dr);
				//
				switch (testResult.TestResultId.Trim())
				{
					case "A":
						_aboInterps.Add(testResult);
						break;
					case "AB":
						_aboInterps.Add(testResult);
						break;
					case "B":
						_aboInterps.Add(testResult);
						break;
					case "C":
						_xmInterps.Add(testResult);
						break;
					case "D":
						_xmInterps.Add(testResult);
						break;
					case "G":
						_xmInterps.Add(testResult);
						break;
					case "I":
						_rhInterps.Add(testResult);
						break;
					case "J":
						_xmInterps.Add(testResult);
						break;
					case "N":
						_rhInterps.Insert(0,testResult);
						_absInterps.Insert(0,testResult);
						_datInterps.Insert(0,testResult);
						break;
					case "O":
						_aboInterps.Add(testResult);
						break;
					case "P":
						_rhInterps.Insert(0,testResult);
						_absInterps.Insert(0,testResult);
						_datInterps.Insert(0,testResult);
						break;
					case "X":
						_aboInterps.Add(testResult);
						_rhInterps.Add(testResult);
						_absInterps.Add(testResult);
						_datInterps.Add(testResult);
						_xmInterps.Add(testResult);
						break;
					default:
						break;
				}
			}
			//
			AddInterps(this.pnlABO, this._aboInterps);
			AddInterps(this.pnlRh, this._rhInterps);
			AddInterps(this.pnlABS, this._absInterps);
			AddInterps(this.pnlDAT, this._datInterps);
			AddInterps(this.pnlPreXM, this._xmInterps);
			AddInterps(this.pnlPostXM, this._xmInterps);
		}

		private void LoadRacks()
		{
			this.cmbRack.Items.Clear();
			//
			this._racks = BOL.Rack.GetDailyQCRacks(BOL.VBECSDateTime.GetDivisionCurrentDateTime());
			//
			foreach(DataRow dr in this._racks.Rows)
			{
				this.cmbRack.Items.Add(dr[Common.VbecsTables.Rack.RackName].ToString().Trim());
			}
		}

		private void LoadUsers()
		{
			cmbTestedBy.Items.Clear();
			cmbTestedBy.DisplayMember = "UserName";

			ArrayList _users = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode );			

			foreach( BOL.VbecsUser _user in _users )
			{
				cmbTestedBy.Items.Add( _user );

				if( _user.UserNTLoginID == ThisUser.UserNTLoginID )
					cmbTestedBy.SelectedItem = _user;
			}					
		}

		private void AddInterps(Panel controlPanel, ArrayList interps)
		{
			foreach(Control ctrl in controlPanel.Controls)
			{
				if (ctrl.GetType() == typeof(gov.va.med.vbecs.GUI.controls.ComboBoxLookup))
				{
					((ComboBox)ctrl).Items.Clear();
					foreach(BOL.TestResult result in interps)
					{
						((ComboBox)ctrl).Items.Add(result.TestResultText);
					}
				}
			}
		}

		private BOL.PatientTransfusionComment GetTransfusionComment(string context, Guid cannedCommentGuid, string details)
		{
			BOL.PatientTransfusionComment comment = new BOL.PatientTransfusionComment();
			comment.CommentCategoryCode = context;
			comment.PatientTransfusionReactionGuid = this._patientTransfusionReaction.PatientTransfusionReactionGuid;
			if (details.Length>0)
			{
				comment.PatientTransfusionCommentText = details;
			}
			if (cannedCommentGuid != Guid.Empty)
			{
				comment.CannedCommentGuid = cannedCommentGuid;
			}
			comment.RecordStatusCode = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active).ToString();
			return comment;

		}

		private void AddTabPage(TabPage tabPage)
		{
			if (this.tabTRW.TabPages.IndexOf(tabPage)<0)
			{
				this.tabTRW.TabPages.Add(tabPage);
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void GetTransfusionReactionRecord(BOL.PatientTransfusion transfusion)
		{
			foreach(BOL.TransfusionReaction reaction in this._transfusionReactions)
			{
				if (reaction.PatientTransfusionGuid == transfusion.PatientTransfusionGuid)
				{
					this._transfusionReaction = reaction;
					return;
				}
			}
			//
			this._transfusionReaction = new BOL.TransfusionReaction();
			this._transfusionReaction.PatientTransfusionGuid = transfusion.PatientTransfusionGuid;
			this._transfusionReaction.PatientTransfusionReactionGuid = this._patientTransfusionReaction.PatientTransfusionReactionGuid;
			this._transfusionReaction.TagNotScannedIndicator = (!this.txtUnitID.Barcode);
		}


		private string GetHemolysis(string hemolysisCode)
		{
			foreach(ArrayList hemolysis in this._hemolysisInspections)
			{
				if (hemolysis[0].ToString() == hemolysisCode)
				{
					return hemolysis[1].ToString();
				}
			}
			return "";
		}

		private int GetHemolysisIndex(string hemolysisCode)
		{
			for(int i = 0; i < this._hemolysisInspections.Count; i++)
			{
				ArrayList hemolysis = (ArrayList)this._hemolysisInspections[i];
				//
				if (hemolysis[0].ToString() == hemolysisCode)
				{
					return i;
				}
			}
			return -1;
		}

		private void InvalidateTRW(object sender, System.EventArgs e)
		{
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.InvalidateTestResults()) != DialogResult.Yes)
			{
				return;
			}
			//
			this._patientTransfusionReaction.Invalidate(this._orderedTest);
			//
			this.ReturnToInitialState();
			//
		}

		#endregion

		#region Specimen Check Methods
	
		private void EnableSpecimenCheckControls(bool enable)
		{
			this.dtpDateInvestigated.Enabled = enable;
			this.dtpDateNoted.Enabled = enable;
			//
			this.rdoPreTransfusionAvailable.Enabled = enable;
			this.rdoPreTransfusionNotAvailable.Enabled = enable;
			this.txtPreSpecimenUID.ReadOnly = !enable;
			this.cmbPreHemolysis.Enabled = enable;
			this.rdoPreClericalCheckOK.Enabled = enable;
			this.rdoPreClericalCheckFail.Enabled = enable;
			this.cmbPreSpecimenComments.Enabled = enable;
			this.txtPreSpecimenComments.ReadOnly = !enable;
			this.cmbPreComment.Enabled = enable;
			this.txtPreDetails.ReadOnly = !enable;
			//
			this.rdoPostTransfusionAvailable.Enabled = enable;
			this.rdoPostTransfusionNotAvailable.Enabled = enable;
			this.txtPostSpecimenUID.ReadOnly = !enable;
			this.cmbPostHemolysis.Enabled = enable;
			this.rdoPostClericalCheckOK.Enabled = enable;
			this.rdoPostClericalCheckFail.Enabled = enable;
			this.cmbPostSpecimenComments.Enabled = enable;
			this.txtPostSpecimenComments.ReadOnly = !enable;
			this.cmbPostComment.Enabled = enable;
			this.txtPostDetails.ReadOnly = !enable;
			//
			this.btnSymptomsOK.Enabled = enable;
			//
			this.btnSpecimenOK.EnabledButton = false;
		}

		private void ResetSpecimenChecks()
		{
			this.rdoPreTransfusionAvailable.Checked = false;
			this.rdoPreTransfusionNotAvailable.Checked = false;
			//
			this.txtPreSpecimenUID.Text = "";
			this.cmbPreHemolysis.Text = "";
			this.cmbPreHemolysis.SelectedIndex = -1;
			//
			this.rdoPreClericalCheckFail.Checked = false;
			this.rdoPreClericalCheckOK.Checked = false;
			//
			this.cmbPreComment.Text = "";
			this.cmbPreComment.SelectedIndex = -1;
			this.txtPreDetails.Text = "";
			//
			this.cmbPreSpecimenComments.Text = "";
			this.cmbPreSpecimenComments.SelectedIndex = -1;
			this.txtPreSpecimenComments.Text = "";
			//
			this.rdoPostTransfusionAvailable.Checked = false;
			this.rdoPostTransfusionNotAvailable.Checked = false;
			//
			this.txtPostSpecimenUID.Text = "";
			this.cmbPostHemolysis.Text = "";
			this.cmbPostHemolysis.SelectedIndex = -1;
			//
			this.rdoPostClericalCheckFail.Checked = false;
			this.rdoPostClericalCheckOK.Checked = false;
			//
			this.cmbPostComment.Text = "";
			this.cmbPostComment.SelectedIndex = -1;
			this.txtPostDetails.Text = "";
			//
			this.cmbPostSpecimenComments.Text = "";
			this.cmbPostSpecimenComments.SelectedIndex = -1;
			this.txtPostSpecimenComments.Text = "";
		}

		private void SetPreSpecimenBrokenRules()
		{
			if (this._preSpecimen != null)
			{
				this._preSpecimen.SetInitialBrokenRules(this.Name, "PreSpecimenTrwAvailable");
				this._preSpecimen.Valid += new System.EventHandler(this.CheckSpecimensValid);
				this._preSpecimen.Invalid += new System.EventHandler(this.CheckSpecimensValid);
				this._preSpecimen.IsDirtyChanged += new System.EventHandler(this.CheckSpecimensValid);
				//
				CheckSpecimensValid(this, System.EventArgs.Empty);
			}
		}

		private void SetPostSpecimenBrokenRules()
		{
			if (this._postSpecimen != null)
			{
				this._postSpecimen.SetInitialBrokenRules(this.Name, "PostSpecimenTrwAvailable");
				this._postSpecimen.Valid += new System.EventHandler(this.CheckSpecimensValid);
				this._postSpecimen.Invalid += new System.EventHandler(this.CheckSpecimensValid);
				this._postSpecimen.IsDirtyChanged += new System.EventHandler(this.CheckSpecimensValid);
				//
				CheckSpecimensValid(this, System.EventArgs.Empty);
			}
		}

		private void CheckSpecimensValid(object sender, System.EventArgs e)
		{
			//Only checked if not already saved
			if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete)
			{
				this.btnSpecimenOK.EnabledButton = false;
				return;
			}
			//
			bool preValid = true;
			bool postValid = true;
			if (this.rdoPreTransfusionAvailable.Checked)
			{
				if ((!this._preSpecimen.IsValid) || (!this._patientTransfusionReaction.IsValid) || ((!this.rdoPreClericalCheckOK.Checked) && (!this.rdoPreClericalCheckFail.Checked)))
				{
					preValid = false;
				}
				//
				if (this.rdoPreClericalCheckFail.Checked)
				{
					if (!this.IsCommentComplete(this.cmbPreSpecimenComments,this.txtPreSpecimenComments))
					{
						preValid = false;
					}
				}
			}
			else if (this.rdoPreTransfusionNotAvailable.Checked)
			{
				if (!this.IsCommentComplete(this.cmbPreComment,this.txtPreDetails))
				{
					preValid = false;
				}
			}
			else
			{
				preValid = false;
			}
			//
			if (this.rdoPostTransfusionAvailable.Checked)
			{
				if ((!this._postSpecimen.IsValid) || (!this._patientTransfusionReaction.IsValid) || ((!this.rdoPostClericalCheckOK.Checked) && (!this.rdoPostClericalCheckFail.Checked)))
				{
					postValid = false;
				}
				//
				if (this.rdoPostClericalCheckFail.Checked)
				{
					if (!this.IsCommentComplete(this.cmbPostSpecimenComments,this.txtPostSpecimenComments))
					{
						postValid = false;
					}
				}
			}
			else if (this.rdoPostTransfusionNotAvailable.Checked)
			{
				if (!this.IsCommentComplete(this.cmbPostComment,this.txtPostDetails))
				{
					postValid = false;
				}
			}
			else
			{
				postValid = false;
			}
			//
			this.btnSpecimenOK.EnabledButton = (preValid && postValid);
		}

		private void PopulateSpecimenChecksTab()
		{
			if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete)
			{
				this.AddTabPage(this.pageSpecimenChecks);
				//
				this._preSpecimen = new BOL.Specimen(this._patientTransfusionReaction.PreSpecimenGuid);
				this._postSpecimen = new BOL.Specimen(this._patientTransfusionReaction.PostSpecimenGuid);
				//
				LoadSavedSpecimens();
				//
				this.EnableSpecimenCheckControls(false);
			}
			else
			{
				this.AddTabPage(this.pageSpecimenChecks);
				//
				this.EnableSpecimenCheckControls(true);
				this.ResetSpecimenChecks();
			}
			//
			this.lblCompleteMessage1.Visible = ((int)this._patientTransfusionReaction.PartialSaveId == (int)Common.PatientTransfusionPartialSaveId.SerologicTestsComplete);
		}

		private void LoadSavedSpecimens()
		{
			if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator)
			{
				this.rdoPreTransfusionNotAvailable.Checked = true;
				//
				if (this._patientTransfusionReactionComments != null)
				{
					foreach(BOL.PatientTransfusionComment comment in this._patientTransfusionReactionComments)
					{
						if (comment.CommentCategoryCode == "T1")
						{
							if (comment.CannedCommentGuid != Guid.Empty)
							{
								foreach(DataRow dr in this._preSpecimenNotAvailableComments.Rows)
								{
									if ((Guid)dr[Common.VbecsTables.CannedComment.CannedCommentGuid] == comment.CannedCommentGuid)
									{
										this.cmbPreComment.Text = dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString();
										break;
									}
								}
							}
							this.txtPreDetails.Text = comment.PatientTransfusionCommentText;
							break;
						}
					}
				}
			}
			else
			{
				if (this._preSpecimen != null)
				{
					this.rdoPreTransfusionAvailable.Checked = true;
					this.txtPreSpecimenUID.Text = this._preSpecimen.SpecimenUid;
					this.cmbPreHemolysis.SelectedIndex = this.GetHemolysisIndex(this._patientTransfusionReaction.PreSpecimenHemolysisInspectionCode);
					this.rdoPreClericalCheckOK.Checked = this._patientTransfusionReaction.PreSpecimenClericalChecksOKIndicator;
					//
					if (this._patientTransfusionReactionComments != null)
					{
						foreach(BOL.PatientTransfusionComment comment in this._patientTransfusionReactionComments)
						{
							if ((comment.CommentCategoryCode == "TC") && (comment.PatientTransfusionGuid == Guid.Empty) && (comment.PreTransfusionIndicator))
							{
								if (comment.CannedCommentGuid != Guid.Empty)
								{
									foreach(DataRow dr in this._clericalCheckComments.Rows)
									{
										if ((Guid)dr[Common.VbecsTables.CannedComment.CannedCommentGuid] == comment.CannedCommentGuid)
										{
											this.cmbPreSpecimenComments.Text = dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString();
											break;
										}
									}
								}
								this.txtPreSpecimenComments.Text = comment.PatientTransfusionCommentText;
								break;
							}
						}
					}
				}
			}
			//
			if (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
			{
				this.rdoPostTransfusionNotAvailable.Checked = true;
				//
				if (this._patientTransfusionReactionComments != null)
				{
					foreach(BOL.PatientTransfusionComment comment in this._patientTransfusionReactionComments)
					{
						if (comment.CommentCategoryCode == "T2")
						{
							if (comment.CannedCommentGuid != Guid.Empty)
							{
								foreach(DataRow dr in this._postSpecimenNotAvailableComments.Rows)
								{
									if ((Guid)dr[Common.VbecsTables.CannedComment.CannedCommentGuid] == comment.CannedCommentGuid)
									{
										this.cmbPostComment.Text = dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString();
										break;
									}
								}
							}
							this.txtPostDetails.Text = comment.PatientTransfusionCommentText;
							break;
						}
					}
				}
			}
			else
			{
				if (this._postSpecimen != null)
				{
					this.rdoPostTransfusionAvailable.Checked = true;
					this.txtPostSpecimenUID.Text = this._postSpecimen.SpecimenUid;
					this.cmbPostHemolysis.SelectedIndex = this.GetHemolysisIndex(this._patientTransfusionReaction.PostSpecimenHemolysisInspectionCode);
					this.rdoPostClericalCheckOK.Checked = this._patientTransfusionReaction.PostSpecimenClericalChecksOKIndicator;
					//
					if (this._patientTransfusionReactionComments != null)
					{
						foreach(BOL.PatientTransfusionComment comment in this._patientTransfusionReactionComments)
						{
							if ((comment.CommentCategoryCode == "TC") && (comment.PatientTransfusionGuid == Guid.Empty) && (!comment.PreTransfusionIndicator))
							{
								if (comment.CannedCommentGuid != Guid.Empty)
								{
									foreach(DataRow dr in this._clericalCheckComments.Rows)
									{
										if ((Guid)dr[Common.VbecsTables.CannedComment.CannedCommentGuid] == comment.CannedCommentGuid)
										{
											this.cmbPostSpecimenComments.Text = dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString();
											break;
										}
									}
								}
								this.txtPostSpecimenComments.Text = comment.PatientTransfusionCommentText;
								break;
							}
						}
					}
				}
			}
		}

		private void PreTransfusionAvailableChecked(object sender, System.EventArgs e)
		{
			if (this.rdoPreTransfusionAvailable.Checked)
			{
				this.grpPreTransfusionAvailable.Visible = true;
				this.grpPreTransfusionNotAvailable.Visible = false;
				this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator = false;
				this.IsDirty = true;
			}
			else if (this.rdoPreTransfusionNotAvailable.Checked)
			{
				this.grpPreTransfusionAvailable.Visible = false;
				this.grpPreTransfusionNotAvailable.Visible = true;
				this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator = true;
				this.IsDirty = true;
			}
			else
			{
				this.grpPreTransfusionAvailable.Visible = false;
				this.grpPreTransfusionNotAvailable.Visible = false;
			}
			//
			this.CheckSpecimensValid(sender, e);
		}

		private void PostTransfusionAvailableChecked(object sender, System.EventArgs e)
		{
			if (this.rdoPostTransfusionAvailable.Checked)
			{
				this.grpPostTransfusionAvailable.Visible = true;
				this.grpPostTransfusionNotAvailable.Visible = false;
				this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator = false;
				this.IsDirty = true;
			}
			else if (this.rdoPostTransfusionNotAvailable.Checked)
			{
				this.grpPostTransfusionAvailable.Visible = false;
				this.grpPostTransfusionNotAvailable.Visible = true;
				this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator = true;
				this.IsDirty = true;
			}
			else
			{
				this.grpPostTransfusionAvailable.Visible = false;
				this.grpPostTransfusionNotAvailable.Visible = false;
			}
			//
			this.CheckSpecimensValid(sender, e);
		}

		private void DateNotedChanged(object sender, System.EventArgs e)
		{
			this._patientTransfusionReaction.NotedDateTime = this.dtpDateNoted.Value;
		}

		private void DateInvestigatedChanged(object sender, System.EventArgs e)
		{
			this._patientTransfusionReaction.InvestigatedDateTime = this.dtpDateInvestigated.Value;
		}

		private void PreSpecimenClericalChecked(object sender, System.EventArgs e)
		{
			this._patientTransfusionReaction.PreSpecimenClericalChecksOKIndicator = this.rdoPreClericalCheckOK.Checked;
			//
			if (this.rdoPreClericalCheckFail.Checked)
			{
				this.lblPreSpecimenComments.Text = "Comment*";
			}
			else
			{
				this.lblPreSpecimenComments.Text = "Comment";
			}
			//
			this.CheckSpecimensValid(sender, e);
		}

		private void PostSpecimenClericalChecked(object sender, System.EventArgs e)
		{
			this._patientTransfusionReaction.PostSpecimenClericalChecksOKIndicator = this.rdoPostClericalCheckOK.Checked;
			//
			if (this.rdoPostClericalCheckFail.Checked)
			{
				this.lblPostSpecimenComments.Text = "Comment*";
			}
			else
			{
				this.lblPostSpecimenComments.Text = "Comment";
			}
			//
			this.CheckSpecimensValid(sender, e);
		}

		private void PreSpecimenUidChanged(object sender, System.EventArgs e)
		{
			//Only checked if not already saved
			if ((int)this._patientTransfusionReaction.PartialSaveId < (int)Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete)
			{
				Regex uid = Common.RegularExpressions.SpecimenUid();
				if (uid.IsMatch(this.txtPreSpecimenUID.Text))
				{
					if (this.txtPreSpecimenUID.Text == this.txtPostSpecimenUID.Text)
					{
						Utility.MessageBeep();
						this.errError.SetVbecsError(this.txtPreSpecimenUID, Common.StrRes.InfoMsg.UC021.PreAndPostSpecimen().ResString); // **** 508 Compliance ***
						this._preSpecimen.SpecimenUid = "";
					}
					else
					{
						this._preSpecimen = new BOL.Specimen(this.txtPreSpecimenUID.Text);
						this.SetPreSpecimenBrokenRules();
						//
						if (this._preSpecimen.IsNew)
						{
							Utility.MessageBeep();
							this.errError.SetVbecsError(this.txtPreSpecimenUID, "Specimen not found"); // **** 508 Compliance ***
							this._preSpecimen.SpecimenUid = "";
						}
						else 
						{
							if (this._preSpecimen.Patient.PatientGuid != this._patientTransfusionReaction.PatientGuid)
							{
								Utility.MessageBeep();
								this.errError.SetVbecsError(this.txtPreSpecimenUID, "Pre-specimen patient name does not match VBECS records."); // **** 508 Compliance ***
							}
							else
							{
								this.errError.SetVbecsError(this.txtPreSpecimenUID, ""); // **** 508 Compliance ***
							}
					
							//
							this._patientTransfusionReaction.PreSpecimenGuid = this._preSpecimen.SpecimenGuid;
						}
					}
				}
				else
				{
					this._preSpecimen.SpecimenUid = "";
				}
				//Reset broken rules
				this._preSpecimen.SpecimenUid = this._preSpecimen.SpecimenUid;
			}
		}

		private void PreSpecimenHemolysisChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPreHemolysis.SelectedIndex > -1)
			{
				this._patientTransfusionReaction.PreSpecimenHemolysisInspectionCode = ((ArrayList)this._hemolysisInspections[this.cmbPreHemolysis.SelectedIndex])[0].ToString();
			}
			else
			{
				this._patientTransfusionReaction.PreSpecimenHemolysisInspectionCode = null;
			}
		}

		private void PostSpecimenUidChanged(object sender, System.EventArgs e)
		{
			//Only checked if not already saved
			if ((int)this._patientTransfusionReaction.PartialSaveId < (int)Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete)
			{
				Regex uid = Common.RegularExpressions.SpecimenUid();
				if (uid.IsMatch(this.txtPostSpecimenUID.Text))
				{
					if (this.txtPreSpecimenUID.Text == this.txtPostSpecimenUID.Text)
					{
						Utility.MessageBeep();
						this.errError.SetVbecsError(this.txtPostSpecimenUID, Common.StrRes.InfoMsg.UC021.PreAndPostSpecimen().ResString); // **** 508 Compliance ***
						this._postSpecimen.SpecimenUid = "";
					}
					else
					{
						this._postSpecimen = new BOL.Specimen(this.txtPostSpecimenUID.Text);
						this.SetPostSpecimenBrokenRules();
						//
						if (this._postSpecimen.IsNew)
						{
							Utility.MessageBeep();
							this.errError.SetVbecsError(this.txtPostSpecimenUID, "Specimen not found"); // **** 508 Compliance ***
							this._postSpecimen.SpecimenUid = "";
						}
						else 
						{
							if (this._postSpecimen.Patient.PatientGuid != this._patientTransfusionReaction.PatientGuid)
							{
								Utility.MessageBeep();
								this.errError.SetVbecsError(this.txtPostSpecimenUID, "Post-specimen patient name does not match VBECS records."); // **** 508 Compliance ***
							}
							else
							{
								this.errError.SetVbecsError(this.txtPostSpecimenUID, ""); // **** 508 Compliance ***
							}
							//
							this._patientTransfusionReaction.PostSpecimenGuid = this._postSpecimen.SpecimenGuid;
						}
					}
				}
				else
				{
					this._postSpecimen.SpecimenUid = "";
				}
				//Reset broken rules
				this._postSpecimen.SpecimenUid = this._postSpecimen.SpecimenUid;
			}
		}

		private void PostSpecimenHemolysisChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPostHemolysis.SelectedIndex > -1)
			{
				this._patientTransfusionReaction.PostSpecimenHemolysisInspectionCode = ((ArrayList)this._hemolysisInspections[this.cmbPostHemolysis.SelectedIndex])[0].ToString();
			}
			else
			{
				this._patientTransfusionReaction.PostSpecimenHemolysisInspectionCode = null;
			}
		}

		private void PreSpecimenCommentChanged(object sender, System.EventArgs e)
		{
			if ((this.rdoPreClericalCheckFail.Checked) && (this.cmbPreSpecimenComments.SelectedIndex>-1) && (this.cmbPreSpecimenComments.Text.ToUpper() == "OTHER"))
			{
				this.lblPreSpecimenDetails.Text = "Details*";
			}
			else
			{
				this.lblPreSpecimenDetails.Text = "Details";
			}
			//
			this.CheckSpecimensValid(sender,e);
		}

		private void PostSpecimenCommentChanged(object sender, System.EventArgs e)
		{
			if ((this.rdoPostClericalCheckFail.Checked) && (this.cmbPostSpecimenComments.SelectedIndex>-1) && (this.cmbPostSpecimenComments.Text.ToUpper() == "OTHER"))
			{
				this.lblPostSpecimenDetails.Text = "Details*";
			}
			else
			{
				this.lblPostSpecimenDetails.Text = "Details";
			}
			//
			this.CheckSpecimensValid(sender,e);
		}

		private void SaveSpecimenChecks(object sender, System.EventArgs e)
		{
			bool success;
			
			//Empty Guids are ignored by the SetLocks function, so we can pass them as placeholders
			System.Guid preGuid = (this.rdoPreTransfusionNotAvailable.Checked) ? System.Guid.Empty : this._preSpecimen.SpecimenGuid;
			System.Guid postGuid = (this.rdoPostTransfusionNotAvailable.Checked) ? System.Guid.Empty : this._postSpecimen.SpecimenGuid;

			//Try to Lock the specimens (if any)
			if (!this.SetLocks(preGuid, postGuid))
			{
				return;
			}

			//Locks (if any) are set, so proceed to save
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("specimen check")) != DialogResult.Yes)
			{
				return;
			}
			DataTable specimenClericalCheckExceptions = null;
			//
			bool preSpecimenMismatch = false;
			bool postSpecimenMismatch = false;
			//
			if ((!this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator) && (this._preSpecimen.Patient.PatientGuid != this._patientTransfusionReaction.PatientGuid))
			{
				preSpecimenMismatch = true;
			}
			if ((!this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator) && (this._postSpecimen.Patient.PatientGuid != this._patientTransfusionReaction.PatientGuid))
			{
				postSpecimenMismatch = true;
			}
			//
			string overrideMessage = "";
			if (preSpecimenMismatch && postSpecimenMismatch)
			{
				overrideMessage = Common.StrRes.InfoMsg.UC021.SpecimenPatientMismatch("Pre and post-").ResString;
			}
			else if (preSpecimenMismatch)
			{
				overrideMessage = Common.StrRes.InfoMsg.UC021.SpecimenPatientMismatch("Pre-").ResString;
			}
			else if (postSpecimenMismatch)
			{
				overrideMessage = Common.StrRes.InfoMsg.UC021.SpecimenPatientMismatch("Post-").ResString;
			}
			//
			if (preSpecimenMismatch || postSpecimenMismatch)
			{
				Utility.MessageBeep();
				DlgOverrideComment dlg = new DlgOverrideComment("Patient Mismatch",overrideMessage,"TC");
                dlg.ShowDialogFromLockedParent(this, false);
                if (dlg.DialogResult != DialogResult.OK)
				{
					return;
				}
				//
				//create exception report entries
				if (preSpecimenMismatch)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Transfusion_Reaction_Workup, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionTrwSpecimen(this._patientTransfusionReaction,this._orderedTest.Patient,this._preSpecimen,this._patientTransfusionReaction.PreSpecimenClericalChecksOKIndicator);

					if (specimenClericalCheckExceptions == null)
					{
						specimenClericalCheckExceptions = exRep.ExceptionData.Table.Clone();
					}
					specimenClericalCheckExceptions.Rows.Add(exRep.ExceptionData.ItemArray);
				}
				//
				if (postSpecimenMismatch)
				{
					BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Transfusion_Reaction_Workup, dlg.Comment, Common.LogonUser.LogonUserName);
					exRep.GenerateExceptionTrwSpecimen(this._patientTransfusionReaction,this._orderedTest.Patient,this._postSpecimen,this._patientTransfusionReaction.PostSpecimenClericalChecksOKIndicator);

					if (specimenClericalCheckExceptions == null)
					{
						specimenClericalCheckExceptions = exRep.ExceptionData.Table.Clone();
					}
					specimenClericalCheckExceptions.Rows.Add(exRep.ExceptionData.ItemArray);
				}
				//
				GuiMessenger.ShowMessageBox(this,Common.StrRes.InfoMsg.UC021.ContactPhysician());
			}
			//
			try
			{
				using (new WaitCursor())
				{
					ArrayList comments = new ArrayList();
					//
					//Pre-Specimen Clerical Checks Comments
					if ((!this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator) && ((this.txtPreSpecimenComments.Text.Trim().Length>0) || (this.cmbPreSpecimenComments.SelectedIndex>-1)))
					{
						Guid commentGuid = Guid.Empty;
						if (this.cmbPreSpecimenComments.SelectedIndex>-1)
						{
							commentGuid = (Guid)this._clericalCheckComments.Rows[this.cmbPreSpecimenComments.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
						}
						BOL.PatientTransfusionComment comment = GetTransfusionComment("TC",commentGuid,this.txtPreSpecimenComments.Text);
						comment.PreTransfusionIndicator = true;
						comments.Add(comment);
						//
						//Create exception report entry
						if (!this._patientTransfusionReaction.PreSpecimenClericalChecksOKIndicator)
						{
							BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Transfusion_Reaction_Workup, BOL.CannedComment.CombinedComment(comment.CannedCommentGuid, comment.PatientTransfusionCommentText), Common.LogonUser.LogonUserName);
							exRep.GenerateExceptionTrwSpecimen(this._patientTransfusionReaction,this._orderedTest.Patient,this._preSpecimen,this._patientTransfusionReaction.PreSpecimenClericalChecksOKIndicator);

							if (specimenClericalCheckExceptions == null)
							{
								specimenClericalCheckExceptions = exRep.ExceptionData.Table.Clone();
							}
							specimenClericalCheckExceptions.Rows.Add(exRep.ExceptionData.ItemArray);
						}
					}
					//
					//
					//Post-Specimen Clerical Checks Comments
					if ((!this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator) && ((this.txtPostSpecimenComments.Text.Trim().Length>0) || (this.cmbPreSpecimenComments.SelectedIndex>-1)))
					{
						Guid commentGuid = Guid.Empty;
						if (this.cmbPostSpecimenComments.SelectedIndex>-1)
						{
							commentGuid = (Guid)this._clericalCheckComments.Rows[this.cmbPostSpecimenComments.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
						}
						BOL.PatientTransfusionComment comment = GetTransfusionComment("TC",commentGuid,this.txtPostSpecimenComments.Text);
						comment.PreTransfusionIndicator = false;
						comments.Add(comment);
						//
						//Create exception report entry
						if (!this._patientTransfusionReaction.PostSpecimenClericalChecksOKIndicator)
						{
							BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Transfusion_Reaction_Workup, BOL.CannedComment.CombinedComment(comment.CannedCommentGuid, comment.PatientTransfusionCommentText), Common.LogonUser.LogonUserName);
							exRep.GenerateExceptionTrwSpecimen(this._patientTransfusionReaction,this._orderedTest.Patient,this._postSpecimen,this._patientTransfusionReaction.PostSpecimenClericalChecksOKIndicator);

							if (specimenClericalCheckExceptions == null)
							{
								specimenClericalCheckExceptions = exRep.ExceptionData.Table.Clone();
							}
							specimenClericalCheckExceptions.Rows.Add(exRep.ExceptionData.ItemArray);
						}
					}
					//
					//Pre-Specimen Not Available Comments
					if ((this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator) && ((this.txtPreDetails.Text.Trim().Length>0) || (this.cmbPreComment.SelectedIndex>-1)))
					{
						Guid commentGuid = Guid.Empty;
						if (this.cmbPreComment.SelectedIndex>-1)
						{
							commentGuid = (Guid)this._preSpecimenNotAvailableComments.Rows[this.cmbPreComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
						}
						comments.Add(GetTransfusionComment("T1",commentGuid,this.txtPreDetails.Text));
					}
					//
					//Post-Specimen Not Available Comments
					if ((this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator) && ((this.txtPostDetails.Text.Trim().Length>0) || (this.cmbPostComment.SelectedIndex>-1)))
					{
						Guid commentGuid = Guid.Empty;
						if (this.cmbPostComment.SelectedIndex>-1)
						{
							commentGuid = (Guid)this._postSpecimenNotAvailableComments.Rows[this.cmbPostComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
						}
						comments.Add(GetTransfusionComment("T2",commentGuid,this.txtPostDetails.Text));
					}
					//
					ArrayList specimens = new ArrayList();
					//
					if (this.rdoPreTransfusionAvailable.Checked)
					{
						specimens.Add(this._preSpecimen);
						this._patientTransfusionReaction.PreSpecimenGuid = this._preSpecimen.SpecimenGuid;
					}
					else
					{
						this._patientTransfusionReaction.PreSpecimenGuid = Guid.Empty;
					}
					//
					if (this.rdoPostTransfusionAvailable.Checked)
					{
						specimens.Add(this._postSpecimen);
						this._patientTransfusionReaction.PostSpecimenGuid = this._postSpecimen.SpecimenGuid;
					}
					else
					{
						this._patientTransfusionReaction.PostSpecimenGuid = Guid.Empty;
					}
					//
					success = this._patientTransfusionReaction.SaveSpecimenCheckData(this._orderedTest,comments,specimenClericalCheckExceptions);
					//
					if (!success)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("specimen checks"));
						return;
					}
					//
					//Reload PTR record, to update RowVersions ready for possible new save...
					this.LoadInitialObjects();
                    if (this.LockController.LockingConflict) return;    //this is set if the lock fails, so need to get out
					//
					this.EnableSpecimenCheckControls(false);
					//
					this.IsDirty = false;
					this.AddTabPage(this.pageImplicatedUnits);
					this.PopulateImplicatedUnitsTab();
					//
					this.btnInvalidateTRW.EnabledButton = true;
				}
			}
			catch(Common.RowVersionException)
			{
				this.btnSymptomsOK.RowVersionException = true;		//CR2077
				this.btnUnitsOK.RowVersionException = true;			//CR2077
				this.btnSpecimenOK.RowVersionException = true;		//CR2077
				this.btnTestsOK.RowVersionException = true;			//CR2077
				
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}
			
		}

		private void PreCommentChanged(object sender, System.EventArgs e)
		{
			if ((this.cmbPreComment.SelectedIndex>-1) && (this.cmbPreComment.Text.ToUpper() == "OTHER"))
			{
				this.lblPreDetails.Text = "Details*";
			}
			else
			{
				this.lblPreDetails.Text = "Details";
			}
			//
			this.CheckSpecimensValid(sender, e);
		}

		private void PostCommentChanged(object sender, System.EventArgs e)
		{
			if ((this.cmbPostComment.SelectedIndex>-1) && (this.cmbPostComment.Text.ToUpper() == "OTHER"))
			{
				this.lblPostDetails.Text = "Details*";
			}
			else
			{
				this.lblPostDetails.Text = "Details";
			}
			//
			this.CheckSpecimensValid(sender, e);
		}

		private void btnSpecimenOK_MouseHover(object sender, System.EventArgs e)
		{
			StringBuilder tooltip = new StringBuilder();
			//
			if (!this._patientTransfusionReaction.IsValid)
			{
				tooltip.Append(this._patientTransfusionReaction.GetBrokenRulesMessage(this.Name)+"\n");
			}
			//
			if (this.rdoPreTransfusionAvailable.Checked)
			{
				if(!this._preSpecimen.IsValid)
				{
					tooltip.Append(this._preSpecimen.GetBrokenRulesMessage(this.Name)+"\n");
				}
				if ((!this.rdoPreClericalCheckOK.Checked) && (!this.rdoPreClericalCheckFail.Checked))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.PreSpecimenClericalChecks().ResString+"\n");
				}
				if (this.rdoPreClericalCheckFail.Checked)
				{
					if (!this.IsCommentComplete(this.cmbPreSpecimenComments,this.txtPreSpecimenComments))
					{
						tooltip.Append(Common.StrRes.Tooltips.UC021.PreSpecimenClericalCheckFailComment().ResString+"\n");
					}
				}
			}
			else if (this.rdoPreTransfusionNotAvailable.Checked)
			{
				if (!this.IsCommentComplete(this.cmbPreComment,this.txtPreDetails))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.NoPreSpecimenComment().ResString+"\n");
				}
			}
			else
			{
				tooltip.Append(Common.StrRes.Tooltips.UC021.PreTransfusionSpecimenAvailable().ResString+"\n");
			}
			//
			if (this.rdoPostTransfusionAvailable.Checked)
			{
				if(!this._postSpecimen.IsValid)
				{
					tooltip.Append(this._postSpecimen.GetBrokenRulesMessage(this.Name)+"\n");
				}
				if ((!this.rdoPostClericalCheckOK.Checked) && (!this.rdoPostClericalCheckFail.Checked))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.PostSpecimenClericalChecks().ResString+"\n");
				}
				if (this.rdoPostClericalCheckFail.Checked)
				{
					if (!this.IsCommentComplete(this.cmbPostSpecimenComments,this.txtPostSpecimenComments))
					{
						tooltip.Append(Common.StrRes.Tooltips.UC021.PostSpecimenClericalCheckFailComment().ResString+"\n");
					}
				}
			}
			else if (this.rdoPostTransfusionNotAvailable.Checked)
			{
				if (!this.IsCommentComplete(this.cmbPostComment,this.txtPostDetails))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.NoPostSpecimenComment().ResString+"\n");
				}
			}
			else
			{
				tooltip.Append(Common.StrRes.Tooltips.UC021.PostTransfusionSpecimenAvailable().ResString+"\n");
			}
			//
			if (tooltip.Length==0)
			{
				tooltip.Append(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			//
			this.btnSpecimenOK.SetToolTip(tooltip.ToString());
		}

		#endregion

		#region Implicated Units Methods

		private void EnableImplicatedUnitControls(bool enable)
		{
			this.rdoImplicatedUnitsIdentified.Enabled = enable;
			this.rdoNoImplicatedUnitsIdentified.Enabled = enable;
			//
			this.grpIdentifyUnits.Enabled = enable;
			//
			this.lvImplicatedUnits.CheckBoxes = enable;
			//
			this.btnUnitsOK.Enabled = enable;
			//
			this.btnUnitsOK.EnabledButton = false;
		}

		private void ResetImplicatedUnits()
		{
			this.rdoImplicatedUnitsIdentified.Checked = false;
			this.rdoNoImplicatedUnitsIdentified.Checked = false;
			//
			this.lvImplicatedUnits.Items.Clear();
		}

		private void PopulateImplicatedUnitsTab()
		{
			_implicatedUnitComments = new ArrayList();
			//
			if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.ImplicatedUnitsComplete)
			{
				this.AddTabPage(this.pageImplicatedUnits);
				//
				LoadSavedImplicatedUnits();
				//
				this.EnableImplicatedUnitControls(false);
			}
			else if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.SpecimenChecksComplete)
			{
				this.AddTabPage(this.pageImplicatedUnits);
				//
				this.EnableImplicatedUnitControls(true);
				this.ResetImplicatedUnits();
			}
			//
			this.lblCompleteMessage2.Visible = ((int)this._patientTransfusionReaction.PartialSaveId == (int)Common.PatientTransfusionPartialSaveId.SerologicTestsComplete);
		}

		private void DisplaySerologicTestsForImplicatedUnits(ArrayList implicatedUnits)
		{
			if ((this._preSpecimen != null) && (this._preSpecimen.SpecimenUid != "") && (!this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator))
			{
				this.lblPreABORh.Text = "Pre ("+this._preSpecimen.SpecimenUid+")";
				this.lblPreABS.Text = "Pre ("+this._preSpecimen.SpecimenUid+")";
				this.lblPreDAT.Text = "Pre ("+this._preSpecimen.SpecimenUid+")";
			}
			else
			{
				this.lblPreABORh.Text = "Pre-Specimen";
				this.lblPreABS.Text = "Pre-Specimen";
				this.lblPreDAT.Text = "Pre-Specimen";
			}
			//
			if ((this._postSpecimen != null) && (this._postSpecimen.SpecimenUid != "") && (!this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator))
			{
				this.lblPostABORh.Text = "Post ("+this._postSpecimen.SpecimenUid+")";
				this.lblPostABS.Text = "Post ("+this._postSpecimen.SpecimenUid+")";
				this.lblPostDAT.Text = "Post ("+this._postSpecimen.SpecimenUid+")";
			}
			else
			{
				this.lblPostABORh.Text = "Post-Specimen";
				this.lblPostABS.Text = "Post-Specimen";
				this.lblPostDAT.Text = "Post-Specimen";
			}
			//
			this.pnlABORh.SuspendLayout();
			this.pnlXM.SuspendLayout();
			//
			//Get rid of the existing unit controls, which are only included at 
			//design time to ease UI screenshots etc..

			for(int i = 0; i < this.pnlABORh.Controls.Count; i++)
			{
				Control ctrl = this.pnlABORh.Controls[i];
				if ((ctrl != null) && (ctrl.Name.StartsWith("lblUnitABORh")))
				{
					ctrl.Dispose();
					//We've removed an item in the list, so we have to decrement i
					//or we'll skip an entry!
					i--;
				}
			}
			for(int i = 0; i < this.pnlXMLabels.Controls.Count; i++)
			{
				Control ctrl = this.pnlXMLabels.Controls[i];
				if ((ctrl != null) && (ctrl.Name.StartsWith("lblUnitXM")))
				{
					ctrl.Dispose();
					//We've removed an item in the list, so we have to decrement i
					//or we'll skip an entry!
					i--;
				}
			}
			for(int i = 0; i < this.pnlABO.Controls.Count; i++)
			{
				Control ctrl = this.pnlABO.Controls[i];
				if ((ctrl != null) && (ctrl.Name.StartsWith("cmbUnitABOInterp")))
				{
					ctrl.Dispose();
					//We've removed an item in the list, so we have to decrement i
					//or we'll skip an entry!
					i--;
				}
			}
			for(int i = 0; i < this.pnlRh.Controls.Count; i++)
			{
				Control ctrl = this.pnlRh.Controls[i];
				if ((ctrl != null) && (ctrl.Name.StartsWith("cmbUnitRhInterp")))
				{
					ctrl.Dispose();
					//We've removed an item in the list, so we have to decrement i
					//or we'll skip an entry!
					i--;
				}
			}
			for(int i = 0; i < this.pnlPreXM.Controls.Count; i++)
			{
				Control ctrl = this.pnlPreXM.Controls[i];
				if ((ctrl != null) && (ctrl.Name.StartsWith("cmbUnitPreXMInterp")))
				{
					ctrl.Dispose();
					//We've removed an item in the list, so we have to decrement i
					//or we'll skip an entry!
					i--;
				}
			}
			for(int i = 0; i < this.pnlPostXM.Controls.Count; i++)
			{
				Control ctrl = this.pnlPostXM.Controls[i];
				if ((ctrl != null) && (ctrl.Name.StartsWith("cmbUnitPostXMInterp")))
				{
					ctrl.Dispose();
					//We've removed an item in the list, so we have to decrement i
					//or we'll skip an entry!
					i--;
				}
			}
			//
			if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator && this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
			{
				this.cbABS.Enabled = false;
				this.cbDAT.Enabled = false;
				this.cbXM.Enabled = false;
				if (implicatedUnits.Count == 0)
				{
					this.cbABORh.Enabled = false;
				}
			}
			else if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator)
			{
				this.cmbPreABOInterp.Enabled = false;
				this.cmbPreRhInterp.Enabled = false;
				this.cmbPreABSInterp.Enabled = false;
				this.cmbPreDATInterp.Enabled = false;
			}
				//
			else if (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
			{
				this.cmbPostABOInterp.Enabled = false;
				this.cmbPostRhInterp.Enabled = false;
				this.cmbPostABSInterp.Enabled = false;
				this.cmbPostDATInterp.Enabled = false;
			}
			//
			if (implicatedUnits.Count == 0)
			{
				this.cbXM.Enabled = false;
			}
			else
			{
				for(int i=1;i<=implicatedUnits.Count;i++)
				{
					BOL.BloodUnit unit = (BOL.BloodUnit)implicatedUnits[i-1];
					//
					//Add label and ABO and Rh Interp combo boxes for each implicated unit
					// 
					Label lblUnitABORh = new Label();
					this.pnlABORh.Controls.Add(lblUnitABORh);
					lblUnitABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)));
					lblUnitABORh.Location = new System.Drawing.Point(4, this.lblPostABORh.Top+(24*i));
					lblUnitABORh.Name = "lblUnitABORh"+i;
					lblUnitABORh.Size = new System.Drawing.Size(96, 20);
					lblUnitABORh.Text = unit.EyeReadableUnitId;
					lblUnitABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
					// 
					controls.ComboBoxLookup cmbUnitABOInterp = new controls.ComboBoxLookup();
					this.pnlABO.Controls.Add(cmbUnitABOInterp);
					cmbUnitABOInterp.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)));
					cmbUnitABOInterp.Interval = 100;
					cmbUnitABOInterp.Location = new System.Drawing.Point(0, this.cmbPostABOInterp.Top+(24*i));
					cmbUnitABOInterp.Name = "cmbUnitABOInterp"+i;
					cmbUnitABOInterp.Size = new System.Drawing.Size(this.pnlABO.Width, 22);
					cmbUnitABOInterp.Tag = unit;
					cmbUnitABOInterp.SelectedIndexChanged += new EventHandler(UnitAboRhInterpChanged);
					// 
					controls.ComboBoxLookup cmbUnitRhInterp = new controls.ComboBoxLookup();
					this.pnlRh.Controls.Add(cmbUnitRhInterp);
					cmbUnitRhInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
					cmbUnitRhInterp.Interval = 100;
					cmbUnitRhInterp.Location = new System.Drawing.Point(0, this.cmbPostRhInterp.Top+(24*i));
					cmbUnitRhInterp.Name = "cmbUnitRhInterp"+i;
					cmbUnitRhInterp.Size = new System.Drawing.Size(this.pnlRh.Width, 22);
					cmbUnitRhInterp.Tag = unit;
					cmbUnitRhInterp.SelectedIndexChanged += new EventHandler(UnitAboRhInterpChanged);
					//
					//Add label and XM Interp combo box for each implicated unit
					//
					Label lblUnitXM = new Label();
					this.pnlXMLabels.Controls.Add(lblUnitXM);
					lblUnitXM.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)));
					lblUnitXM.Location = new System.Drawing.Point(4, (24*i)-4);
					lblUnitXM.Name = "lblUnitXM"+i;
					lblUnitXM.Size = new System.Drawing.Size(96, 20);
					lblUnitXM.Text = unit.EyeReadableUnitId;
					lblUnitXM.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
					//
					controls.ComboBoxLookup cmbUnitPreXMInterp = new controls.ComboBoxLookup();
					this.pnlPreXM.Controls.Add(cmbUnitPreXMInterp);
					cmbUnitPreXMInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
					cmbUnitPreXMInterp.Interval = 100;
					cmbUnitPreXMInterp.Location = new System.Drawing.Point(0, (24*i)-24);
					cmbUnitPreXMInterp.Name = "cmbUnitPreXMInterp"+i;
					cmbUnitPreXMInterp.Size = new System.Drawing.Size(this.pnlPreXM.Width, 22);
					cmbUnitPreXMInterp.Tag = unit;
					cmbUnitPreXMInterp.SelectedIndexChanged += new EventHandler(XMInterpChanged);
					if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator)
					{
						cmbUnitPreXMInterp.Enabled = false;
					}
					//
					controls.ComboBoxLookup cmbUnitPostXMInterp = new controls.ComboBoxLookup();
					this.pnlPostXM.Controls.Add(cmbUnitPostXMInterp);
					cmbUnitPostXMInterp.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
						| System.Windows.Forms.AnchorStyles.Right)));
					cmbUnitPostXMInterp.Interval = 100;
					cmbUnitPostXMInterp.Location = new System.Drawing.Point(0, (24*i)-24);
					cmbUnitPostXMInterp.Name = "cmbUnitPostXMInterp"+i;
					cmbUnitPostXMInterp.Size = new System.Drawing.Size(this.pnlPostXM.Width, 22);
					cmbUnitPostXMInterp.Tag = unit;
					cmbUnitPostXMInterp.SelectedIndexChanged += new EventHandler(XMInterpChanged);
					if (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
					{
						cmbUnitPostXMInterp.Enabled = false;
					}
				}
			}
			this.pnlABORh.ResumeLayout(true);
			this.pnlXM.ResumeLayout(true);
			//
			this.LoadInterps();
		}

		private void CheckImplicatedUnitValid()
		{
			//Only checked if not already saved
			if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.ImplicatedUnitsComplete)
			{
				this.btnAddUnit.EnabledButton = false;
				return;
			}
			//
			if ((this._patientTransfusion == null) || (this._patientTransfusion.BloodUnitGuid == Guid.Empty))
			{
				this.btnAddUnit.EnabledButton = false;
				return;
			}
			if (!this.rdoBloodBagNotReturned.Checked && !this.rdoBloodBagReturned.Checked)
			{
				this.btnAddUnit.EnabledButton = false;
				return;
			}
			if (this.rdoBloodBagReturned.Checked)
			{
				if (this._transfusionReaction.BagHemolysisInspectionCode.Length == 0)
				{
					this.btnAddUnit.EnabledButton = false;
					return;
				}
				//
				if (!this.rdoBagCheckOK.Checked && !this.rdoBagCheckFail.Checked)
				{
					this.btnAddUnit.EnabledButton = false;
					return;
				}
				//
				if (this.rdoBagCheckFail.Checked)
				{
					if (!this.IsCommentComplete(this.cmbBagComment,this.txtBagComment))
					{
						this.btnAddUnit.EnabledButton = false;
						return;
					}
				}
			}
			if (this.rdoBloodBagNotReturned.Checked)
			{
				if (!this.IsCommentComplete(this.cmbBagNotReturnedComment,this.txtBagNotReturnedComment))
				{
					this.btnAddUnit.EnabledButton = false;
					return;
				}
			}
			//
			this.btnAddUnit.EnabledButton = true;
		}

		private void ImplicatedUnitsChecked(object sender, System.EventArgs e)
		{
			this.grpIdentifyUnits.Visible = this.rdoImplicatedUnitsIdentified.Checked;
			this.grpImplicatedUnits.Visible = this.rdoImplicatedUnitsIdentified.Checked;
			this.IsDirty = true;
			//
			this.btnUnitsOK.EnabledButton = (this.rdoNoImplicatedUnitsIdentified.Checked || (this.rdoImplicatedUnitsIdentified.Checked && (this.lvImplicatedUnits.CheckedItems.Count>1)));
		}

		private void BloodBagReturnedChecked(object sender, System.EventArgs e)
		{
			if (this.rdoBloodBagReturned.Checked)
			{
				this.grpBloodBagChecks.Visible = true;
				this.grpBloodBagChecks.Enabled = true;
				this.grpBagNotReturned.Visible = false;
				this._transfusionReaction.BagReturnedIndicator = true;
				this.IsDirty = true;
			}
			else if (this.rdoBloodBagNotReturned.Checked)
			{
				this.grpBloodBagChecks.Visible = false;
				this.grpBloodBagChecks.Enabled = false;
				this.grpBagNotReturned.Visible = true;
				this._transfusionReaction.BagReturnedIndicator = false;
				this.IsDirty = true;
			}
			else
			{
				this.grpBloodBagChecks.Visible = true;
				this.grpBloodBagChecks.Enabled = false;
				this.grpBagNotReturned.Visible = false;
			}
			//
			this.CheckImplicatedUnitValid();
		}

		private void txtUnitID_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (!this.txtUnitID.ReadOnly)
			{
				if (e.KeyCode == Keys.Enter)
				{
					FindBloodUnit();
				}
			}
		}

		private void txtUnitID_Leave(object sender, System.EventArgs e)
		{
			if (!this.txtUnitID.ReadOnly)
			{
				FindBloodUnit();
			}
			//
			this.CheckImplicatedUnitValid();
		}

		private void txtProduct_KeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			if (!this.txtProduct.ReadOnly)
			{
				if (e.KeyCode == Keys.Enter)
				{
					FindBloodUnit();
				}
			}
		}

		private void txtProduct_Leave(object sender, System.EventArgs e)
		{
			if (!this.txtProduct.ReadOnly)
			{
				//
				FindBloodUnit();
			}
			//
			this.CheckImplicatedUnitValid();
		}

		private void FindBloodUnit()
		{
			if (this.txtUnitID.Text.Trim().Length == 0 || this.txtProduct.Text.Trim().Length == 0)
			{
				this._patientTransfusion = null;
				this._transfusionReaction = null;
				this._implicatedUnitBagNotReturnedComment = null;
				this._implicatedUnitClericalCheckComment = null;
				//
				this.errError.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
				this.errError.SetVbecsError(this.txtProduct, string.Empty); // **** 508 Compliance ***
			}
			else if ((this._codabarUnitID.IsMatch(this.txtUnitID.Text) || this._isbtUnitID.IsMatch(this.txtUnitID.Text)) &&
				(this._codabarProductCode.IsMatch(this.txtProduct.Text) || this._isbtProductCode.IsMatch(this.txtProduct.Text)))
			{
				try
				{
					this.errError.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
					//
					// Check for multiple blood product code...
					BOL.BloodProduct bloodProduct = null;
					//
					// CR 2210	
					// Make sure to include local product types
					bool selectLocalProducts = true;
					//
					MultipleBloodProductCode multipleBloodProductCode = new MultipleBloodProductCode( ThisUser, this, this.txtProduct.Text.Trim(), selectLocalProducts );
					if ( multipleBloodProductCode.BloodProductsDataTable.Rows.Count > 0 )
					{
						bloodProduct = multipleBloodProductCode.BloodProduct;
					}
					else
					{
						// invalid product code entered
						this._patientTransfusion = null;
						this._transfusionReaction = null;
						this._implicatedUnitBagNotReturnedComment = null;
						this._implicatedUnitClericalCheckComment = null;
						this.grpBloodBagReturned.Enabled = false;
						//
						if (this.txtProduct.BarcodeType == Common.BarcodeType.ISBT128)
						{
							this.errError.SetVbecsError(this.txtProduct, Common.StrRes.SysErrMsg.Common.ISBTProductCode().ResString); // **** 508 Compliance ***
						}
						else
						{
							this.errError.SetVbecsError(this.txtProduct, Common.StrRes.SysErrMsg.Common.CodabarProductCode().ResString); // **** 508 Compliance ***
						}
						return;
					}
					//
					BOL.BloodUnit unit = new BOL.BloodUnit(this.txtUnitID.Text, this.txtProduct.Text,this.txtProduct.BarcodeType,bloodProduct.BloodProductGuid);
					//
					try
					{
						System.Guid bloodUnitGUID = BOL.BloodUnit.GetBloodUnitGuid(this.txtUnitID.Text, this.txtProduct.Text.Substring(0,5), Common.LogonUser.LogonUserDivisionCode, BOL.BloodUnit.GetUnitDivisionId(this.txtProduct.Text));

						unit = new BOL.BloodUnit(bloodUnitGUID);
                                
						if(this.txtUnitID.Text != unit.EyeReadableUnitId)
						{
							this.txtUnitID.Text = unit.EyeReadableUnitId;
						}
					}
					catch
					{
						this._patientTransfusion = null;
						this._transfusionReaction = null;
						this._implicatedUnitBagNotReturnedComment = null;
						this._implicatedUnitClericalCheckComment = null;
						this.grpBloodBagReturned.Enabled = false;
						//
						this.errError.SetVbecsError(this.txtProduct, Common.StrRes.SysErrMsg.Common.UnitNotFound().ResString); // **** 508 Compliance ***
					}
					//
					if (unit.BloodUnitStatus.UnitStatusCode != Common.UnitStatusCode.Transfused)
					{
						this._patientTransfusion = null;
						this._transfusionReaction = null;
						this._implicatedUnitBagNotReturnedComment = null;
						this._implicatedUnitClericalCheckComment = null;
						this.grpBloodBagReturned.Enabled = false;
						//
						this.errError.SetVbecsError(this.txtProduct, Common.StrRes.InfoMsg.UC021.UnitNotTransfused(unit.EyeReadableUnitId,unit.ProductShortName).ResString); // **** 508 Compliance ***
						return;
					}
					//
					if (this.IsBloodUnitTransfusedToPatient(unit.BloodUnitGuid))
					{
						this.txtUnitID.ReadOnly = true;
						this.txtProduct.ReadOnly = true;
						this.grpBloodBagReturned.Enabled = true;
						//
						this.errError.SetVbecsError(this.txtProduct, string.Empty); // **** 508 Compliance ***
					}
					else
					{
						this._patientTransfusion = null;
						this._transfusionReaction = null;
						this._implicatedUnitBagNotReturnedComment = null;
						this._implicatedUnitClericalCheckComment = null;
						this.grpBloodBagReturned.Enabled = false;
						//
						this.errError.SetVbecsError(this.txtProduct, Common.StrRes.InfoMsg.UC021.UnitPatientMismatch().ResString); // **** 508 Compliance ***
						Utility.MessageBeep();
						GuiMessenger.ShowMessageBox(this,Common.StrRes.InfoMsg.UC021.UnitPatientMismatch());
					}
				}
				catch(Exception err)
				{
					this._patientTransfusion = null;
					this._transfusionReaction = null;
					this._implicatedUnitBagNotReturnedComment = null;
					this._implicatedUnitClericalCheckComment = null;
					this.grpBloodBagReturned.Enabled = false;
					//
					this.errError.SetVbecsError(this.txtProduct, err.Message); // **** 508 Compliance ***
				}
			}
			else
			{
				if (!this._codabarUnitID.IsMatch(this.txtUnitID.Text) && !this._isbtUnitID.IsMatch(this.txtUnitID.Text))
				{
					this.errError.SetVbecsError(this.txtUnitID, Common.StrRes.ValidMsg.Common.InvalidUnitIdFormat().ResString); // **** 508 Compliance ***
				}
				//
				if (!this._codabarProductCode.IsMatch(this.txtProduct.Text) && !this._isbtProductCode.IsMatch(this.txtProduct.Text))
				{
					this.errError.SetVbecsError(this.txtProduct, Common.StrRes.ValidMsg.Common.InvalidProductCodeFormat().ResString); // **** 508 Compliance ***
				}
			}
		}

		private bool IsBloodUnitTransfusedToPatient(Guid bloodUnitGuid)
		{
			if (this._patientTransfusions != null)
			{
				foreach(BOL.PatientTransfusion transfusion in this._patientTransfusions)
				{
					if (transfusion.BloodUnitGuid == bloodUnitGuid)
					{
						this._patientTransfusion = transfusion;
						//
						GetTransfusionReactionRecord(transfusion);
						GetBagNotReturnedComment(transfusion);
						GetBagClericalCheckComment(transfusion);
						//
						return true;
					}
				}
			}
			//
			this._patientTransfusion = null;
			this._transfusionReaction = null;
			this._implicatedUnitBagNotReturnedComment = null;
			this._implicatedUnitClericalCheckComment = null;
			//
			return false;
		}

		private void GetBagNotReturnedComment(BOL.PatientTransfusion transfusion)
		{
			foreach(BOL.PatientTransfusionComment comment in this._implicatedUnitComments)
			{
				if ((comment.PatientTransfusionGuid == transfusion.PatientTransfusionGuid) && (comment.CommentCategoryCode == "TB"))
				{
					this._implicatedUnitBagNotReturnedComment = comment;
					return;
				}
			}
			//
			this._implicatedUnitBagNotReturnedComment = this.GetTransfusionComment("TB",Guid.Empty,"");
			this._implicatedUnitBagNotReturnedComment.PatientTransfusionGuid = transfusion.PatientTransfusionGuid;
			this._implicatedUnitComments.Add(this._implicatedUnitBagNotReturnedComment);
		}

		private void GetBagClericalCheckComment(BOL.PatientTransfusion transfusion)
		{
			foreach(BOL.PatientTransfusionComment comment in this._implicatedUnitComments)
			{
				if ((comment.PatientTransfusionGuid == transfusion.PatientTransfusionGuid) && (comment.CommentCategoryCode == "TC"))
				{
					this._implicatedUnitClericalCheckComment = comment;
					return;
				}
			}
			//
			this._implicatedUnitClericalCheckComment = this.GetTransfusionComment("TC",Guid.Empty,"");
			this._implicatedUnitClericalCheckComment.PatientTransfusionGuid = transfusion.PatientTransfusionGuid;
			this._implicatedUnitComments.Add(this._implicatedUnitClericalCheckComment);
		}

		private void btnAddUnit_Click(object sender, System.EventArgs e)
		{
			if (this.IsUnitAlreadyImplicated())
			{
				this.UpdateImplicatedUnit(this._patientTransfusion);
			}
			else
			{
				this.AddImplicatedUnit(this._patientTransfusion);
			}
			//
			controls.VbecsFunction.SetColumnWidths(this.lvImplicatedUnits);
			//
			this.ClearImplicatedUnit();
		}

		private void ClearImplicatedUnit()
		{
			this._patientTransfusion = null;
			this._transfusionReaction = null;
			this._implicatedUnitBagNotReturnedComment = null;
			this._implicatedUnitClericalCheckComment = null;
			this.txtUnitID.Text = "";
			this.txtUnitID.ReadOnly = false;
			this.txtProduct.Text = "";
			this.txtProduct.ReadOnly = false;
			this.errError.SetVbecsError(this.txtUnitID, ""); // **** 508 Compliance ***
			this.errError.SetVbecsError(this.txtProduct, ""); // **** 508 Compliance ***
			this.rdoBloodBagNotReturned.Checked = false;
			this.rdoBloodBagReturned.Checked = false;
			//Setting both of these to unchecked will result in 
			//the radio buttons losing their tabstop value
			//don't ask me why, ask microsoft.
			this.rdoBloodBagReturned.TabStop = true;
			this.grpBloodBagReturned.Enabled = false;
			this.rdoBagCheckFail.Checked = false;
			this.rdoBagCheckOK.Checked = false;
			//Setting both of these to unchecked will result in 
			//the radio buttons losing their tabstop value
			//don't ask me why, ask microsoft.
			this.rdoBagCheckOK.TabStop = true;
			this.cmbUnitHemolysis.SelectedIndex = -1;
			this.cmbBagComment.SelectedIndex = -1;
			this.txtBagComment.Text = "";
			this.cmbBagNotReturnedComment.SelectedIndex = -1;
			this.txtBagNotReturnedComment.Text = "";
			this.lvImplicatedUnits.SelectedItems.Clear();
			//
			this.btnAddUnit.Text = "&Add";
			this.btnAddUnit.EnabledButton = false;
		}

		private void AddImplicatedUnit(BOL.PatientTransfusion patientTransfusion)
		{
			if (this._transfusionReaction == null)
			{
				//Loading previously saved transfusion reactions
				GetTransfusionReactionRecord(patientTransfusion);
			}
			//
			this._transfusionReactions.Add(this._transfusionReaction);
				ListViewItem lvi = new ListViewItem();
				lvi.Tag = patientTransfusion;
				BOL.BloodUnit bloodUnit = new BOL.BloodUnit(patientTransfusion.BloodUnitGuid);
				lvi.Checked = true;
				lvi.SubItems.Add(bloodUnit.EyeReadableUnitId);
				//CR 2824
				lvi.SubItems.Add(bloodUnit.ProductShortName + ", " + bloodUnit.FullProductCode);
				lvi.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);
				lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate));
				if (this._transfusionReaction.BagReturnedIndicator)
				{
					lvi.SubItems.Add(GetHemolysis(this._transfusionReaction.BagHemolysisInspectionCode));
				}
				else
				{
					lvi.SubItems.Add("");
				}
			this.lvImplicatedUnits.Items.Add(lvi);
		}

		private void UpdateImplicatedUnit(BOL.PatientTransfusion patientTransfusion)
		{
			foreach(ListViewItem lvi in this.lvImplicatedUnits.Items)
			{
				if (((BOL.PatientTransfusion)lvi.Tag).BloodUnitGuid == patientTransfusion.BloodUnitGuid)
				{
//					foreach (BOL.TransfusionReaction reaction in this._transfusionReactions)
//					{
//						if (reaction.PatientTransfusionGuid == patientTransfusion.PatientTransfusionGuid)
//						{
							lvi.Tag = patientTransfusion;
							lvi.Checked = true;
							BOL.BloodUnit bloodUnit = new BOL.BloodUnit(patientTransfusion.BloodUnitGuid);
							lvi.SubItems[1].Text = bloodUnit.EyeReadableUnitId;
							lvi.SubItems[2].Text = bloodUnit.ProductShortName;
							lvi.SubItems[3].Text = bloodUnit.BloodUnitMedia.AboRh.AboRHText;
							lvi.SubItems[4].Text = Common.VBECSDateTime.FormatDateTimeString(bloodUnit.BloodUnitMedia.UnitExpirationDate);
							if (this._transfusionReaction.BagReturnedIndicator)
							{
								lvi.SubItems[5].Text = GetHemolysis(this._transfusionReaction.BagHemolysisInspectionCode);
							}
							else
							{
								lvi.SubItems[5].Text = "";
							}
							//
//							break;
//						}
//					}
				}
			}
		}

		private void LoadImplicatedUnit(BOL.PatientTransfusion patientTransfusion)
		{
			this._patientTransfusion = patientTransfusion;
			//
			foreach(BOL.TransfusionReaction reaction in this._transfusionReactions)
			{
				if (reaction.PatientTransfusionGuid == patientTransfusion.PatientTransfusionGuid)
				{
					this._transfusionReaction = reaction;
					break;
				}
			}
			//
			foreach(BOL.PatientTransfusionComment comment in this._implicatedUnitComments)
			{
				if (comment.PatientTransfusionGuid == patientTransfusion.PatientTransfusionGuid)
				{
					if (comment.CommentCategoryCode == "TB")
					{
						this._implicatedUnitBagNotReturnedComment = comment;
						//
						this.txtBagNotReturnedComment.Text = comment.PatientTransfusionCommentText;
						if (comment.CannedCommentGuid != Guid.Empty)
						{
							foreach(DataRow dr in this._bagNotReturnedComments.Rows)
							{
								if ((Guid)dr[Common.VbecsTables.CannedComment.CannedCommentGuid] == comment.CannedCommentGuid)
								{
									this.cmbBagNotReturnedComment.Text = dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString();
									break;
								}
							}
						}
					}
					else if (comment.CommentCategoryCode == "TC")
					{
						this._implicatedUnitClericalCheckComment = comment;
						//
						this.txtBagComment.Text = comment.PatientTransfusionCommentText;
						if (comment.CannedCommentGuid != Guid.Empty)
						{
							foreach(DataRow dr in this._clericalCheckComments.Rows)
							{
								if ((Guid)dr[Common.VbecsTables.CannedComment.CannedCommentGuid] == comment.CannedCommentGuid)
								{
									this.cmbBagComment.Text = dr[Common.VbecsTables.CannedComment.CannedCommentText].ToString();
									break;
								}
							}
						}
					}
				}
			}
			//
			BOL.BloodUnit bloodUnit = new BOL.BloodUnit(patientTransfusion.BloodUnitGuid);
			//
			this.txtUnitID.Text = bloodUnit.EyeReadableUnitId;
			this.txtProduct.Text = bloodUnit.FullProductCode;
			//
			this.rdoBagCheckOK.Checked = this._transfusionReaction.BagClericalChecksOkIndicator;
			this.rdoBagCheckFail.Checked = !this._transfusionReaction.BagClericalChecksOkIndicator;
			//
			this.grpBloodBagReturned.Enabled = true;
			this.rdoBloodBagReturned.Checked = this._transfusionReaction.BagReturnedIndicator;
			this.rdoBloodBagNotReturned.Checked = !this._transfusionReaction.BagReturnedIndicator;
			//
			this.cmbUnitHemolysis.SelectedIndex = GetHemolysisIndex(this._transfusionReaction.BagHemolysisInspectionCode);
			//
			this.btnAddUnit.Text = "&Update";
		}

		private bool IsUnitAlreadyImplicated()
		{
			foreach(ListViewItem lvi in this.lvImplicatedUnits.Items)
			{
				if (((BOL.PatientTransfusion)lvi.Tag).BloodUnitGuid == this._patientTransfusion.BloodUnitGuid)
				{
					return true;
				}
			}
			//
			return false;
		}

		private void btnClearUnit_Click(object sender, System.EventArgs e)
		{
			this.ClearImplicatedUnit();
		}

		private void lvImplicatedUnits_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			ListViewItem lvi = this.lvImplicatedUnits.Items[e.Index];
			if (e.NewValue == CheckState.Checked)
			{
				lvi.ForeColor = Color.FromKnownColor(KnownColor.ControlText);
			}
			else
			{
				lvi.ForeColor = Color.FromKnownColor(KnownColor.GrayText);
			}
			//
			if ((e.NewValue == CheckState.Checked) || (this.lvImplicatedUnits.CheckedItems.Count>1))
			{
				this.btnUnitsOK.EnabledButton = true;
			}
			else
			{
				this.btnUnitsOK.EnabledButton = false;
			}
		}

		private void LoadSavedImplicatedUnits()
		{
			if ((this._implicatedTransfusionRecords != null) && (this._implicatedTransfusionRecords.Count>0))
			{
				this.rdoImplicatedUnitsIdentified.Checked = true;
				//
				foreach(BOL.BloodUnit unit in this._implicatedTransfusionRecords)
				{
					foreach(BOL.PatientTransfusion transfusion in this._patientTransfusions)
					{
						if (transfusion.BloodUnitGuid == unit.BloodUnitGuid)
						{
							//
							foreach(BOL.PatientTransfusionComment comment in this._patientTransfusionReactionComments)
							{
								if (comment.PatientTransfusionGuid == transfusion.PatientTransfusionGuid)
								{
									this._implicatedUnitComments.Add(comment);
								}
							}
							//
							this.AddImplicatedUnit(transfusion);
							break;
						}
					}
				}
			}
			else
			{
				this.rdoNoImplicatedUnitsIdentified.Checked = true;
			}
		}

		private void cmbUnitHemolysis_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if ((this._patientTransfusion != null) && (this._transfusionReaction != null))
			{
				if (this.cmbUnitHemolysis.SelectedIndex>-1)
				{
					this._transfusionReaction.BagHemolysisInspectionCode = ((ArrayList)this._hemolysisInspections[this.cmbUnitHemolysis.SelectedIndex])[0].ToString();
				}
				else
				{
					this._transfusionReaction.BagHemolysisInspectionCode = "";
				}
			}
			//
			this.CheckImplicatedUnitValid();
		}

		private void ClericalCheckChanged(object sender, System.EventArgs e)
		{
			if (this.rdoBagCheckOK.Checked)
			{
				this._transfusionReaction.BagClericalChecksOkIndicator = true;
				this.IsDirty = true;
				this.lblBagComment.Text = "Comment";
			}
			else if (this.rdoBagCheckFail.Checked)
			{
				this._transfusionReaction.BagClericalChecksOkIndicator = false;
				this.IsDirty = true;
				this.lblBagComment.Text = "Comment*";
			}
			//
			this.CheckImplicatedUnitValid();
		}

		private void lvImplicatedUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 4)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,this.lvImplicatedUnits.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,this.lvImplicatedUnits.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void lvImplicatedUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvImplicatedUnits.SelectedItems.Count>0)
			{
				LoadImplicatedUnit((BOL.PatientTransfusion)this.lvImplicatedUnits.SelectedItems[0].Tag);
			}
		}

		private void SaveImplicatedUnits(object sender, System.EventArgs e)
		{
			bool success;
			//
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("implicated unit")) != DialogResult.Yes)
			{
				return;
			}
			try
			{
				using (new WaitCursor())
				{
					if (this.rdoNoImplicatedUnitsIdentified.Checked)
					{
						success = this._patientTransfusionReaction.SaveImplicatedBloodUnits(new ArrayList(),new ArrayList(),null);
						//
						if (!success)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("implicated units"));
							return;
						}
					}
					else
					{
						//this._patientTransfusions = new ArrayList(this.lvImplicatedUnits.CheckedItems.Count);
						ArrayList transfusionReactions = new ArrayList(this.lvImplicatedUnits.CheckedItems.Count);
						ArrayList implicatedUnitComments = new ArrayList();
						//
						DataTable unitClericalCheckExceptions = null;
						//
						foreach(ListViewItem lvi in this.lvImplicatedUnits.CheckedItems)
						{
							BOL.PatientTransfusion trans = (BOL.PatientTransfusion)lvi.Tag;
							//this._patientTransfusions.Add(trans);
							foreach(BOL.TransfusionReaction reaction in this._transfusionReactions)
							{
								if (reaction.PatientTransfusionGuid == trans.PatientTransfusionGuid)
								{
									transfusionReactions.Add(reaction);
									//
									foreach(BOL.PatientTransfusionComment comment in this._implicatedUnitComments)
									{
										if (comment.PatientTransfusionGuid == reaction.PatientTransfusionGuid)
										{
											if ((comment.CannedCommentGuid != Guid.Empty) || (comment.PatientTransfusionCommentText.Length>0))
											{
												if ((comment.CommentCategoryCode == "TB") && (!reaction.BagReturnedIndicator))
												{
													implicatedUnitComments.Add(comment);
												}
												else if (comment.CommentCategoryCode == "TC")
												{
													implicatedUnitComments.Add(comment);
													//
													if (!reaction.BagClericalChecksOkIndicator)
													{
														//If clerical checks failed.. create exception report entry
														BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.Transfusion_Reaction_Workup, BOL.CannedComment.CombinedComment(comment.CannedCommentGuid, comment.PatientTransfusionCommentText), Common.LogonUser.LogonUserName);
														exRep.GenerateExceptionTrwUnitClericalCheckFailed(this._patientTransfusionReaction,this._orderedTest.Patient,new BOL.BloodUnit(trans.BloodUnitGuid),reaction);

														if (unitClericalCheckExceptions == null)
														{
															unitClericalCheckExceptions = exRep.ExceptionData.Table.Clone();
														}
														unitClericalCheckExceptions.Rows.Add(exRep.ExceptionData.ItemArray);
													}
												}
											}
										}
									}
									//
									break;
								}
							}
						}
						//
						success = this._patientTransfusionReaction.SaveImplicatedBloodUnits(transfusionReactions,implicatedUnitComments,unitClericalCheckExceptions);
						//
						if (!success)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("implicated units"));
							return;
						}
					}
					//
					//Reload PTR record, to update RowVersions ready for possible new save...
					this.LoadInitialObjects();
                    if (this.LockController.LockingConflict) return;    //this is set if the lock fails, so need to get out
					//
					this.ClearImplicatedUnit();
					this.EnableImplicatedUnitControls(false);
					//
					this.IsDirty = false;
					this.AddTabPage(this.pageSymptoms);
					this.PopulateSymptomsTab();
				}
			}
			catch(Common.RowVersionException)
			{
				this.btnSymptomsOK.RowVersionException = true;		//CR2077
				this.btnUnitsOK.RowVersionException = true;			//CR2077
				this.btnSpecimenOK.RowVersionException = true;		//CR2077
				this.btnTestsOK.RowVersionException = true;			//CR2077

				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}
			
		}

		private void btnUnitsOK_MouseHover(object sender, System.EventArgs e)
		{
			StringBuilder tooltip = new StringBuilder();
			//
			if (this.rdoImplicatedUnitsIdentified.Checked)
			{
				if (this.lvImplicatedUnits.CheckedItems.Count<1)
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.IndicateImplicatedUnit().ResString+"\n");
				}
			}
			else if (this.rdoNoImplicatedUnitsIdentified.Checked)
			{
				//Nothing
			}
			else
			{
				tooltip.Append(Common.StrRes.Tooltips.UC021.ImplicatedUnits().ResString+"\n");
			}
			//
			if (tooltip.Length==0)
			{
				tooltip.Append(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			//
			this.btnUnitsOK.SetToolTip(tooltip.ToString());
		}

		private void btnAddUnit_MouseHover(object sender, System.EventArgs e)
		{
			StringBuilder tooltip = new StringBuilder();
			//
			if ((this._patientTransfusion == null) || (this._patientTransfusion.BloodUnitGuid == Guid.Empty))
			{
				tooltip.Append(Common.StrRes.Tooltips.UC021.ImplicatedUnitID().ResString+"\n");
			}
			if (!this.rdoBloodBagNotReturned.Checked && !this.rdoBloodBagReturned.Checked)
			{
				tooltip.Append(Common.StrRes.Tooltips.UC021.ImplicatedUnitBagReturned().ResString+"\n");
			}
			if (this.rdoBloodBagReturned.Checked)
			{
				if (this._transfusionReaction.BagHemolysisInspectionCode.Length == 0)
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ImplicatedUnitHemolysis().ResString+"\n");
				}
				//
				if (!this.rdoBagCheckOK.Checked && !this.rdoBagCheckFail.Checked)
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ImplicatedUnitClericalChecks().ResString+"\n");
				}
				//
				if (this.rdoBagCheckFail.Checked)
				{
					if (!this.IsCommentComplete(this.cmbBagComment,this.txtBagComment))
					{
						tooltip.Append(Common.StrRes.Tooltips.UC021.BagClericalCheckFailComment().ResString+"\n");
					}
				}
			}
			if (this.rdoBloodBagNotReturned.Checked)
			{
				if (!this.IsCommentComplete(this.cmbBagNotReturnedComment,this.txtBagNotReturnedComment))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ImplicatedUnitNoBagComment().ResString+"\n");
				}
			}
			//
			if (tooltip.Length==0)
			{
				tooltip.Append(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			//
			this.btnAddUnit.SetToolTip(tooltip.ToString());
		}

		private void BagClericalCheckCommentChanged(object sender, System.EventArgs e)
		{
			if (this._implicatedUnitClericalCheckComment != null)
			{
				if ((this.rdoBagCheckFail.Checked) && (this.cmbBagComment.SelectedIndex>-1) && (this.cmbBagComment.Text.ToUpper() == "OTHER"))
				{
					this.lblBagDetails.Text = "Details*";
				}
				else
				{
					this.lblBagDetails.Text = "Details";
				}
				//
				if (this.cmbBagComment.SelectedIndex>-1)
				{
					this._implicatedUnitClericalCheckComment.CannedCommentGuid = (Guid)this._clericalCheckComments.Rows[this.cmbBagComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
				}
				else
				{
					this._implicatedUnitClericalCheckComment.CannedCommentGuid = Guid.Empty;
				}
				//
				this._implicatedUnitClericalCheckComment.PatientTransfusionCommentText = this.txtBagComment.Text;
				//
				this.CheckImplicatedUnitValid();
			}
		}

		private void BagNotReturnedCommentChanged(object sender, System.EventArgs e)
		{
			if (this._implicatedUnitBagNotReturnedComment != null)
			{
				if ((this.rdoBloodBagNotReturned.Checked) && (this.cmbBagNotReturnedComment.SelectedIndex>-1) && (this.cmbBagNotReturnedComment.Text.ToUpper() == "OTHER"))
				{
					this.lblBagNotReturnedDetails.Text = "Details*";
				}
				else
				{
					this.lblBagNotReturnedDetails.Text = "Details";
				}
				//
				if (this.cmbBagNotReturnedComment.SelectedIndex>-1)
				{
					this._implicatedUnitBagNotReturnedComment.CannedCommentGuid = (Guid)this._bagNotReturnedComments.Rows[this.cmbBagNotReturnedComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid];
				}
				else
				{
					this._implicatedUnitBagNotReturnedComment.CannedCommentGuid = Guid.Empty;
				}
				//
				this._implicatedUnitBagNotReturnedComment.PatientTransfusionCommentText = this.txtBagNotReturnedComment.Text;
				//
				this.CheckImplicatedUnitValid();
			}
		}

		#endregion

		#region Symptoms Methods

		private void EnableSymptomsControls(bool enable)
		{
			this.rdoNoSymptomsIdentified.Enabled = enable;
			this.rdoSymptomsIdentified.Enabled = enable;
			//
			this.clbSymptoms.Enabled = enable;
			this.txtSymptomDetails.ReadOnly = !enable;
			//
			this.btnSymptomsOK.Enabled = enable;
			//
			this.btnSymptomsOK.EnabledButton = false;
		}

		private void ResetSymptoms()
		{
			this.rdoNoSymptomsIdentified.Checked = false;
			this.rdoSymptomsIdentified.Checked = false;
			//
			this.txtSymptomDetails.Text = "";
			//
			foreach(int checkedIndex in this.clbSymptoms.CheckedIndices)
			{
				this.clbSymptoms.SetItemChecked(checkedIndex,false);
			}
		}

		private void PopulateSymptomsTab()
		{
			if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.SymptomsComplete)
			{
				this.AddTabPage(this.pageSymptoms);
				//
				LoadSavedSymptoms();
				//
				this.EnableSymptomsControls(false);
			}
			else if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.ImplicatedUnitsComplete)
			{
				this.AddTabPage(this.pageSymptoms);
				//
				this.EnableSymptomsControls(true);
				this.ResetSymptoms();
			}
			//
			this.lblCompleteMessage3.Visible = ((int)this._patientTransfusionReaction.PartialSaveId == (int)Common.PatientTransfusionPartialSaveId.SerologicTestsComplete);
		}

		private void LoadSavedSymptoms()
		{
			ArrayList savedSymptoms = this._patientTransfusionReaction.GetSymtoms();
			//
			if ((savedSymptoms != null) && (savedSymptoms.Count>0))
			{
				this.rdoSymptomsIdentified.Checked = true;
				//
				foreach(ArrayList symptom in savedSymptoms)
				{
					Int16 id = System.Convert.ToInt16(symptom[0]);
					//
					for(int i =0; i< this._patientSymptoms.Count; i++)
					{
						Int16 symptomId = System.Convert.ToInt16(((ArrayList)this._patientSymptoms[i])[0]);
						if (symptomId == id)
						{
							this.clbSymptoms.SetItemChecked(i,true);
							break;
						}
					}
				}
			}
			//
			if (this._patientTransfusionReactionComments != null)
			{
				foreach(BOL.PatientTransfusionComment comment in this._patientTransfusionReactionComments)
				{
					if (comment.CommentCategoryCode == "T4")
					{
						this.txtSymptomDetails.Text = comment.PatientTransfusionCommentText;
						break;
					}
				}
			}
			//
			this.btnSymptomsOK.EnabledButton = false;
		}
		
		private void SymptomDetailsChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			//
			this.CheckSymptomsValid();
		}

		private void SymptomsChecked(object sender, System.EventArgs e)
		{
			this.grpSymptoms.Visible = this.rdoSymptomsIdentified.Checked;
			this.IsDirty = true;
			//
			this.CheckSymptomsValid();
		}

		private void CheckSymptomsValid()
		{
			if (!this.rdoSymptomsIdentified.Checked && !this.rdoNoSymptomsIdentified.Checked)
			{
				this.btnSymptomsOK.EnabledButton = false;
				return;
			}
			if (this.rdoSymptomsIdentified.Checked)
			{
				if (this._isSymptomCommentRequired && (this.txtSymptomDetails.Text.Trim().Length == 0))
				{
					this.btnSymptomsOK.EnabledButton = false;
					return;
				}
				if (this.clbSymptoms.CheckedItems.Count==0)
				{
					this.btnSymptomsOK.EnabledButton = false;
					return;
				}
			}
			//
			this.btnSymptomsOK.EnabledButton = true;
		}

		private void PatientSymptomsChanging(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (e.Index == this._otherSymptomIndex)
			{
				if (e.NewValue == CheckState.Checked)
				{
					this.lblSymptomDetails.Text = "Other Details*";
					this._isSymptomCommentRequired = true;
				}
				else
				{
					this.lblSymptomDetails.Text = "Other Details";
					this._isSymptomCommentRequired = false;
				}
			}
			//
			if ((e.NewValue == CheckState.Checked) || (this.clbSymptoms.CheckedItems.Count>1))
			{
				if (this._isSymptomCommentRequired && (this.txtSymptomDetails.Text.Trim().Length == 0))
				{
					this.btnSymptomsOK.EnabledButton = false;
				}
				else
				{
					this.btnSymptomsOK.EnabledButton = true;
				}
			}
			else
			{
				this.btnSymptomsOK.EnabledButton = false;
			}
		}

		private void SaveSymptoms(object sender, System.EventArgs e)
		{
			bool success;
			//
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("symptom")) != DialogResult.Yes)
			{
				return;
			}
			try
			{
				using (new WaitCursor())
				{
					ArrayList patientSymptoms = new ArrayList(this.clbSymptoms.CheckedItems.Count);
					//
					foreach(int checkedIndex in this.clbSymptoms.CheckedIndices)
					{
						patientSymptoms.Add(this._patientSymptoms[checkedIndex]);
					}
					//
					BOL.PatientTransfusionComment comment = this.GetTransfusionComment("T4",Guid.Empty,this.txtSymptomDetails.Text);
					//
					success = this._patientTransfusionReaction.SaveSymptoms(patientSymptoms,comment);
					//
					if (!success)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("symptoms"));
						return;
					}
					//
					//Reload PTR record, to update RowVersion ready for possible new save...
					this.LoadInitialObjects();
                    if (this.LockController.LockingConflict) return;    //this is set if the lock fails, so need to get out
					//
					LoadInterps();
					//
					this.EnableSymptomsControls(false);
					//
					this.IsDirty = false;
					this.AddTabPage(this.pageSerolgicTests);
					//
					//If no implicated units and no specimen info, disable Serologic Tests tab.
					if (((this._implicatedTransfusionRecords.Count == 0) && (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator) && (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)))
					{
						//No tests are possible if no implicated units and no specimens available.. so complete the TRW.
						success = this._patientTransfusionReaction.SaveSerologicTests(new ArrayList(), new ArrayList(), new ArrayList(),this._orderedTest,null,this._alWorkloadProcessIds);
						//
						if (!success)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("TRW task status"));
							return;
						}
						//
						//Reload PTR record, to update RowVersions ready for possible new save...
						this.LoadInitialObjects();
                        if (this.LockController.LockingConflict) return;    //this is set if the lock fails, so need to get out
						//
						this.EnableSerologicTestControls(false);
						this.btnFinalizePrint.EnabledButton = true;
						this.btnInvalidateTRW.EnabledButton = false;
					}
					else
					{
						this.PopulateSerologicTestsTab();
					}
				}
			}
			catch(Common.RowVersionException)
			{
				this.btnSymptomsOK.RowVersionException = true;		//CR2077
				this.btnUnitsOK.RowVersionException = true;			//CR2077
				this.btnSpecimenOK.RowVersionException = true;		//CR2077
				this.btnTestsOK.RowVersionException = true;			//CR2077

				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}
			
		}

		private void btnSymptomsOK_MouseHover(object sender, System.EventArgs e)
		{
			StringBuilder tooltip = new StringBuilder();
			//
			if (this.rdoSymptomsIdentified.Checked)
			{
				if (this.clbSymptoms.CheckedItems.Count<1)
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.Symptoms().ResString+"\n");
				}
				if (this._isSymptomCommentRequired && (this.txtSymptomDetails.Text.Trim().Length == 0))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.FreeTextSymptom().ResString+"\n");
				}
			}
			else if (this.rdoNoSymptomsIdentified.Checked)
			{
				//Nothing
			}
			else
			{
				tooltip.Append(Common.StrRes.Tooltips.UC021.IndicateSymptoms().ResString+"\n");
			}
			//
			if (tooltip.Length==0)
			{
				tooltip.Append(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			//
			this.btnSymptomsOK.SetToolTip(tooltip.ToString());
		}

		#endregion

		#region Serologic Test Methods

		private void EnableSerologicTestControls(bool enable)
		{
			this.dtpDateTested.Enabled = enable;
			this.cmbTestedBy.Enabled = enable;
			//
			if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
			{
				this.cmbRack.Enabled = enable;
				this.cbAutomatedInstrument.Enabled = enable;
				this.grpAutomatedInstrument.Enabled = (((int)this._patientTransfusionReaction.PartialSaveId < (int)Common.PatientTransfusionPartialSaveId.SerologicTestsComplete) && (this.cbAutomatedInstrument.Checked));
			}
			else
			{
				//Always disabled for Transfusion-Only facilities
				this.cmbRack.Enabled = false;
				this.cbAutomatedInstrument.Enabled = false;
				this.grpAutomatedInstrument.Enabled = false;
			}
			//
			this.cmbTestComment.Enabled = enable;
			this.txtTestDetails.Enabled = enable;
			//
			this.cbABORh.Enabled = enable;
			this.pnlABO.Enabled = enable;
			this.pnlRh.Enabled = enable;
			//
			this.cbABS.Enabled = enable;
			this.cmbPreABSInterp.Enabled = enable;
			this.cmbPostABSInterp.Enabled = enable;
			//
			this.cbDAT.Enabled = enable;
			this.cmbPreDATInterp.Enabled = enable;
			this.cmbPostDATInterp.Enabled = enable;
			//
			this.cbXM.Enabled = enable;
			this.pnlPreXM.Enabled = enable;
			this.pnlPostXM.Enabled = enable;
			//
			this.btnTestsOK.Enabled = enable;
			//
			this.btnTestsOK.EnabledButton = enable;
		}

		private void ResetSerologicTests()
		{
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpDateTested.MaxDate = currentDate;
			this.dtpDateTested.Value = currentDate;
			//
			this.cmbTestedBy.Text = ThisUser.UserName;
			//
			this.cmbRack.Text = "";
			this.cmbRack.SelectedIndex = -1;
			//
			this.txtInstrumentName.Text = "";
			//
			this.cbABORh.Checked = false;
			this.cmbPreABOInterp.Text = "";
			this.cmbPreABOInterp.SelectedIndex = -1;
			this.cmbPreRhInterp.Text = "";
			this.cmbPreRhInterp.SelectedIndex = -1;
			this.cmbPostABOInterp.Text = "";
			this.cmbPostABOInterp.SelectedIndex = -1;
			this.cmbPostRhInterp.Text = "";
			this.cmbPostRhInterp.SelectedIndex = -1;
			//
			this.cbABS.Checked = false;
			this.cmbPreABSInterp.Text = "";
			this.cmbPreABSInterp.SelectedIndex = -1;
			this.cmbPostABSInterp.Text = "";
			this.cmbPostABSInterp.SelectedIndex = -1;
			//
			this.cbDAT.Checked = false;
			this.cmbPreDATInterp.Text = "";
			this.cmbPreDATInterp.SelectedIndex = -1;
			this.cmbPostDATInterp.Text = "";
			this.cmbPostDATInterp.SelectedIndex = -1;
			//
			this.cbXM.Checked = false;
			//
			this.EnableTestingDetailsControls(false);
		}

		private void XMPanelResized(object sender, System.EventArgs e)
		{
			this.pnlXMMiddle.Width = (int)((this.pnlXM.Width - this.pnlXMLabels.Width)/2);
		}

		private void PopulateSerologicTestsTab()
		{
			if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.SerologicTestsComplete)
			{
				this.AddTabPage(this.pageSerolgicTests);
				//
				LoadInterps();
				DisplaySerologicTestsForImplicatedUnits(this._implicatedTransfusionRecords);
				//
				LoadSavedTestInterps();
				//
				this.EnableSerologicTestControls(false);
				//
				this.btnFinalizePrint.EnabledButton = true;
			}
			else if ((int)this._patientTransfusionReaction.PartialSaveId >= (int)Common.PatientTransfusionPartialSaveId.SymptomsComplete)
			{
				this.AddTabPage(this.pageSerolgicTests);
				//
				DisplaySerologicTestsForImplicatedUnits(this._implicatedTransfusionRecords);
				//
				this.EnableSerologicTestControls(true);
				this.ResetSerologicTests();
			}
			//
			this.lblCompleteMessage4.Visible = ((int)this._patientTransfusionReaction.PartialSaveId == (int)Common.PatientTransfusionPartialSaveId.SerologicTestsComplete);
		}

		private void LoadSavedTestInterps()
		{
			ArrayList bloodUnitTests = this._patientTransfusionReaction.GetSerologicBloodUnitTests();
			ArrayList specimenTests = this._patientTransfusionReaction.GetSerologicSpecimenTests();
			//
			if (specimenTests.Count>0)
			{
				DataRow test = (DataRow)specimenTests[0];
				this.dtpDateTested.Value = System.Convert.ToDateTime(test[Common.VbecsTables.SpecimenTest.TestDate]);
				this.cmbTestedBy.Text = test[Common.VbecsTables.SpecimenTest.TestTechId].ToString();
				//
				//Only applicable for full-service
				if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
				{
					this.cmbRack.Text = test[Common.VbecsTables.Rack.RackName].ToString().Trim();
					this.cbAutomatedInstrument.Checked = (test[Common.VbecsTables.SpecimenTest.AutoInstrumentName].ToString().Trim().Length>0);
					this.txtInstrumentName.Text = test[Common.VbecsTables.SpecimenTest.AutoInstrumentName].ToString();
					this.cbInstrumentQCd.Checked = Convert.ToBoolean(test[Common.VbecsTables.SpecimenTest.AutoInstrumentQCIndicator]);
				}
				else
				{
					this.cmbRack.SelectedIndex = -1;
					this.cbAutomatedInstrument.Checked = false;
					this.cbInstrumentQCd.Checked = false;
				}
			}
			else if (bloodUnitTests.Count>0)
			{
				DataRow test = (DataRow)bloodUnitTests[0];
				this.dtpDateTested.Value = System.Convert.ToDateTime(test[Common.VbecsTables.BloodUnitTest.TestDate]);
				this.cmbTestedBy.Text = test[Common.VbecsTables.BloodUnitTest.TestTechId].ToString();
				//
				//Only applicable for full-service
				if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
				{
					this.cmbRack.Text = test[Common.VbecsTables.Rack.RackName].ToString().Trim();
					this.cbAutomatedInstrument.Checked = (test[Common.VbecsTables.BloodUnitTest.AutoInstrumentName].ToString().Trim().Length>0);
					this.txtInstrumentName.Text = test[Common.VbecsTables.BloodUnitTest.AutoInstrumentName].ToString();
					//TODO: Need AutoInstrumentQCIndicator on BloodUnitTest.
					this.cbInstrumentQCd.Checked = false;//(test[Common.VbecsTables.BloodUnitTest.AutoInstrumentName].ToString().Trim().Length>0);
				}
				else
				{
					this.cmbRack.SelectedIndex = -1;
					this.cbAutomatedInstrument.Checked = false;
					this.cbInstrumentQCd.Checked = false;
				}
			}
			else
			{
				//hide default selections, no tests were saved...
				this.dtpDateTested.CustomFormat = " ";
				this.cmbRack.SelectedIndex = -1;
				this.cmbTestedBy.SelectedIndex = -1;
				this.cbAutomatedInstrument.Checked = false;
				this.cbInstrumentQCd.Checked = false;
			}
			//
			foreach(DataRow test in specimenTests)
			{
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 105)
				{
					if (this._patientTransfusionReaction.PreSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PreSpecimenGuid)
						{
							this._preSpecimenAboTest = new BOL.SpecimenTest();
							this.cmbPreABOInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
					//
					if (this._patientTransfusionReaction.PostSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PostSpecimenGuid)
						{
							this._postSpecimenAboTest = new BOL.SpecimenTest();
							this.cmbPostABOInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 106)
				{
					if (this._patientTransfusionReaction.PreSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PreSpecimenGuid)
						{
							this._preSpecimenRhTest = new BOL.SpecimenTest();
							this.cmbPreRhInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
					//
					if (this._patientTransfusionReaction.PostSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PostSpecimenGuid)
						{
							this._postSpecimenRhTest = new BOL.SpecimenTest();
							this.cmbPostRhInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 107)
				{
					if (this._patientTransfusionReaction.PreSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PreSpecimenGuid)
						{
							this._preSpecimenAbsTest = new BOL.SpecimenTest();
							this.cmbPreABSInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
					//
					if (this._patientTransfusionReaction.PostSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PostSpecimenGuid)
						{
							this._postSpecimenAbsTest = new BOL.SpecimenTest();
							this.cmbPostABSInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 108)
				{
					if (this._patientTransfusionReaction.PreSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PreSpecimenGuid)
						{
							this._preSpecimenDatTest = new BOL.SpecimenTest();
							this.cmbPreDATInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
					//
					if (this._patientTransfusionReaction.PostSpecimenGuid != Guid.Empty)
					{
						if ((Guid)test[Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid] == this._patientTransfusionReaction.PostSpecimenGuid)
						{
							this._postSpecimenDatTest = new BOL.SpecimenTest();
							this.cmbPostDATInterp.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
							continue;
						}
					}
				}

			}
			//
			//Build unit test array before populating, otherwise IndexChanged event will create havoc
			foreach(DataRow test in bloodUnitTests)
			{
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 105)
				{
					if (this._unitAboTests == null)
					{
						this._unitAboTests = new ArrayList();
					}
					this._unitAboTests.Add(new BOL.BloodUnitTest(System.Guid.Empty, 105));
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 106)
				{
					if (this._unitRhTests == null)
					{
						this._unitRhTests = new ArrayList();
					}
					this._unitRhTests.Add(new BOL.BloodUnitTest(System.Guid.Empty, 106));
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 109)
				{
					if (this._preSpecimenXMTests == null)
					{
						this._preSpecimenXMTests = new ArrayList();
					}
					this._preSpecimenXMTests.Add(new BOL.BloodUnitTest(System.Guid.Empty, 109));
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 110)
				{
					if (this._postSpecimenXMTests == null)
					{
						this._postSpecimenXMTests = new ArrayList();
					}
					this._postSpecimenXMTests.Add(new BOL.BloodUnitTest(System.Guid.Empty, 110));
				}
			}
			//
			foreach(DataRow test in bloodUnitTests)
			{
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 105)
				{
					foreach(controls.ComboBoxLookup cmb in this.pnlABO.Controls)
					{
						if (cmb.Name.StartsWith("cmbUnitABOInterp"))
						{
							BOL.BloodUnit unit = (BOL.BloodUnit)cmb.Tag;
							//
							if (unit.BloodUnitGuid == (Guid)test[Common.VbecsTables.BloodUnit.BloodUnitGuid])
							{
								cmb.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
								break;
							}
						}
					}
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 106)
				{
					
					foreach(controls.ComboBoxLookup cmb in this.pnlRh.Controls)
					{
						if (cmb.Name.StartsWith("cmbUnitRhInterp"))
						{
							BOL.BloodUnit unit = (BOL.BloodUnit)cmb.Tag;
							//
							if (unit.BloodUnitGuid == (Guid)test[Common.VbecsTables.BloodUnit.BloodUnitGuid])
							{
								cmb.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
								break;
							}
						}
					}
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 109)
				{
					foreach(controls.ComboBoxLookup cmb in this.pnlPreXM.Controls)
					{
						if (cmb.Name.StartsWith("cmbUnitPreXMInterp"))
						{
							BOL.BloodUnit unit = (BOL.BloodUnit)cmb.Tag;
							//
							if (unit.BloodUnitGuid == (Guid)test[Common.VbecsTables.BloodUnit.BloodUnitGuid])
							{
								cmb.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
								break;
							}
						}
					}
				}
				//
				if (Convert.ToInt32(test[Common.VbecsTables.BloodTestType.BloodTestTypeId]) == 110)
				{
					foreach(controls.ComboBoxLookup cmb in this.pnlPostXM.Controls)
					{
						if (cmb.Name.StartsWith("cmbUnitPostXMInterp"))
						{
							BOL.BloodUnit unit = (BOL.BloodUnit)cmb.Tag;
							//
							if (unit.BloodUnitGuid == (Guid)test[Common.VbecsTables.BloodUnit.BloodUnitGuid])
							{
								cmb.Text = test[Common.VbecsTables.TestResult.TestResultText].ToString();
								break;
							}
						}
					}
				}
			}
			//
			this.cbABORh.Checked = ((this._preSpecimenAboTest != null) || (this._postSpecimenAboTest != null) || (this._unitAboTests != null) || (this._unitRhTests != null));
			this.cbABS.Checked = ((this._preSpecimenAbsTest != null) || (this._postSpecimenAbsTest != null));
			this.cbDAT.Checked = ((this._preSpecimenDatTest != null) || (this._postSpecimenDatTest != null));
			this.cbXM.Checked = ((this._preSpecimenXMTests != null) || (this._postSpecimenXMTests != null));
		}

		private void ABORhChecked(object sender, System.EventArgs e)
		{
			this.grpABORh.Enabled = this.cbABORh.Checked;
			this.EnableTestingDetailsControls(this.cbABORh.Checked || this.cbABS.Checked || this.cbDAT.Checked || this.cbXM.Checked);
			this.IsDirty = true;
			//
			if (this.cbABORh.Checked)
			{
				if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator)
				{
					this.cmbPreABOInterp.Enabled = false;
					this.cmbPreRhInterp.Enabled = false;
					//
					this._preSpecimenAboTest = null;
					this._preSpecimenRhTest = null;
				}
				else
				{
					this.cmbPreABOInterp.Enabled = true;
					this.cmbPreRhInterp.Enabled = true;
					//
					this._preSpecimenAboTest = new BOL.SpecimenTest();
					this._preSpecimenAboTest.BloodTestType = new BOL.BloodTestType(105);
					this._preSpecimenRhTest = new BOL.SpecimenTest();
					this._preSpecimenRhTest.BloodTestType = new BOL.BloodTestType(106);
				}
				//
				if (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
				{
					this.cmbPostABOInterp.Enabled = false;
					this.cmbPostRhInterp.Enabled = false;
					//
					this._postSpecimenAboTest = null;
					this._postSpecimenRhTest = null;
				}
				else
				{
					this.cmbPostABOInterp.Enabled = true;
					this.cmbPostRhInterp.Enabled = true;
					//
					this._postSpecimenAboTest = new BOL.SpecimenTest();
					this._postSpecimenAboTest.BloodTestType = new BOL.BloodTestType(105);
					this._postSpecimenRhTest = new BOL.SpecimenTest();
					this._postSpecimenRhTest.BloodTestType = new BOL.BloodTestType(106);
				}
				//
				this._unitAboTests = new ArrayList();
				this._unitRhTests = new ArrayList();
				//
				foreach(BOL.BloodUnit unit in this._implicatedTransfusionRecords)
				{
					BOL.BloodUnitTest aboTest = new BOL.BloodUnitTest(unit.BloodUnitGuid, 105);
					aboTest.BloodUnit = unit;
					BOL.BloodUnitTest rhTest = new BOL.BloodUnitTest(unit.BloodUnitGuid, 106);
					rhTest.BloodUnit = unit;
					this._unitAboTests.Add(aboTest);
					this._unitRhTests.Add(rhTest);
				}
			}
			else
			{
				this._preSpecimenAboTest = null;
				this._postSpecimenAboTest = null;
				this._unitAboTests = null;
				//
				this._preSpecimenRhTest = null;
				this._postSpecimenRhTest = null;
				this._unitRhTests = null;
			}
			//
			this.IsTestingDetailsValid();
		}

		private void XMChecked(object sender, System.EventArgs e)
		{
			this.grpXM.Enabled = this.cbXM.Checked;
			this.EnableTestingDetailsControls(this.cbABORh.Checked || this.cbABS.Checked || this.cbDAT.Checked || this.cbXM.Checked);
			this.IsDirty = true;
			//
			if (this.cbXM.Checked)
			{
				if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator)
				{
					this._preSpecimenXMTests = null;
				}
				else
				{
					this._preSpecimenXMTests = new ArrayList();
					//
					foreach(BOL.BloodUnit unit in this._implicatedTransfusionRecords)
					{
						BOL.BloodUnitTest xmTest = new BOL.BloodUnitTest(unit.BloodUnitGuid, 109);
						xmTest.BloodUnit = unit;
						this._preSpecimenXMTests.Add(xmTest);
					}
				}
				//
				if (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
				{
					this._postSpecimenXMTests = null;
				}
				else
				{
					this._postSpecimenXMTests = new ArrayList();
					//
					foreach(BOL.BloodUnit unit in this._implicatedTransfusionRecords)
					{
						BOL.BloodUnitTest xmTest = new BOL.BloodUnitTest(unit.BloodUnitGuid, 110);
						xmTest.BloodUnit = unit;
						this._postSpecimenXMTests.Add(xmTest);
					}
				}
			}
			else
			{
				this._preSpecimenXMTests = null;
				this._postSpecimenXMTests = null;
			}
			//
			this.IsTestingDetailsValid();
		}

		private void ABSChecked(object sender, System.EventArgs e)
		{
			this.grpABS.Enabled = this.cbABS.Checked;
			this.EnableTestingDetailsControls(this.cbABORh.Checked || this.cbABS.Checked || this.cbDAT.Checked || this.cbXM.Checked);
			this.IsDirty = true;
			//
			if (this.cbABS.Checked)
			{
				if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator)
				{
					this.cmbPreABSInterp.Enabled = false;
					//
					this._preSpecimenAbsTest = null;
				}
				else
				{
					this.cmbPreABSInterp.Enabled = true;
					//
					this._preSpecimenAbsTest = new BOL.SpecimenTest();
					this._preSpecimenAbsTest.BloodTestType = new BOL.BloodTestType(107);
				}
				//
				if (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
				{
					this.cmbPostABSInterp.Enabled = false;
					//
					this._postSpecimenAbsTest = null;
				}
				else
				{
					this.cmbPostABSInterp.Enabled = true;
					//
					this._postSpecimenAbsTest = new BOL.SpecimenTest();
					this._postSpecimenAbsTest.BloodTestType = new BOL.BloodTestType(107);
				}
			}
			else
			{
				this._preSpecimenAbsTest = null;
				this._postSpecimenAbsTest = null;
			}
			//
			this.IsTestingDetailsValid();
		}

		private void DATChecked(object sender, System.EventArgs e)
		{
			this.grpDAT.Enabled = this.cbDAT.Checked;
			this.EnableTestingDetailsControls(this.cbABORh.Checked || this.cbABS.Checked || this.cbDAT.Checked || this.cbXM.Checked);
			this.IsDirty = true;
			//
			if (this.cbDAT.Checked)
			{
				if (this._patientTransfusionReaction.PreSpecimenNotAvailableIndicator)
				{
					this.cmbPreDATInterp.Enabled = false;
					//
					this._preSpecimenDatTest = null;
				}
				else
				{
					this.cmbPreDATInterp.Enabled = true;
					//
					this._preSpecimenDatTest = new BOL.SpecimenTest();
					this._preSpecimenDatTest.BloodTestType = new BOL.BloodTestType(108);
				}
				//
				if (this._patientTransfusionReaction.PostSpecimenNotAvailableIndicator)
				{
					this.cmbPostDATInterp.Enabled = false;
					//
					this._postSpecimenDatTest = null;
				}
				else
				{
					this.cmbPostDATInterp.Enabled = true;
					//
					this._postSpecimenDatTest = new BOL.SpecimenTest();
					this._postSpecimenDatTest.BloodTestType = new BOL.BloodTestType(108);
				}
			}
			else
			{
				this._preSpecimenDatTest = null;
				this._postSpecimenDatTest = null;
			}
			//
			this.IsTestingDetailsValid();
		}

		private void SaveSerologicTests(object sender, System.EventArgs e)
		{
			bool success;
			//
			if (GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("serologic test")) != DialogResult.Yes)
			{
				return;
			}
			//
			try
			{
				using (new WaitCursor())
				{
					ArrayList bloodUnitTests = new ArrayList();
					
					if (this._unitAboTests != null)
					{
						foreach(BOL.BloodUnitTest test in this._unitAboTests)
						{
							bloodUnitTests.Add(this.AddTestDetailsToBloodUnitTest(test));
						}
					}
					if (this._unitRhTests != null)
					{
						foreach(BOL.BloodUnitTest test in this._unitRhTests)
						{
							bloodUnitTests.Add(this.AddTestDetailsToBloodUnitTest(test));
						}
					}
					if (this._preSpecimenXMTests != null)
					{

						foreach(BOL.BloodUnitTest test in this._preSpecimenXMTests)
						{
							bloodUnitTests.Add(this.AddTestDetailsToBloodUnitTest(test));
							_alWorkloadProcessIds.Add(Common.WorkloadProcessID.CrossmatchUnitSerologicalCoombs);
						}
					}
					if (this._postSpecimenXMTests != null)
					{
						foreach(BOL.BloodUnitTest test in this._postSpecimenXMTests)
						{
							bloodUnitTests.Add(this.AddTestDetailsToBloodUnitTest(test));
							_alWorkloadProcessIds.Add(Common.WorkloadProcessID.CrossmatchUnitSerologicalCoombs);
						}
					}
					//
					ArrayList preSpecimenTests = new ArrayList();
					if (this._preSpecimenAboTest != null)
					{
						preSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._preSpecimenAboTest));
						_alWorkloadProcessIds.Add(Common.WorkloadProcessID.ABOForwardReverseTypingPatient);
					}
					if (this._preSpecimenRhTest != null)
					{
						preSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._preSpecimenRhTest));
					}
					if (this._preSpecimenAbsTest != null)
					{
						preSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._preSpecimenAbsTest));
						_alWorkloadProcessIds.Add(Common.WorkloadProcessID.AntibodyScreenPatient);
					}
					if (this._preSpecimenDatTest != null)
					{
						preSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._preSpecimenDatTest));
						_alWorkloadProcessIds.Add(Common.WorkloadProcessID.DirectAntiglobulinTestDAT);
					}
					//
					ArrayList postSpecimenTests = new ArrayList();
					if (this._postSpecimenAboTest != null)
					{
						postSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._postSpecimenAboTest));
						_alWorkloadProcessIds.Add(Common.WorkloadProcessID.ABOForwardReverseTypingPatient);
					}
					if (this._postSpecimenRhTest != null)
					{
						postSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._postSpecimenRhTest));
					}
					if (this._postSpecimenAbsTest != null)
					{
						postSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._postSpecimenAbsTest));
						_alWorkloadProcessIds.Add(Common.WorkloadProcessID.AntibodyScreenPatient);
					}
					if (this._postSpecimenDatTest != null)
					{
						postSpecimenTests.Add(this.AddTestDetailsToSpecimenTest(this._postSpecimenDatTest));
						_alWorkloadProcessIds.Add(Common.WorkloadProcessID.DirectAntiglobulinTestDAT);
					}
					bool bMsgNeeded = false;
					System.Data.DataTable dt = null;
					if(this._alWorkloadProcessIds != null)
					{
						foreach(Common.WorkloadProcessID workloadPID in this._alWorkloadProcessIds)
						{
							//CR 1441
							dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) workloadPID);
							if(dt!= null && workloadPID != Common.WorkloadProcessID.Unknown)
							{
								if(dt.Rows.Count == 0)
								{
									bMsgNeeded = true;
								}
							}
						}
					}
					if (bMsgNeeded) GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
					//
					success = this._patientTransfusionReaction.SaveSerologicTests(bloodUnitTests, postSpecimenTests, preSpecimenTests,this._orderedTest, _rackNotTestedExceptions, this._alWorkloadProcessIds);
					//
					if (!success)
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("TRW serologic tests"));
						return;
					}
					//
					//Reload PTR record, to update RowVersions ready for possible new save...
					this.LoadInitialObjects();
                    if (this.LockController.LockingConflict) return;    //this is set if the lock fails, so need to get out
					//
					this.EnableSerologicTestControls(false);
					//
					this.IsDirty = false;
					//
					this.btnFinalizePrint.EnabledButton = true;
					this.btnInvalidateTRW.EnabledButton = false;
					//
					this.lblCompleteMessage1.Visible = true;
					this.lblCompleteMessage2.Visible = true;
					this.lblCompleteMessage3.Visible = true;
					this.lblCompleteMessage4.Visible = true;
				}
			}
			catch(Common.RowVersionException)
			{
				this.btnSymptomsOK.RowVersionException = true;		//CR2077
				this.btnUnitsOK.RowVersionException = true;			//CR2077
				this.btnSpecimenOK.RowVersionException = true;		//CR2077
				this.btnTestsOK.RowVersionException = true;			//CR2077

				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}
		}

		private BOL.VbecsUser GetTestedByUserSelection()
		{
			return (VbecsUser)this.cmbTestedBy.SelectedItem;
		}

		private BOL.SpecimenTest AddTestDetailsToSpecimenTest(BOL.SpecimenTest specimenTest)
		{
			specimenTest.SpecimenTestGuid = Guid.NewGuid();
			specimenTest.OrderedTest = this._orderedTest;
			specimenTest.DivisionCode = LogonUser.LogonUserDivisionCode;
			//
			if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
			{
				if (this.cbAutomatedInstrument.Checked)
				{
					specimenTest.AutoInstrumentName = this.txtInstrumentName.Text;
				}
				else
				{
					specimenTest.AutoInstrumentName = null;
				}
				specimenTest.Rack = new BOL.Rack(this._racks.Rows[this.cmbRack.SelectedIndex]);
			}
			specimenTest.TestDate = this.dtpDateTested.Value;
			specimenTest.TestTechId = GetTestedByUserSelection().UserNTLoginID;
			if (this.cmbTestComment.SelectedIndex>-1)
			{
				specimenTest.TestComments = BOL.CannedComment.CombinedComment((Guid)this._testingComments.Rows[this.cmbTestComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid],this.txtTestDetails.Text.Trim());
			}
			else
			{
				specimenTest.TestComments = this.txtTestDetails.Text.Trim();
			}
			return specimenTest;
		}

		private BOL.BloodUnitTest AddTestDetailsToBloodUnitTest(BOL.BloodUnitTest bloodUnitTest)
		{
			bloodUnitTest.BloodUnitTestGuid = Guid.NewGuid();
			bloodUnitTest.OrderableTestId = this._orderedTest.OrderableTestId;
			//
			if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
			{
				if (this.cbAutomatedInstrument.Checked)
				{
					bloodUnitTest.AutoInstrumentName = this.txtInstrumentName.Text;
				}
				else
				{
					bloodUnitTest.AutoInstrumentName = null;
				}
				bloodUnitTest.Rack = new BOL.Rack(this._racks.Rows[this.cmbRack.SelectedIndex]);
			}
			bloodUnitTest.TestDate = this.dtpDateTested.Value;
			bloodUnitTest.TestTechId = GetTestedByUserSelection().UserNTLoginID;
			bloodUnitTest.EntryMethodCode = "M";
			if (this.cmbTestComment.SelectedIndex>-1)
			{
				bloodUnitTest.TestComments = BOL.CannedComment.CombinedComment((Guid)this._testingComments.Rows[this.cmbTestComment.SelectedIndex][Common.VbecsTables.CannedComment.CannedCommentGuid],this.txtTestDetails.Text.Trim());
			}
			else
			{
				bloodUnitTest.TestComments = this.txtTestDetails.Text.Trim();
			}
			return bloodUnitTest;
		}

		private void PreSpecimenAboInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPreABOInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._aboInterps[this.cmbPreABOInterp.SelectedIndex];
				this._preSpecimenAboTest.TestResult = result;
			}
			else
			{
				this._preSpecimenAboTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void PostSpecimenAboInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPostABOInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._aboInterps[this.cmbPostABOInterp.SelectedIndex];
				this._postSpecimenAboTest.TestResult = result;
			}
			else
			{
				this._postSpecimenAboTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void PreSpecimenRhInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPreRhInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._rhInterps[this.cmbPreRhInterp.SelectedIndex];
				this._preSpecimenRhTest.TestResult = result;
			}
			else
			{
				this._preSpecimenRhTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void PostSpecimenRhInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPostRhInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._rhInterps[this.cmbPostRhInterp.SelectedIndex];
				this._postSpecimenRhTest.TestResult = result;
			}
			else
			{
				this._postSpecimenRhTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void PreAbsInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPreABSInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._absInterps[this.cmbPreABSInterp.SelectedIndex];
				this._preSpecimenAbsTest.TestResult = result;
			}
			else
			{
				this._preSpecimenAbsTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void PostAbsInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPostABSInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._absInterps[this.cmbPostABSInterp.SelectedIndex];
				this._postSpecimenAbsTest.TestResult = result;
			}
			else
			{
				this._postSpecimenAbsTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void PreDatInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPreDATInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._datInterps[this.cmbPreDATInterp.SelectedIndex];
				this._preSpecimenDatTest.TestResult = result;
			}
			else
			{
				this._preSpecimenDatTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void PostDatInterpChanged(object sender, System.EventArgs e)
		{
			if (this.cmbPostDATInterp.SelectedIndex >- 1)
			{
				BOL.TestResult result = (BOL.TestResult)this._datInterps[this.cmbPostDATInterp.SelectedIndex];
				this._postSpecimenDatTest.TestResult = result;
			}
			else
			{
				this._postSpecimenDatTest.TestResult = null;
			}
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void XMInterpChanged(object sender, System.EventArgs e)
		{
			controls.ComboBoxLookup cmb = (controls.ComboBoxLookup)sender;
			int index;
			BOL.BloodUnitTest test;
			BOL.TestResult result;
			//
			if (cmb.Name.IndexOf("Pre")>-1)
			{
				index = (Convert.ToInt32(cmb.Name.Replace("cmbUnitPreXMInterp",""))-1);
				test = (BOL.BloodUnitTest)this._preSpecimenXMTests[index]; 
			}
			else
			{
				index = (Convert.ToInt32(cmb.Name.Replace("cmbUnitPostXMInterp",""))-1);
				test = (BOL.BloodUnitTest)this._postSpecimenXMTests[index]; 
			}
			//
			if (cmb.SelectedIndex > -1)
			{
				result = (BOL.TestResult)this._xmInterps[cmb.SelectedIndex];
				test.TestResult = result;
				test.TestResultId = result.TestResultId;
			}
			else
			{
				test.TestResult = null;
				test.TestResultId = "";
			}
			//
			this.IsTestingDetailsValid();
		}

		private void UnitAboRhInterpChanged(object sender, System.EventArgs e)
		{
			controls.ComboBoxLookup cmb = (controls.ComboBoxLookup)sender;
			int index;
			BOL.BloodUnitTest test;
			BOL.TestResult result;
			//
			if (cmb.Name.IndexOf("UnitABO")>-1)
			{
				index = (Convert.ToInt32(cmb.Name.Replace("cmbUnitABOInterp",""))-1);
				test = (BOL.BloodUnitTest)this._unitAboTests[index]; 
			}
			else
			{
				index = (Convert.ToInt32(cmb.Name.Replace("cmbUnitRhInterp",""))-1);
				test = (BOL.BloodUnitTest)this._unitRhTests[index]; 
			}
			//
			if (cmb.SelectedIndex>-1)
			{
				if (cmb.Name.IndexOf("UnitABO")>-1)
				{
					result = (BOL.TestResult)this._aboInterps[cmb.SelectedIndex];
				}
				else
				{
					result = (BOL.TestResult)this._rhInterps[cmb.SelectedIndex];
				}
				//
				test.TestResult = result;
				test.TestResultId = result.TestResultId;
			}
			else
			{
				test.TestResult = null;
				test.TestResultId = "";
			}
			//
			this.IsTestingDetailsValid();
		}

		private void DateTestedValueChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void EnableTestingDetailsControls(bool enable)
		{
			this.dtpDateTested.Enabled = enable;
			this.cmbTestedBy.Enabled = enable;
			if (ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator)
			{
				this.cmbRack.Enabled = enable;
				this.cbAutomatedInstrument.Enabled = enable;
			}
			else
			{
				//Never enabled for Transfusion-Only facilities
				this.cmbRack.Enabled = false;
				this.cbAutomatedInstrument.Enabled = false;
			}
			this.cmbTestComment.Enabled = enable;
			this.txtTestDetails.Enabled = enable;
		}

		private void IsTestingDetailsValid()
		{
			if (this.cbABORh.Checked || this.cbABS.Checked || this.cbDAT.Checked || this.cbXM.Checked)
			{
				if (this.dtpDateTested.Value > BOL.VBECSDateTime.GetDivisionCurrentDateTime())
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
				if (this.cmbTestedBy.SelectedIndex<0)
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
				if ((ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator) && (this.cmbRack.SelectedIndex<0))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
				if ((this.cbAutomatedInstrument.Checked)&&(this.txtInstrumentName.Text.Trim().Length == 0))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
				if (this.cmbTestComment.SelectedIndex > -1)
				{
					if ((this.txtTestDetails.Text.Trim().Length == 0)&&(this.cmbTestComment.SelectedItem.ToString().ToUpper() == "OTHER"))
					{
						this.btnTestsOK.EnabledButton = false;
						return;
					}
				}
			}
			//
			if (this.cbABORh.Checked)
			{
				if (!this.IsTestingInterpsValid(this.pnlABO))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
				//
				if (!this.IsTestingInterpsValid(this.pnlRh))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
			}
			//
			if (this.cbABS.Checked)
			{
				if (!this.IsTestingInterpsValid(this.pnlABS))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
			}
			//
			if (this.cbDAT.Checked)
			{
				if (!this.IsTestingInterpsValid(this.pnlDAT))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
			}
			//
			if (this.cbXM.Checked)
			{
				if (!this.IsTestingInterpsValid(this.pnlPreXM))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
				//
				if (!this.IsTestingInterpsValid(this.pnlPostXM))
				{
					this.btnTestsOK.EnabledButton = false;
					return;
				}
			}
			//
			this.btnTestsOK.EnabledButton = true;
		}

		private bool IsTestingInterpsValid(Panel controlPanel)
		{
			foreach(Control ctrl in controlPanel.Controls)
			{
				if (ctrl.GetType() == typeof(gov.va.med.vbecs.GUI.controls.ComboBoxLookup))
				{
					if ((ctrl.Enabled) && (((ComboBox)ctrl).SelectedIndex<0))
					{
						return false;
					}
				}
			}
			//
			return true;
		}

		private void cmbTestedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void cmbRack_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void txtInstrumentName_TextChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void btnTestsOK_MouseHover(object sender, System.EventArgs e)
		{
			StringBuilder tooltip = new StringBuilder();
			//
			if (this.cbABORh.Checked || this.cbABS.Checked || this.cbDAT.Checked || this.cbXM.Checked)
			{
				if (this.dtpDateTested.Value > BOL.VBECSDateTime.GetDivisionCurrentDateTime())
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.DateTested().ResString+"\n");
				}
				if (this.cmbTestedBy.SelectedIndex<0)
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.TestedBy().ResString+"\n");
				}
				if ((ThisUser.CurrentDivisionRole.Division.ServiceTypeIndicator) && (this.cmbRack.SelectedIndex<0))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.Rack().ResString+"\n");
				}
				if ((this.cbAutomatedInstrument.Checked)&&(this.txtInstrumentName.Text.Trim().Length == 0))
				{
					tooltip.Append("Automated instrument name must be entered\n");
				}
				if (this.cmbTestComment.SelectedIndex > -1)
				{
					if ((this.txtTestDetails.Text.Trim().Length == 0)&&(this.cmbTestComment.SelectedItem.ToString().ToUpper() == "OTHER"))
					{
						tooltip.Append("Free-text details are required when a comment of 'Other' is selected\n");
					}
				}
			}
			//
			if (this.cbABORh.Checked)
			{
				if (!this.IsTestingInterpsValid(this.pnlABO))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ValidAboInterps().ResString+"\n");
				}
				//
				if (!this.IsTestingInterpsValid(this.pnlRh))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ValidRHInterps().ResString+"\n");
				}
			}
			//
			if (this.cbABS.Checked)
			{
				if (!this.IsTestingInterpsValid(this.pnlABS))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ValidAbsInterps().ResString+"\n");
				}
			}
			//
			if (this.cbDAT.Checked)
			{
				if (!this.IsTestingInterpsValid(this.pnlDAT))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ValidDatInterps().ResString+"\n");
				}
			}
			//
			if (this.cbXM.Checked)
			{
				if ((!this.IsTestingInterpsValid(this.pnlPreXM))||(!this.IsTestingInterpsValid(this.pnlPostXM)))
				{
					tooltip.Append(Common.StrRes.Tooltips.UC021.ValidXMInterps().ResString+"\n");
				}
			}
			//
			if (tooltip.Length==0)
			{
				tooltip.Append(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			//
			this.btnTestsOK.SetToolTip(tooltip.ToString());
		}

		#endregion

		private void btnFinalizePrint_Click(object sender, System.EventArgs e)
		{
			using (new WaitCursor())
			{
				FrmGenerateTrwReport frm = new FrmGenerateTrwReport(this._patientTransfusionReaction.OrderedTestGuid, this._patientTransfusionReaction.PatientTransfusionReactionGuid, this._patientTransfusionReaction.PartialSaveId);
				frm.MdiParent = this.MdiParent;
                //
				frm.ShowFromLockedParent(this,true);         //Locking2.0 - used to be Show()
				//
				this.Close();
			}
		}

		private void cmbTestComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.cmbTestComment.SelectedIndex>-1)
			{
				if (this.cmbTestComment.SelectedItem.ToString().ToUpper()=="OTHER")
				{
					this.lblTestDetails.Text = "Details*";
				}
				else
				{
					this.lblTestDetails.Text = "Details";
				}
			}
			else
			{
				this.lblTestDetails.Text = "Details";
			}
			//
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void cbAutomatedInstrument_CheckedChanged(object sender, System.EventArgs e)
		{
			this.grpAutomatedInstrument.Enabled = (((int)this._patientTransfusionReaction.PartialSaveId < (int)Common.PatientTransfusionPartialSaveId.SerologicTestsComplete) && (this.cbAutomatedInstrument.Checked));
			//
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void cbInstrumentQCd_CheckedChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void txtTestDetails_TextChanged(object sender, System.EventArgs e)
		{
			this.IsDirty = true;
			//
			this.IsTestingDetailsValid();
		}

		private void cmbRack_Leave(object sender, System.EventArgs e)
		{
			_rackNotTestedExceptions = null;
			//
			if (this.cmbRack.SelectedIndex>-1)
			{
				if (this.cbABORh.Checked || this.cbABS.Checked || this.cbDAT.Checked || this.cbXM.Checked)
				{
					BOL.Rack rack = new BOL.Rack(this._racks.Rows[this.cmbRack.SelectedIndex]);
					bool notTested = !rack.IsRackQCd(this.dtpDateTested.Value);

					if (notTested)
					{
						DlgOverrideComment dlg = new DlgOverrideComment("QC not performed", "Rack QC not performed. Continue to use?", "PT");
                        dlg.ShowDialogFromLockedParent(this, false);
                        if (dlg.DialogResult != DialogResult.OK)
						{
							this.cmbRack.Focus();
							return;
						}
						BOL.ExceptionReport exRep = new BOL.ExceptionReport(Common.ExceptionType.QC_not_performed_on_rack_used_for_testing, dlg.Comment, Common.LogonUser.LogonUserName);
						exRep.GenerateExceptionQCNotPerformed(this._orderedTest.Patient, this._orderedTest.Specimen, rack.RackName, GetTestedByUserSelection().UserName );
						//
						if (_rackNotTestedExceptions == null)
						{
							_rackNotTestedExceptions = exRep.ExceptionData.Table.Clone();
						}
						_rackNotTestedExceptions.Rows.Add(exRep.ExceptionData.ItemArray);
					}
				}

			}
		}

		private void tabTRW_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.tabTRW.SelectedTab == this.pageSymptoms)
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC021.FrmTransfusionReactionWorkup_Symptoms());
			}
			else
			{
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC021.FrmTransfusionReactionWorkup());
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmTransfusionReactionWorkup_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.tabTRW.SelectedTab == this.pageSpecimenChecks)
			{
				if (this.btnSpecimenOK.EnabledButton == false)
				{
					this.btnSpecimenOK_MouseHover(this, EventArgs.Empty);
					textToSpeak = this.btnSpecimenOK.GetToolTip();
				}
			}
			else if (this.tabTRW.SelectedTab == this.pageImplicatedUnits)
			{
				if (this.btnUnitsOK.EnabledButton == false)
				{
					this.btnUnitsOK_MouseHover(this, EventArgs.Empty);
					textToSpeak = this.btnUnitsOK.GetToolTip();
				}
			}
			else if (this.tabTRW.SelectedTab == this.pageSymptoms)
			{
				if (this.btnSymptomsOK.EnabledButton == false)
				{
					this.btnSymptomsOK_MouseHover(this, EventArgs.Empty);
					textToSpeak = this.btnSymptomsOK.GetToolTip();
				}
			}
			else if (this.tabTRW.SelectedTab == this.pageSerolgicTests)
			{
				if (this.btnTestsOK.EnabledButton == false)
				{
					this.btnTestsOK_MouseHover(this, EventArgs.Empty);
					textToSpeak = this.btnTestsOK.GetToolTip();
				}
			}
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}

			this.SpeakMessage( textToSpeak );	
		}

		private void grpBloodBagReturned_Enter(object sender, System.EventArgs e)
		{
		
		}

	}
}

